/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.Screens;
import doggytalents.common.entity.Dog;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class DoggyArmorTalent
extends TalentInstance {
    protected int tickUntilXPSearch;
    protected final int SEARCH_RADIUS = 2;
    protected int spareValue;
    private boolean mayNeedsDataUpgrade = false;

    public DoggyArmorTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public boolean hasRenderer() {
        return true;
    }

    @Override
    public void init(AbstractDog dogIn) {
    }

    @Override
    public void set(AbstractDog dog, int levelBefore) {
        if (dog.m_9236_().f_46443_) {
            return;
        }
        if (levelBefore > 0 && this.level() <= 0) {
            this.dropArmor(dog);
        }
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.m_128391_(dogIn.dogArmors().serializeNBT());
        compound.m_128405_("armors_spareXp", this.level);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        try {
            dogIn.dogArmors().deserializeNBT(compound);
            if (compound.m_128441_("armors_spareXp")) {
                this.spareValue = compound.m_128451_("armors_spareXp");
                this.mayNeedsDataUpgrade = false;
            } else {
                this.spareValue = 0;
                this.mayNeedsDataUpgrade = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onRead(AbstractDog dogIn, CompoundTag compound) {
        if (!this.mayNeedsDataUpgrade) {
            return;
        }
        try {
            if (compound.m_128425_("dogArmors", 9)) {
                dogIn.dogArmors().deserializeNBT(compound);
            }
            this.spareValue = compound.m_128451_("armors_spareXp");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void remove(AbstractDog dogIn) {
        if (dogIn.m_9236_().f_46443_) {
            return;
        }
    }

    private void dropArmor(AbstractDog dogIn) {
        for (int i = 0; i < dogIn.dogArmors().getSlots(); ++i) {
            Containers.m_18992_((Level)dogIn.m_9236_(), (double)dogIn.m_20185_(), (double)dogIn.m_20186_(), (double)dogIn.m_20189_(), (ItemStack)dogIn.dogArmors().getStackInSlot(i));
            dogIn.dogArmors().setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    @Override
    public InteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (playerIn.m_21205_().m_41720_() instanceof ArmorItem) {
            LivingEntity owner;
            if (!(dogIn instanceof Dog)) {
                return InteractionResult.PASS;
            }
            if (!worldIn.f_46443_ && (owner = dogIn.m_269323_()) instanceof ServerPlayer) {
                ServerPlayer sOwner = (ServerPlayer)owner;
                Screens.openArmorScreen(sOwner, (Dog)dogIn);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void tick(AbstractDog dog) {
        if (this.level() >= 3) {
            this.scanForXpAndRepair(dog);
        }
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        props.setCanWearArmor();
    }

    private void scanForXpAndRepair(AbstractDog dog) {
        if (dog.m_9236_().f_46443_) {
            return;
        }
        if (--this.tickUntilXPSearch <= 0) {
            this.tickUntilXPSearch = 10;
            Map.Entry entry = EnchantmentHelper.m_44839_((Enchantment)Enchantments.f_44962_, (LivingEntity)dog, ItemStack::m_41768_);
            if (entry == null) {
                return;
            }
            ItemStack itemstack = (ItemStack)entry.getValue();
            if (this.spareValue > 0) {
                int i = Math.min((int)((float)this.spareValue * itemstack.getXpRepairRatio()), itemstack.m_41773_());
                itemstack.m_41721_(itemstack.m_41773_() - i);
                this.spareValue = (int)((float)this.spareValue - (float)i / itemstack.getXpRepairRatio());
            }
            if (!itemstack.m_41768_()) {
                return;
            }
            List orbs = dog.m_9236_().m_45976_(ExperienceOrb.class, dog.m_20191_().m_82400_(2.0));
            for (ExperienceOrb x : orbs) {
                if (itemstack.m_41773_() <= 0) break;
                int j = Math.min((int)((float)x.m_20801_() * itemstack.getXpRepairRatio()), itemstack.m_41773_());
                itemstack.m_41721_(itemstack.m_41773_() - j);
                dog.m_7938_((Entity)x, 1);
                this.spareValue = (int)((float)this.spareValue + (float)j / itemstack.getXpRepairRatio());
                x.m_146870_();
            }
        }
    }
}

