/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.DoggyBlocks;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.api.registry.IDogBedMaterial;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.util.NBTUtil;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class DogBedUtil {
    private static final Random RANDOM = new Random(System.currentTimeMillis());

    public static void setBedVariant(DogBedTileEntity dogBedTileEntity, ItemStack stack) {
        Pair<ICasingMaterial, IBeddingMaterial> materials = DogBedUtil.getMaterials(stack);
        dogBedTileEntity.setCasing((ICasingMaterial)materials.getLeft());
        dogBedTileEntity.setBedding((IBeddingMaterial)materials.getRight());
    }

    public static ItemStack createRandomBed() {
        ICasingMaterial casing = DogBedMaterialManager.randomCasing();
        IBeddingMaterial bedding = DogBedMaterialManager.randomBedding();
        return DogBedUtil.createItemStack(casing, bedding);
    }

    public static Pair<ICasingMaterial, IBeddingMaterial> getMaterials(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("doggytalents");
        if (tag != null) {
            ICasingMaterial casingId = DogBedMaterialManager.getCasing(tag, "casingId");
            IBeddingMaterial beddingId = DogBedMaterialManager.getBedding(tag, "beddingId");
            return Pair.of((Object)casingId, (Object)beddingId);
        }
        return Pair.of((Object)DogBedMaterialManager.NaniCasing.NULL, (Object)DogBedMaterialManager.NaniBedding.NULL);
    }

    public static ItemStack createItemStack(ICasingMaterial casingId, IBeddingMaterial beddingId) {
        ItemStack stack = new ItemStack((ItemLike)DoggyBlocks.DOG_BED.get(), 1);
        CompoundTag tag = stack.m_41698_("doggytalents");
        NBTUtil.putRegistryValue(tag, "casingId", DogBedMaterialManager.getKey(casingId));
        NBTUtil.putRegistryValue(tag, "beddingId", DogBedMaterialManager.getKey(beddingId));
        return stack;
    }

    public static Optional<IBeddingMaterial> getBeddingFromStack(ItemStack stack) {
        return DogBedUtil.getBedMaterialFromStack(stack, DogBedMaterialManager::getBedding);
    }

    public static Optional<ICasingMaterial> getCasingFromStack(ItemStack stack) {
        return DogBedUtil.getBedMaterialFromStack(stack, DogBedMaterialManager::getCasing);
    }

    public static <T extends IDogBedMaterial> Optional<T> getBedMaterialFromStack(ItemStack stack, Function<ResourceLocation, T> bed_material_getter) {
        if (stack.m_41619_()) {
            return Optional.empty();
        }
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return Optional.empty();
        }
        BlockItem block_item = (BlockItem)item;
        Block block = block_item.m_40614_();
        if (block == null) {
            return Optional.empty();
        }
        ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        IDogBedMaterial material = (IDogBedMaterial)bed_material_getter.apply(id);
        if (material.isNani()) {
            return Optional.empty();
        }
        return material.getIngredient().filter(ingredient -> ingredient.test(stack)).map(x -> material);
    }

    public static ItemStack createItemStackForced(Block casing, Block bedding) {
        ItemStack stack = new ItemStack((ItemLike)DoggyBlocks.DOG_BED.get(), 1);
        CompoundTag tag = new CompoundTag();
        NBTUtil.putRegistryValue(tag, "casingId", ForgeRegistries.BLOCKS.getKey((Object)casing));
        NBTUtil.putRegistryValue(tag, "beddingId", ForgeRegistries.BLOCKS.getKey((Object)bedding));
        CompoundTag maintag = new CompoundTag();
        maintag.m_128365_("doggytalents", (Tag)tag);
        stack.m_41751_(maintag);
        return stack;
    }
}

