/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.chakra.handler;

import com.f1njo.sre.chakra.api.IChakra;
import com.f1njo.sre.chakra.impl.ChakraProvider;
import com.f1njo.sre.client.input.ClientInputHandler;
import com.f1njo.sre.client.input.ModKeyBindings;
import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.core.ModPotions;
import com.f1njo.sre.network.chakra.MessageChakraJump;
import com.f1njo.sre.network.chakra.MessageChakraJumpCharge;
import com.f1njo.sre.network.chakra.MessageConsumeChakra;
import com.f1njo.sre.network.chakra.MessageGainChakraControl;
import com.f1njo.sre.network.chakra.MessageToggleChakraControl;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ChakraControlLogic {
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        int airTicks;
        double zDir;
        double yaw;
        double xDir;
        BlockPos checkPos;
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K || event.phase != TickEvent.Phase.END) {
            return;
        }
        boolean jumpDown = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        boolean prevJumpDown = player.getEntityData().func_74767_n("prevJumpKeyDown");
        boolean jumpPressed = jumpDown && !prevJumpDown;
        player.getEntityData().func_74757_a("prevJumpKeyDown", jumpDown);
        if (!player.field_70170_p.field_72995_K || event.phase != TickEvent.Phase.END) {
            return;
        }
        IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
        if (chakra == null) {
            return;
        }
        if (player.func_70644_a(ModPotions.CHAKRA_EXHAUSTION)) {
            if (ClientInputHandler.chakraControlActive) {
                ClientInputHandler.chakraControlActive = false;
                player.getEntityData().func_74757_a("chakra_control_active", false);
            }
            player.getEntityData().func_74757_a("chakraJumpCharging", false);
            chakra.setChakraControlActive(false);
            player.field_70138_W = 0.6f;
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75100_b = false;
            }
            return;
        }
        if (!ClientInputHandler.chakraControlActive) {
            player.field_70138_W = 0.6f;
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75100_b = false;
            }
            return;
        }
        IPlayerStats statsCap = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        int control = statsCap != null ? statsCap.getChakraControl() : 0;
        int chakraDrain = 1;
        int drainTick = player.getEntityData().func_74762_e("chakraControlDrainTick");
        int drainInterval = MathHelper.func_76125_a((int)(1 + control * 19 / 100), (int)1, (int)20);
        BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u - 0.1, player.field_70161_v);
        Material materialBelow = player.field_70170_p.func_180495_p(pos).func_185904_a();
        if (materialBelow == Material.field_151586_h) {
            player.field_70181_x = 0.0;
            player.field_70122_E = true;
            if (++drainTick >= drainInterval) {
                if (chakra.getChakra() < chakraDrain) {
                    ClientInputHandler.chakraControlActive = false;
                    player.getEntityData().func_74757_a("chakra_control_active", false);
                    player.getEntityData().func_74768_a("chakraControlDrainTick", 0);
                    ModNetwork.sendToServer(new MessageToggleChakraControl());
                    return;
                }
                chakra.consumeChakra(chakraDrain);
                ModNetwork.INSTANCE.sendToServer((IMessage)new MessageConsumeChakra(chakraDrain));
                ModNetwork.INSTANCE.sendToServer((IMessage)new MessageGainChakraControl(chakraDrain));
                drainTick = 0;
            }
        }
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        boolean forward = settings.field_74351_w.func_151470_d();
        if (forward && (checkPos = new BlockPos(player.field_70165_t + (xDir = -Math.sin(yaw = Math.toRadians(player.field_70177_z))) * 0.5, player.field_70163_u, player.field_70161_v + (zDir = Math.cos(yaw)) * 0.5)) != null) {
            IBlockState state = player.field_70170_p.func_180495_p(checkPos);
            String blockName = state.func_177230_c().getRegistryName().toString();
            AxisAlignedBB box = state.func_185890_d((IBlockAccess)player.field_70170_p, checkPos);
            if (!blockName.equals("minecraft:grass_path") && !blockName.equals("minecraft:farmland") && box != null && box.field_72337_e - box.field_72338_b > 0.5) {
                float baseClimbSpeed = 0.12f;
                float bonus = 0.0075f;
                float climbSpeed = baseClimbSpeed;
                IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
                if (stats != null) {
                    climbSpeed += (float)stats.getSpeed() * bonus;
                }
                player.field_70181_x = climbSpeed;
                player.field_70143_R = 0.0f;
                if (++drainTick >= drainInterval) {
                    if (chakra.getChakra() < chakraDrain) {
                        ClientInputHandler.chakraControlActive = false;
                        player.getEntityData().func_74757_a("chakra_control_active", false);
                        player.getEntityData().func_74768_a("chakraControlDrainTick", 0);
                        ModNetwork.sendToServer(new MessageToggleChakraControl());
                        return;
                    }
                    chakra.consumeChakra(chakraDrain);
                    ModNetwork.INSTANCE.sendToServer((IMessage)new MessageConsumeChakra(chakraDrain));
                    ModNetwork.INSTANCE.sendToServer((IMessage)new MessageGainChakraControl(chakraDrain));
                    drainTick = 0;
                }
            }
        }
        boolean jumpKeyDown = ModKeyBindings.chakraJump.func_151470_d();
        boolean wasCharging = player.getEntityData().func_74767_n("chakraJumpCharging");
        boolean jumpUsed = player.getEntityData().func_74767_n("chakraJumpUsed");
        if (jumpKeyDown && !jumpUsed) {
            if (!wasCharging) {
                player.getEntityData().func_74757_a("chakraJumpCharging", true);
                player.getEntityData().func_74772_a("chakraJumpStart", System.currentTimeMillis());
            }
            ClientInputHandler.spawnChakraRing(player.field_70170_p, player.field_70165_t, player.field_70163_u + 0.1, player.field_70161_v);
            player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 2, 4, false, false));
            ModNetwork.sendToServer(new MessageChakraJumpCharge());
        } else if (wasCharging) {
            long start = player.getEntityData().func_74763_f("chakraJumpStart");
            float held = (float)(System.currentTimeMillis() - start) / 1000.0f;
            float maxHold = MathHelper.func_76131_a((float)((float)control / 100.0f * 10.0f), (float)0.0f, (float)10.0f);
            if ((held = Math.min(held, maxHold)) > 0.0f) {
                Vec3d look = player.func_70040_Z().func_72432_b();
                double forwardAmount = (double)held * 1.0;
                player.field_70159_w += look.field_72450_a * forwardAmount;
                player.field_70181_x = (double)(0.2f + held * 0.05f) + look.field_72448_b * forwardAmount * 0.5;
                player.field_70179_y += look.field_72449_c * forwardAmount;
                player.field_70143_R = 0.0f;
                int chakraCost = MathHelper.func_76123_f((float)(held * 10.0f));
                if (chakra.getChakra() >= chakraCost) {
                    chakra.consumeChakra(chakraCost);
                    ModNetwork.INSTANCE.sendToServer((IMessage)new MessageConsumeChakra(chakraCost));
                } else {
                    ClientInputHandler.chakraControlActive = false;
                    player.getEntityData().func_74757_a("chakra_control_active", false);
                    ModNetwork.sendToServer(new MessageToggleChakraControl());
                }
                ClientInputHandler.spawnChakraBurst(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v);
                ModNetwork.sendToServer(new MessageChakraJump(held));
                player.getEntityData().func_74757_a("chakraJumpUsed", true);
            }
            player.getEntityData().func_74757_a("chakraJumpCharging", false);
        }
        if (player.field_70122_E) {
            boolean enoughControl = control >= 10;
            player.getEntityData().func_74757_a("canDoubleJump", enoughControl);
            player.getEntityData().func_74757_a("chakraJumpUsed", false);
            player.getEntityData().func_74768_a("airTicks", 0);
        } else {
            airTicks = player.getEntityData().func_74762_e("airTicks");
            player.getEntityData().func_74768_a("airTicks", airTicks + 1);
        }
        if (jumpPressed && (airTicks = player.getEntityData().func_74762_e("airTicks")) > 2 && player.getEntityData().func_74767_n("canDoubleJump") && control >= 10) {
            if (chakra.getChakra() >= 5) {
                chakra.consumeChakra(5);
                ModNetwork.INSTANCE.sendToServer((IMessage)new MessageConsumeChakra(5));
                player.field_70181_x = 0.5;
                player.field_70143_R = 0.0f;
                ClientInputHandler.spawnChakraBurst(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v);
                player.getEntityData().func_74757_a("canDoubleJump", false);
            } else {
                ClientInputHandler.chakraControlActive = false;
            }
        }
        player.getEntityData().func_74768_a("chakraControlDrainTick", drainTick);
    }
}

