/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.chakra.handler;

import com.f1njo.sre.chakra.api.IChakra;
import com.f1njo.sre.chakra.impl.ChakraProvider;
import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.core.ModPotions;
import com.f1njo.sre.network.chakra.MessageSyncChakra;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class ChakraEventHandler {
    public static final ResourceLocation CHAKRA_ID = new ResourceLocation("sre", "chakra");
    private static final String NBT_GENTLE_FIST_REMAINDER = "chakraChannelsDamageRemainder";

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(CHAKRA_ID, (ICapabilityProvider)new ChakraProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K) {
            EntityPlayer player = event.player;
            if (player.field_70122_E) {
                player.getEntityData().func_74757_a("chakraJumpUsed", false);
            }
            IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
            IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
            if (chakra != null) {
                boolean channelsDamaged;
                int chakraAmount = chakra.getChakra();
                if (chakraAmount <= 0) {
                    boolean alreadyExhausted = player.func_70644_a(ModPotions.CHAKRA_EXHAUSTION);
                    player.func_70690_d(new PotionEffect(ModPotions.CHAKRA_EXHAUSTION, 500, 0, false, false));
                    if (!alreadyExhausted) {
                        TextComponentString msg = new TextComponentString(I18n.func_135052_a((String)"message.chakra_depleted", (Object[])new Object[0]));
                        msg.func_150256_b().func_150238_a(TextFormatting.RED);
                        player.func_145747_a((ITextComponent)msg);
                    }
                }
                boolean exhausted = player.func_70644_a(ModPotions.CHAKRA_EXHAUSTION);
                boolean controlActive = player.getEntityData().func_74767_n("chakra_control_active");
                boolean sharinganActive = stats != null && stats.isSharinganActive();
                boolean byakuganActive = stats != null && stats.isByakuganActive();
                boolean regenActive = player.getEntityData().func_74767_n("chakra_regen_active");
                boolean bl = channelsDamaged = ModPotions.CHAKRA_CHANNELS_DAMAGED != null && player.func_70644_a(ModPotions.CHAKRA_CHANNELS_DAMAGED);
                if (!channelsDamaged && player.getEntityData().func_74764_b(NBT_GENTLE_FIST_REMAINDER)) {
                    player.getEntityData().func_74780_a(NBT_GENTLE_FIST_REMAINDER, 0.0);
                }
                boolean syncStats = false;
                if (exhausted) {
                    if (controlActive || chakra.isChakraControlActive()) {
                        chakra.setChakraControlActive(false);
                        player.getEntityData().func_74757_a("chakra_control_active", false);
                        player.getEntityData().func_74757_a("chakraJumpCharging", false);
                        TextComponentString ctrlMsg = new TextComponentString(I18n.func_135052_a((String)"message.chakra_control_off", (Object[])new Object[0]));
                        ctrlMsg.func_150256_b().func_150238_a(TextFormatting.GRAY);
                        player.func_145747_a((ITextComponent)ctrlMsg);
                        controlActive = false;
                    }
                    if (stats != null) {
                        TextComponentString msg;
                        if (sharinganActive) {
                            stats.setSharinganActive(false);
                            msg = new TextComponentString(I18n.func_135052_a((String)"message.sharingan.deactivated", (Object[])new Object[0]));
                            msg.func_150256_b().func_150238_a(TextFormatting.GRAY);
                            player.func_145747_a((ITextComponent)msg);
                            sharinganActive = false;
                            syncStats = true;
                        }
                        if (byakuganActive) {
                            stats.setByakuganActive(false);
                            msg = new TextComponentString(I18n.func_135052_a((String)"message.byakugan.deactivated", (Object[])new Object[0]));
                            msg.func_150256_b().func_150238_a(TextFormatting.GRAY);
                            player.func_145747_a((ITextComponent)msg);
                            byakuganActive = false;
                            syncStats = true;
                        }
                    }
                    if (syncStats && player instanceof EntityPlayerMP) {
                        ModNetwork.sendTo(new MessageSyncStats(stats), (EntityPlayerMP)player);
                    }
                }
                if (!(controlActive || sharinganActive || channelsDamaged)) {
                    int regenTick = player.getEntityData().func_74762_e("chakraRegenTick");
                    if (++regenTick >= 20) {
                        if (chakra.getChakra() < chakra.getMaxChakra()) {
                            chakra.restoreChakra(1);
                        }
                        regenTick = 0;
                    }
                    player.getEntityData().func_74768_a("chakraRegenTick", regenTick);
                    if (regenActive) {
                        if (stats == null || stats.getNinjutsu() < 50) {
                            player.getEntityData().func_74757_a("chakra_regen_active", false);
                            player.func_184589_d(ModPotions.CHAKRA_REGEN);
                            regenActive = false;
                        } else {
                            int activeTick = player.getEntityData().func_74762_e("chakraRegenActiveTick");
                            if (++activeTick >= 20) {
                                int amount = Math.max(1, chakra.getMaxChakra() / 50);
                                chakra.restoreChakra(amount);
                                activeTick = 0;
                            }
                            if (!player.func_70644_a(ModPotions.CHAKRA_REGEN)) {
                                player.func_70690_d(new PotionEffect(ModPotions.CHAKRA_REGEN, Integer.MAX_VALUE, 0, false, false));
                            }
                            player.getEntityData().func_74768_a("chakraRegenActiveTick", activeTick);
                        }
                    } else if (player.func_70644_a(ModPotions.CHAKRA_REGEN)) {
                        player.func_184589_d(ModPotions.CHAKRA_REGEN);
                    }
                } else {
                    if ((sharinganActive || channelsDamaged) && player.getEntityData().func_74767_n("chakra_regen_active")) {
                        player.getEntityData().func_74757_a("chakra_regen_active", false);
                    }
                    player.getEntityData().func_74768_a("chakraRegenTick", 0);
                    player.getEntityData().func_74768_a("chakraRegenActiveTick", 0);
                    if (player.func_70644_a(ModPotions.CHAKRA_REGEN)) {
                        player.func_184589_d(ModPotions.CHAKRA_REGEN);
                    }
                }
                if (controlActive) {
                    if (!player.func_70644_a(ModPotions.CHAKRA_CONTROL)) {
                        player.func_70690_d(new PotionEffect(ModPotions.CHAKRA_CONTROL, Integer.MAX_VALUE, 0, false, false));
                    }
                } else if (player.func_70644_a(ModPotions.CHAKRA_CONTROL)) {
                    player.func_184589_d(ModPotions.CHAKRA_CONTROL);
                }
                if (player instanceof EntityPlayerMP) {
                    ModNetwork.INSTANCE.sendTo((IMessage)new MessageSyncChakra(chakra.getChakra(), chakra.getMaxChakra(), chakra.isChakraControlActive()), (EntityPlayerMP)player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer fallingPlayer = (EntityPlayer)event.getEntityLiving();
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer breakingPlayer = event.getEntityPlayer();
        if (breakingPlayer != null && breakingPlayer.func_70644_a(ModPotions.CHAKRA_EXHAUSTION)) {
            event.setNewSpeed(event.getNewSpeed() * 0.2f);
        }
    }
}

