/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.chakra.impl;

import com.f1njo.sre.chakra.api.IChakra;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class Chakra
implements IChakra,
INBTSerializable<NBTTagCompound> {
    private int chakra = 25;
    private int maxChakra = 25;
    private long lastSubstitutionUse = 0L;
    private boolean chakraControlActive = false;

    @Override
    public boolean isChakraControlActive() {
        return this.chakraControlActive;
    }

    @Override
    public void setChakraControlActive(boolean active) {
        this.chakraControlActive = active;
    }

    @Override
    public int getChakra() {
        return this.chakra;
    }

    @Override
    public int getMaxChakra() {
        return this.maxChakra;
    }

    @Override
    public void setChakra(int amount) {
        this.chakra = Math.min(amount, this.maxChakra);
    }

    @Override
    public void setMaxChakra(int max) {
        this.maxChakra = max;
    }

    @Override
    public void consumeChakra(int amount) {
        this.chakra = Math.max(0, this.chakra - amount);
    }

    @Override
    public void restoreChakra(int amount) {
        this.chakra = Math.min(this.maxChakra, this.chakra + amount);
    }

    @Override
    public long getLastSubstitutionUse() {
        return this.lastSubstitutionUse;
    }

    @Override
    public void setLastSubstitutionUse(long time) {
        this.lastSubstitutionUse = time;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Chakra", this.chakra);
        tag.func_74768_a("MaxChakra", this.maxChakra);
        tag.func_74772_a("LastSubstitutionUse", this.lastSubstitutionUse);
        tag.func_74757_a("ChakraControlActive", this.chakraControlActive);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.chakra = tag.func_74762_e("Chakra");
        this.maxChakra = tag.func_74762_e("MaxChakra");
        this.lastSubstitutionUse = tag.func_74763_f("LastSubstitutionUse");
        if (tag.func_74764_b("ChakraControlActive")) {
            this.chakraControlActive = tag.func_74767_n("ChakraControlActive");
        }
    }
}

