/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.client.input;

import com.f1njo.sre.chakra.api.IChakra;
import com.f1njo.sre.chakra.impl.ChakraProvider;
import com.f1njo.sre.client.gui.GuiPlayerStats;
import com.f1njo.sre.client.input.ModKeyBindings;
import com.f1njo.sre.client.particle.ParticleChakra;
import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.core.ModPotions;
import com.f1njo.sre.network.MessageDetonateSeals;
import com.f1njo.sre.network.chakra.MessageConsumeChakra;
import com.f1njo.sre.network.chakra.MessageToggleChakraControl;
import com.f1njo.sre.network.chakra.MessageToggleChakraRegen;
import com.f1njo.sre.network.jutsu.MessageSummonCompanion;
import com.f1njo.sre.network.jutsu.MessageToggleByakugan;
import com.f1njo.sre.network.jutsu.MessageToggleSharingan;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import com.f1njo.sre.stats.SharinganStage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ClientInputHandler {
    public static boolean chakraControlActive = false;

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        IPlayerStats stats;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (!"1".equals(player.getEntityData().func_74779_i("shinobi"))) {
            if (ModKeyBindings.openStatsGui.func_151468_f()) {
                TextComponentString msg = new TextComponentString(I18n.func_135052_a((String)"message.need_info_scroll", (Object[])new Object[0]));
                msg.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)msg);
            }
            return;
        }
        if (ModKeyBindings.chakraControl.func_151468_f()) {
            if (this.isChakraExhausted((EntityPlayer)player)) {
                return;
            }
            boolean regenActive = player.getEntityData().func_74767_n("chakra_regen_active");
            if (!chakraControlActive && regenActive) {
                TextComponentString warn = new TextComponentString(I18n.func_135052_a((String)"message.chakra_regen_block_control", (Object[])new Object[0]));
                warn.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)warn);
            } else {
                if (chakraControlActive) {
                    chakraControlActive = false;
                    player.getEntityData().func_74757_a("chakra_control_active", false);
                    player.getEntityData().func_74757_a("chakraJumpCharging", false);
                    IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
                    if (chakra != null) {
                        chakra.setChakraControlActive(false);
                    }
                }
                ModNetwork.sendToServer(new MessageToggleChakraControl());
            }
        }
        if (ModKeyBindings.substitutionJutsu.func_151468_f()) {
            if (this.isChakraExhausted((EntityPlayer)player)) {
                return;
            }
            IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
            if (chakra != null) {
                long now = System.currentTimeMillis();
                if (now - chakra.getLastSubstitutionUse() < 5000L) {
                    TextComponentString msgCd = new TextComponentString(I18n.func_135052_a((String)"message.substitution_jutsu_cd", (Object[])new Object[0]));
                    msgCd.func_150256_b().func_150238_a(TextFormatting.RED);
                    player.func_145747_a((ITextComponent)msgCd);
                    return;
                }
                if (chakra.getChakra() >= 15) {
                    BlockPos pos = player.func_180425_c();
                    player.field_70170_p.func_175656_a(pos, Blocks.field_150364_r.func_176223_P());
                    this.spawnSmoke(player.field_70170_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                    Vec3d look = player.func_70040_Z().func_72432_b();
                    Vec3d backward = player.func_174791_d().func_178788_d(look.func_186678_a(10.0));
                    player.func_70634_a(backward.field_72450_a, backward.field_72448_b, backward.field_72449_c);
                    this.spawnSmoke(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    player.field_70172_ad = 40;
                    chakra.setLastSubstitutionUse(now);
                    ModNetwork.INSTANCE.sendToServer((IMessage)new MessageConsumeChakra(15));
                    TextComponentString msgOn = new TextComponentString(I18n.func_135052_a((String)"message.substitution_jutsu_on", (Object[])new Object[0]));
                    msgOn.func_150256_b().func_150238_a(TextFormatting.GREEN);
                    player.func_145747_a((ITextComponent)msgOn);
                } else {
                    TextComponentString msgCh = new TextComponentString(I18n.func_135052_a((String)"message.not_enough_chakra", (Object[])new Object[0]));
                    msgCh.func_150256_b().func_150238_a(TextFormatting.RED);
                    player.func_145747_a((ITextComponent)msgCh);
                }
            }
        }
        if (ModKeyBindings.detonateSeals.func_151468_f()) {
            ModNetwork.INSTANCE.sendToServer((IMessage)new MessageDetonateSeals());
        }
        if (ModKeyBindings.openStatsGui.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPlayerStats());
        }
        if (ModKeyBindings.activateSharingan.func_151468_f()) {
            if (this.isChakraExhausted((EntityPlayer)player)) {
                return;
            }
            IPlayerStats stats2 = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
            if (stats2 != null) {
                if (stats2.getSharinganStage() == SharinganStage.T0) {
                    TextComponentString warn = new TextComponentString(I18n.func_135052_a((String)"message.sharingan.not_awakened", (Object[])new Object[0]));
                    warn.func_150256_b().func_150238_a(TextFormatting.RED);
                    player.func_145747_a((ITextComponent)warn);
                } else if (stats2.getSharinganStage().canActivate()) {
                    ModNetwork.sendToServer(new MessageToggleSharingan());
                } else {
                    TextComponentString warn = new TextComponentString(I18n.func_135052_a((String)"message.sharingan.unavailable", (Object[])new Object[0]));
                    warn.func_150256_b().func_150238_a(TextFormatting.RED);
                    player.func_145747_a((ITextComponent)warn);
                }
            }
        }
        if (ModKeyBindings.activateByakugan.func_151468_f()) {
            if (this.isChakraExhausted((EntityPlayer)player)) {
                return;
            }
            IPlayerStats stats3 = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
            if (stats3 != null) {
                if (stats3.getByakuganStage().canActivate()) {
                    ModNetwork.sendToServer(new MessageToggleByakugan());
                } else {
                    TextComponentString warn = new TextComponentString(I18n.func_135052_a((String)"message.byakugan.unavailable", (Object[])new Object[0]));
                    warn.func_150256_b().func_150238_a(TextFormatting.RED);
                    player.func_145747_a((ITextComponent)warn);
                }
            }
        }
        if (ModKeyBindings.summonCompanion.func_151468_f() && (stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null)) != null) {
            if (stats.getKuchiyose() >= 100) {
                ModNetwork.sendToServer(new MessageSummonCompanion());
            } else {
                TextComponentString warn = new TextComponentString(I18n.func_135052_a((String)"message.summon.requirement", (Object[])new Object[]{100}));
                warn.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)warn);
            }
        }
        if (ModKeyBindings.chakraRegen.func_151468_f()) {
            if (player.getEntityData().func_74767_n("chakra_control_active")) {
                TextComponentString warn = new TextComponentString(I18n.func_135052_a((String)"message.chakra_control_block_regen", (Object[])new Object[0]));
                warn.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)warn);
            } else {
                stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
                if (stats != null && stats.isSharinganActive()) {
                    TextComponentString warn = new TextComponentString(I18n.func_135052_a((String)"message.sharingan_block_regen", (Object[])new Object[0]));
                    warn.func_150256_b().func_150238_a(TextFormatting.RED);
                    player.func_145747_a((ITextComponent)warn);
                } else {
                    ModNetwork.sendToServer(new MessageToggleChakraRegen());
                }
            }
        }
    }

    private boolean isChakraExhausted(EntityPlayer player) {
        if (player.func_70644_a(ModPotions.CHAKRA_EXHAUSTION)) {
            TextComponentString warn = new TextComponentString(I18n.func_135052_a((String)"message.chakra_exhaustion_blocked", (Object[])new Object[0]));
            warn.func_150256_b().func_150238_a(TextFormatting.RED);
            player.func_145747_a((ITextComponent)warn);
            return true;
        }
        return false;
    }

    private void spawnSmoke(World world, double x, double y, double z) {
        if (world.field_72995_K) {
            for (int i = 0; i < 50; ++i) {
                double offsetX = (Math.random() - 0.5) * 1.0;
                double offsetY = Math.random() * 1.5;
                double offsetZ = (Math.random() - 0.5) * 1.0;
                double motionX = (Math.random() - 0.5) * 0.1;
                double motionY = 0.2 + Math.random() * 0.1;
                double motionZ = (Math.random() - 0.5) * 0.1;
                world.func_175688_a(EnumParticleTypes.CLOUD, x + offsetX, y + offsetY, z + offsetZ, motionX, motionY, motionZ, new int[0]);
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        IPlayerStats stats;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        EntityPlayerSP player = mc.field_71439_g;
        if (chakraControlActive) {
            double x = player.field_70165_t;
            double y = player.field_70163_u + 0.01;
            double z = player.field_70161_v;
            double radius = 0.25;
            for (int i = 0; i < 2; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double distance = Math.sqrt(Math.random()) * radius;
                double offsetX = Math.cos(angle) * distance;
                double offsetZ = Math.sin(angle) * distance;
                double offsetY = (Math.random() - 0.5) * 0.05;
                mc.field_71452_i.func_78873_a((Particle)new ParticleChakra((World)mc.field_71441_e, x + offsetX, y + offsetY, z + offsetZ));
            }
        }
        if ((stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null)) == null || stats.isSharinganActive()) {
            // empty if block
        }
    }

    public static void spawnChakraBurst(World world, double x, double y, double z) {
        if (world.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                double offsetX = (Math.random() - 0.5) * 0.3;
                double offsetY = (Math.random() - 0.5) * 0.2;
                double offsetZ = (Math.random() - 0.5) * 0.3;
                double motionX = (Math.random() - 0.5) * 0.8;
                double motionY = Math.random() * 0.5;
                double motionZ = (Math.random() - 0.5) * 0.8;
                world.func_175688_a(EnumParticleTypes.CLOUD, x + offsetX, y + offsetY, z + offsetZ, motionX, motionY, motionZ, new int[0]);
            }
        }
    }

    public static void spawnChakraRing(World world, double x, double y, double z) {
        if (world.field_72995_K) {
            double radius = 0.6;
            for (int i = 0; i < 20; ++i) {
                double angle = Math.PI * 2 * (double)i / 20.0;
                double px = x + Math.cos(angle) * radius;
                double pz = z + Math.sin(angle) * radius;
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleChakra(world, px, y, pz));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        chakraControlActive = false;
    }
}

