/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.client.render;

import com.f1njo.sre.chakra.api.IChakra;
import com.f1njo.sre.chakra.impl.ChakraProvider;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ChakraHUDRenderer {
    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || !player.func_70089_S()) {
            return;
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null || !stats.isShinobi()) {
            return;
        }
        IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
        if (chakra == null) {
            return;
        }
        int chakraNow = chakra.getChakra();
        int chakraMax = chakra.getMaxChakra();
        ScaledResolution res = new ScaledResolution(mc);
        int barWidth = 100;
        int barHeight = 8;
        int x = 6;
        int y = res.func_78328_b() - 15;
        float percent = (float)chakraNow / (float)chakraMax;
        int fill = (int)((float)barWidth * percent);
        this.drawRect(x, y, x + barWidth, y + barHeight, Integer.MIN_VALUE);
        this.drawRect(x, y, x + fill, y + barHeight, -16745473);
        String text = chakraNow + " / " + chakraMax;
        FontRenderer font = mc.field_71466_p;
        int textX = x + (barWidth - font.func_78256_a(text)) / 2;
        int textY = y - 1;
        font.func_175063_a(text, (float)textX, (float)textY, 0xFFFFFF);
        boolean charging = player.getEntityData().func_74767_n("chakraJumpCharging");
        if (charging) {
            long start = player.getEntityData().func_74763_f("chakraJumpStart");
            float held = (float)(System.currentTimeMillis() - start) / 1000.0f;
            stats = PlayerStatsProvider.get((EntityPlayer)player);
            float maxHold = 10.0f;
            if (stats != null) {
                maxHold = MathHelper.func_76131_a((float)((float)stats.getChakraControl() / 100.0f * 10.0f), (float)0.0f, (float)10.0f);
            }
            held = MathHelper.func_76131_a((float)held, (float)0.0f, (float)maxHold);
            String timer = String.format("%.1fs", Float.valueOf(held));
            int centerX = res.func_78326_a() / 2;
            int timerY = res.func_78328_b() - 55;
            font.func_175063_a(timer, (float)(centerX - font.func_78256_a(timer) / 2), (float)timerY, 0xFFFFFF);
        } else if (player.getEntityData().func_74767_n("intelligenceReading")) {
            long start = player.getEntityData().func_74763_f("intelligenceStart");
            int duration = player.getEntityData().func_74762_e("intelligenceDuration");
            float total = (float)duration / 20.0f;
            float elapsed = (float)(System.currentTimeMillis() - start) / 1000.0f;
            float remaining = MathHelper.func_76131_a((float)(total - elapsed), (float)0.0f, (float)total);
            String timer = String.format("%.1f / %.1fs", Float.valueOf(remaining), Float.valueOf(total));
            int centerX = res.func_78326_a() / 2;
            int timerY = res.func_78328_b() - 55;
            font.func_175063_a(timer, (float)(centerX - font.func_78256_a(timer) / 2), (float)timerY, 0xFFFFFF);
        }
    }

    private void drawRect(int left, int top, int right, int bottom, int color) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
        GlStateManager.func_187447_r((int)7);
        GlStateManager.func_187435_e((float)left, (float)bottom, (float)0.0f);
        GlStateManager.func_187435_e((float)right, (float)bottom, (float)0.0f);
        GlStateManager.func_187435_e((float)right, (float)top, (float)0.0f);
        GlStateManager.func_187435_e((float)left, (float)top, (float)0.0f);
        GlStateManager.func_187437_J();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

