/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HealthHUDRenderer
extends Gui {
    @SubscribeEvent
    public void onRenderPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH) {
            return;
        }
        event.setCanceled(true);
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        ScaledResolution res = event.getResolution();
        int curHealth = MathHelper.func_76123_f((float)player.func_110143_aJ());
        int maxHealth = MathHelper.func_76123_f((float)player.func_110138_aP());
        int fullRows = curHealth / 20;
        int healthInRow = curHealth % 20;
        if (healthInRow == 0 && curHealth > 0) {
            healthInRow = 20;
            --fullRows;
        }
        int hearts = MathHelper.func_76123_f((float)((float)Math.min(maxHealth - fullRows * 20, 20) / 2.0f));
        int baseX = res.func_78326_a() / 2 - 91;
        int y = res.func_78328_b() - 39;
        if (fullRows > 0) {
            String text = fullRows + "x";
            int w = mc.field_71466_p.func_78256_a(text);
            mc.field_71466_p.func_175063_a(text, (float)(baseX - w - 2), (float)(y - 1), 0xFFFFFF);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        mc.func_110434_K().func_110577_a(field_110324_m);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int ticks = player.field_70173_aa;
        boolean flash = player.field_70172_ad > 0 && player.field_70172_ad / 3 % 2 == 1;
        boolean regen = player.func_70644_a(MobEffects.field_76428_l);
        int regenIndex = regen ? ticks / 2 % hearts : -1;
        for (int i = 0; i < hearts; ++i) {
            int hx = baseX + i * 8;
            int hy = y;
            if (i == regenIndex) {
                --hy;
            }
            if (flash) {
                --hy;
            }
            this.func_73729_b(hx, hy, 16, 0, 9, 9);
            float heartHP = healthInRow - i * 2;
            if (heartHP >= 2.0f) {
                this.func_73729_b(hx, hy, 52, 0, 9, 9);
                continue;
            }
            if (!(heartHP >= 1.0f)) continue;
            this.func_73729_b(hx, hy, 61, 0, 9, 9);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179121_F();
        if (mc.field_71456_v instanceof GuiIngameForge) {
            GuiIngameForge.left_height += 10;
        }
    }
}

