/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.client.render.layers;

import com.f1njo.sre.client.render.jutsu.RenderShadowClone;
import com.f1njo.sre.entities.jutsu.EntityShadowClone;
import com.f1njo.sre.items.armor.models.ModelEyes;
import com.f1njo.sre.stats.Clan;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class LayerCloneEyes
implements LayerRenderer<EntityShadowClone> {
    private final RenderShadowClone renderer;
    private static final ResourceLocation EIGHT_GATES_EYES = new ResourceLocation("sre:textures/entity/eyes/other/eight_gates.png");
    private static final ResourceLocation SHARINGAN_1 = new ResourceLocation("sre:textures/entity/eyes/dojutsu/sharingan1.png");
    private static final ResourceLocation SHARINGAN_2 = new ResourceLocation("sre:textures/entity/eyes/dojutsu/sharingan2.png");
    private static final ResourceLocation SHARINGAN_3 = new ResourceLocation("sre:textures/entity/eyes/dojutsu/sharingan3.png");
    private static final ResourceLocation BYAKUGAN = new ResourceLocation("sre:textures/entity/eyes/dojutsu/byakugan.png");
    private final ModelEyes model = new ModelEyes();

    public LayerCloneEyes(RenderShadowClone renderer) {
        this.renderer = renderer;
    }

    public void doRenderLayer(EntityShadowClone entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ResourceLocation defaultEyes;
        Clan clan;
        EntityPlayer owner = entity.getOwner();
        if (owner == null) {
            return;
        }
        AbstractClientPlayer clientPlayer = (AbstractClientPlayer)Minecraft.func_71410_x().field_71441_e.func_152378_a(owner.func_110124_au());
        if (clientPlayer == null) {
            return;
        }
        GlStateManager.func_179094_E();
        IPlayerStats stats = PlayerStatsProvider.get((EntityPlayer)clientPlayer);
        boolean sharingan = stats != null && stats.isSharinganActive();
        boolean byakugan = stats != null && stats.isByakuganActive();
        int sharinganStage = stats != null ? stats.getSharinganStage().ordinal() : 0;
        Clan clan2 = clan = stats != null ? stats.getClan() : Clan.UNKNOWN;
        if (clan == Clan.UCHIHA) {
            defaultEyes = new ResourceLocation("sre:textures/entity/eyes/other/uchiha.png");
        } else if (clan == Clan.HYUGA) {
            defaultEyes = new ResourceLocation("sre:textures/entity/eyes/other/hyuga.png");
        } else {
            String textureName = stats != null ? stats.getEyeTexture() : "blue";
            defaultEyes = new ResourceLocation("sre:textures/entity/eyes/" + textureName + ".png");
        }
        ResourceLocation selectedTexture = defaultEyes;
        int gatesLevel = owner.getEntityData().func_74762_e("eightGatesLevel");
        if (gatesLevel >= 3) {
            selectedTexture = EIGHT_GATES_EYES;
        } else if (sharingan) {
            switch (sharinganStage) {
                case 2: {
                    selectedTexture = SHARINGAN_1;
                    break;
                }
                case 3: {
                    selectedTexture = SHARINGAN_2;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    selectedTexture = SHARINGAN_3;
                    break;
                }
                default: {
                    selectedTexture = defaultEyes;
                    break;
                }
            }
        } else if (byakugan) {
            selectedTexture = BYAKUGAN;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(selectedTexture);
        this.model.func_78086_a((EntityLivingBase)entity, limbSwing, limbSwingAmount, partialTicks);
        this.model.func_178686_a(this.renderer.func_177087_b());
        this.model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        GlStateManager.func_179121_F();
    }

    public boolean func_177142_b() {
        return false;
    }
}

