/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.commands;

import com.f1njo.sre.chakra.api.IChakra;
import com.f1njo.sre.chakra.impl.ChakraProvider;
import com.f1njo.sre.commands.ModCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class CommandChakra
extends ModCommand {
    public String func_71517_b() {
        return "chakra";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/chakra - show chakra\n/chakra add <player> <amount>\n/chakra remove <player> <amount>\n/chakra set <player> <amount>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!this.commandsAllowed(server)) {
            return;
        }
        if (args.length == 0) {
            if (sender instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)sender;
                IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
                if (chakra != null) {
                    this.sendMessage(sender, "Chakra: " + chakra.getChakra() + " / " + chakra.getMaxChakra(), TextFormatting.AQUA);
                } else {
                    this.sendError(sender, "Error: chakra not found.");
                }
            } else {
                this.sendError(sender, "This command can only be used by a player.");
            }
        } else if (args.length == 3) {
            int amount;
            String action = args[0];
            String targetName = args[1];
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                this.sendError(sender, "Error: amount must be a number.");
                return;
            }
            EntityPlayerMP target = server.func_184103_al().func_152612_a(targetName);
            if (target == null) {
                this.sendError(sender, "Player '" + targetName + "' not found.");
                return;
            }
            IChakra chakra = (IChakra)target.getCapability(ChakraProvider.CHAKRA_CAP, null);
            if (chakra == null) {
                this.sendError(sender, "Error: player's chakra not found.");
                return;
            }
            switch (action.toLowerCase()) {
                case "add": {
                    chakra.setChakra(chakra.getChakra() + amount);
                    this.sendSuccess(sender, "Added " + amount + " chakra to player " + target.func_70005_c_() + ".");
                    this.sendSuccess((ICommandSender)target, "You received " + amount + " chakra.");
                    break;
                }
                case "remove": {
                    chakra.setChakra(Math.max(0, chakra.getChakra() - amount));
                    this.sendError(sender, "Removed " + amount + " chakra from player " + target.func_70005_c_() + ".");
                    this.sendError((ICommandSender)target, "Removed from you " + amount + " chakra.");
                    break;
                }
                case "set": {
                    chakra.setChakra(amount);
                    this.sendInfo(sender, "Set player " + target.func_70005_c_() + "'s chakra to " + amount + ".");
                    this.sendInfo((ICommandSender)target, "Your chakra was set to " + amount + ".");
                    break;
                }
                default: {
                    this.sendError(sender, "Unknown action. Use: add, remove, set");
                    break;
                }
            }
        } else {
            this.sendError(sender, "Invalid syntax. Use /chakra, /chakra add <player> <amount>, /chakra remove <player> <amount>, /chakra set <player> <amount>");
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandChakra.func_175762_a((String[])args, Arrays.asList("add", "set", "remove"));
        }
        if (args.length == 2 && Arrays.asList("add", "set", "remove").contains(args[0].toLowerCase())) {
            return CommandChakra.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 3) {
            return CommandChakra.func_175762_a((String[])args, Arrays.asList("10", "50", "100", "500"));
        }
        return Collections.emptyList();
    }
}

