/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.commands;

import com.f1njo.sre.commands.ModCommand;
import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.Element;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandElement
extends ModCommand {
    public String func_71517_b() {
        return "element";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/element add <player> <element>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!this.commandsAllowed(server)) {
            return;
        }
        if (args.length != 3 || !"add".equalsIgnoreCase(args[0])) {
            this.sendError(sender, "Usage: /element add <player> <element>");
            return;
        }
        String playerName = args[1];
        String elementName = args[2].toUpperCase();
        EntityPlayerMP target = server.func_184103_al().func_152612_a(playerName);
        if (target == null) {
            this.sendError(sender, "Player not found: " + playerName);
            return;
        }
        IPlayerStats stats = (IPlayerStats)target.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null) {
            this.sendError(sender, "Failed to get player stats.");
            return;
        }
        try {
            Element element = Element.valueOf(elementName);
            stats.addElement(element);
            ModNetwork.sendTo(new MessageSyncStats(stats), target);
            this.sendSuccess(sender, "Player " + target.func_70005_c_() + " was given element " + element.name());
            this.sendInfo((ICommandSender)target, "You received element " + element.name());
        }
        catch (IllegalArgumentException e) {
            this.sendError(sender, "Element not found: " + elementName);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            return CommandElement.func_175762_a((String[])args, Arrays.asList("add"));
        }
        if (args.length == 2) {
            return CommandElement.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 3) {
            return CommandElement.func_175762_a((String[])args, Arrays.asList("EARTH", "WATER", "FIRE", "WIND", "LIGHTNING"));
        }
        return Collections.emptyList();
    }
}

