/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.commands;

import com.f1njo.sre.commands.ModCommand;
import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandExp
extends ModCommand {
    public String func_71517_b() {
        return "exp";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/exp <add|set|get> <player> [amount]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!this.commandsAllowed(server)) {
            return;
        }
        if (args.length < 2) {
            this.sendError(sender, "Usage: /exp <add|set|get> <player> [amount]");
            return;
        }
        String action = args[0];
        String playerName = args[1];
        EntityPlayerMP player = server.func_184103_al().func_152612_a(playerName);
        if (player == null) {
            this.sendError(sender, "Player not found: " + playerName);
            return;
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null) {
            this.sendError(sender, "Failed to get player stats.");
            return;
        }
        switch (action.toLowerCase()) {
            case "get": {
                this.sendInfo(sender, playerName + " -> Level: " + stats.getLevel() + " | EXP: " + stats.getExp());
                break;
            }
            case "add": {
                if (args.length < 3) {
                    this.sendError(sender, "Usage: /exp add <player> <amount>");
                    return;
                }
                try {
                    int amount = Integer.parseInt(args[2]);
                    stats.addExp(amount, player);
                    this.sendSuccess(sender, "Added " + amount + " experience to " + playerName);
                }
                catch (NumberFormatException e) {
                    this.sendError(sender, "Invalid number: " + args[2]);
                }
                break;
            }
            case "set": {
                if (args.length < 3) {
                    this.sendError(sender, "Usage: /exp set <player> <amount>");
                    return;
                }
                try {
                    int amount = Integer.parseInt(args[2]);
                    stats.setExp(amount);
                    ModNetwork.sendTo(new MessageSyncStats(stats), player);
                    this.sendInfo(sender, "Player " + playerName + "'s EXP set to " + amount);
                }
                catch (NumberFormatException e) {
                    this.sendError(sender, "Invalid number: " + args[2]);
                }
                break;
            }
            default: {
                this.sendError(sender, "Unknown action: " + action);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            return CommandExp.func_175762_a((String[])args, Arrays.asList("get", "add", "set"));
        }
        if (args.length == 2) {
            return CommandExp.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return Collections.emptyList();
    }
}

