/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.commands;

import com.f1njo.sre.commands.ModCommand;
import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.Clan;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandEyes
extends ModCommand {
    private static final List<String> COLORS = Arrays.asList("blue", "blue_dark", "brown", "brown_dark", "gray", "gray_dark", "green", "green_dark");

    public String func_71517_b() {
        return "eyes";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/eyes <color>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!this.commandsAllowed(server)) {
            return;
        }
        if (!(sender instanceof EntityPlayer)) {
            this.sendError(sender, "This command can only be used by a player.");
            return;
        }
        if (args.length != 1) {
            this.sendError(sender, "Usage: /eyes <color>");
            return;
        }
        String color = args[0].toLowerCase();
        if (!COLORS.contains(color)) {
            this.sendError(sender, "Unknown eye color: " + color);
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null) {
            this.sendError(sender, "Failed to get player stats.");
            return;
        }
        Clan clan = stats.getClan();
        if (clan == Clan.UCHIHA || clan == Clan.HYUGA) {
            this.sendError(sender, "Your clan's eye texture cannot be changed.");
            return;
        }
        stats.setEyeTexture(color);
        ModNetwork.sendTo(new MessageSyncStats(stats), (EntityPlayerMP)player);
        this.sendSuccess(sender, "Eye color set to " + color);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandEyes.func_175762_a((String[])args, COLORS);
        }
        return Collections.emptyList();
    }
}

