/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.commands;

import com.f1njo.sre.commands.ModCommand;
import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import com.f1njo.sre.stats.Rank;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandRank
extends ModCommand {
    public String func_71517_b() {
        return "rank";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/rank set <player> <rank>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!this.commandsAllowed(server)) {
            return;
        }
        if (args.length != 3 || !"set".equalsIgnoreCase(args[0])) {
            this.sendError(sender, "Usage: /rank set <player> <rank>");
            return;
        }
        String playerName = args[1];
        String rankName = args[2].toUpperCase();
        EntityPlayerMP target = server.func_184103_al().func_152612_a(playerName);
        if (target == null) {
            this.sendError(sender, "Player not found: " + playerName);
            return;
        }
        IPlayerStats stats = (IPlayerStats)target.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null) {
            this.sendError(sender, "Failed to get player stats.");
            return;
        }
        try {
            Rank rank = Rank.valueOf(rankName);
            stats.setRank(rank);
            ModNetwork.sendTo(new MessageSyncStats(stats), target);
            this.sendSuccess(sender, "Player " + target.func_70005_c_() + "'s rank set to " + rank.name());
            this.sendInfo((ICommandSender)target, "Your rank was set to " + rank.name());
        }
        catch (IllegalArgumentException e) {
            this.sendError(sender, "Rank not found: " + rankName);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandRank.func_175762_a((String[])args, Arrays.asList("set"));
        }
        if (args.length == 2) {
            return CommandRank.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 3) {
            List rankNames = Arrays.stream(Rank.values()).map(Enum::name).collect(Collectors.toList());
            return CommandRank.func_175762_a((String[])args, rankNames);
        }
        return Collections.emptyList();
    }
}

