/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.commands;

import com.f1njo.sre.chakra.handler.ChakraHandler;
import com.f1njo.sre.commands.ModCommand;
import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatEvents;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandStats
extends ModCommand {
    private static final String[] STAT_NAMES = new String[]{"ninjutsu", "taijutsu", "genjutsu", "bukijutsu", "shurikenjutsu", "kinjutsu", "fuinjutsu", "kuchiyose", "iryo", "senjutsu", "speed", "intelligence", "chakracontrol", "level", "exp", "skillpoints", "elements"};

    public String func_71517_b() {
        return "stats";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/stats <stat> <value>\n/stats <player> <stat> <value>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int value;
        int index;
        EntityPlayerMP target;
        if (!this.commandsAllowed(server)) {
            return;
        }
        if (args.length == 2) {
            if (!(sender instanceof EntityPlayerMP)) {
                this.sendError(sender, "This command can only be used by a player.");
                return;
            }
            target = (EntityPlayerMP)sender;
            index = 0;
        } else if (args.length == 3) {
            target = server.func_184103_al().func_152612_a(args[0]);
            if (target == null) {
                this.sendError(sender, "Player not found: " + args[0]);
                return;
            }
            index = 1;
        } else {
            this.sendError(sender, "Usage: /stats <stat> <value> or /stats <player> <stat> <value>");
            return;
        }
        String stat = args[index].toLowerCase();
        try {
            value = Integer.parseInt(args[index + 1]);
        }
        catch (NumberFormatException e) {
            this.sendError(sender, "Invalid number: " + args[index + 1]);
            return;
        }
        IPlayerStats stats = (IPlayerStats)target.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null) {
            this.sendError(sender, "Failed to get player stats.");
            return;
        }
        switch (stat) {
            case "ninjutsu": {
                stats.setNinjutsu(value);
                break;
            }
            case "taijutsu": {
                stats.setTaijutsu(value);
                break;
            }
            case "genjutsu": {
                stats.setGenjutsu(value);
                break;
            }
            case "bukijutsu": {
                stats.setBukijutsu(value);
                break;
            }
            case "shurikenjutsu": {
                stats.setShurikenjutsu(value);
                break;
            }
            case "kinjutsu": {
                stats.setKinjutsu(value);
                break;
            }
            case "fuinjutsu": {
                stats.setFuinjutsu(value);
                break;
            }
            case "kuchiyose": {
                stats.setKuchiyose(value);
                break;
            }
            case "iryo": {
                stats.setIryo(value);
                break;
            }
            case "senjutsu": {
                stats.setSenjutsu(value);
                break;
            }
            case "speed": {
                stats.setSpeed(value);
                break;
            }
            case "intelligence": {
                stats.setIntelligence(value);
                break;
            }
            case "chakracontrol": {
                stats.setChakraControl(value);
                break;
            }
            case "level": {
                stats.setLevel(value);
                break;
            }
            case "exp": {
                stats.setExp(value);
                break;
            }
            case "skillpoints": {
                stats.setSkillPoints(value);
                break;
            }
            case "elements": {
                stats.setElements(value);
                break;
            }
            default: {
                this.sendError(sender, "Unknown stat: " + stat);
                return;
            }
        }
        ChakraHandler.syncChakraToNinjutsu((EntityPlayer)target);
        ModNetwork.sendTo(new MessageSyncStats(stats), target);
        if (stats.isShinobi()) {
            target.getEntityData().func_74778_a("shinobi", "1");
        }
        PlayerStatEvents.applyHealthToPlayer((EntityPlayer)target);
        PlayerStatEvents.applySpeedToPlayer((EntityPlayer)target);
        this.sendSuccess(sender, "Set " + target.func_70005_c_() + "'s " + stat + " to " + value);
        if (sender != target) {
            this.sendInfo((ICommandSender)target, "Your " + stat + " was set to " + value);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>();
            Collections.addAll(options, STAT_NAMES);
            options.addAll(Arrays.asList(server.func_71213_z()));
            return CommandStats.func_175762_a((String[])args, options);
        }
        if (args.length == 2 && Arrays.asList(server.func_71213_z()).contains(args[0])) {
            return CommandStats.func_175762_a((String[])args, Arrays.asList(STAT_NAMES));
        }
        return Collections.emptyList();
    }
}

