/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.commands;

import com.f1njo.sre.commands.ModCommand;
import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.entities.npc.SummonBeast;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandSwapSummon
extends ModCommand {
    private static final List<String> SUMMON_NAMES = Arrays.stream(SummonBeast.values()).map(Enum::name).collect(Collectors.toList());
    private static final String OPTION_NONE = "NONE";

    public String func_71517_b() {
        return "swapsummon";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/swapsummon <beast|NONE>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!this.commandsAllowed(server)) {
            return;
        }
        if (!(sender instanceof EntityPlayer)) {
            this.sendError(sender, "This command can only be used by a player.");
            return;
        }
        if (args.length != 1) {
            this.sendError(sender, "Usage: /swapsummon <beast|NONE>");
            return;
        }
        SummonBeast beast = null;
        if (!OPTION_NONE.equalsIgnoreCase(args[0]) && (beast = SummonBeast.fromString(args[0])) == null) {
            this.sendError(sender, "Unknown summon beast: " + args[0]);
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null) {
            this.sendError(sender, "Failed to access player stats.");
            return;
        }
        stats.setSummonBeast(beast);
        ModNetwork.sendTo(new MessageSyncStats(stats), (EntityPlayerMP)player);
        if (beast == null) {
            this.sendSuccess(sender, "Summon contract cleared.");
        } else {
            this.sendSuccess(sender, "Summon set to " + beast.getDisplayName());
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>(SUMMON_NAMES);
            options.add(OPTION_NONE);
            return CommandSwapSummon.func_175762_a((String[])args, options);
        }
        return Collections.emptyList();
    }
}

