/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu;

import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.entities.ai.EntityAIAttackMeleeCustom;
import com.f1njo.sre.entities.ai.EntityAIFollowOwner;
import com.f1njo.sre.entities.ai.EntityAIOwnerHurtByTargetCustom;
import com.f1njo.sre.entities.ai.EntityAIOwnerHurtTargetCustom;
import com.f1njo.sre.network.MessageSpawnSmoke;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityShadowClone
extends EntityCreature {
    private static final DataParameter<Optional<UUID>> OWNER_ID = EntityDataManager.func_187226_a(EntityShadowClone.class, (DataSerializer)DataSerializers.field_187203_m);
    private int lifetime = 600;
    private EntityPlayer owner;
    private boolean spawnedSmoke = false;

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(OWNER_ID, (Object)Optional.absent());
    }

    public EntityShadowClone(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.8f);
        this.func_110163_bv();
    }

    public EntityShadowClone(World worldIn, EntityPlayer owner) {
        this(worldIn);
        this.owner = owner;
        this.func_184212_Q().func_187227_b(OWNER_ID, (Object)Optional.of((Object)owner.func_110124_au()));
        this.func_70107_b(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v);
        this.copyEquipmentFromOwner();
    }

    private void copyEquipmentFromOwner() {
        EntityPlayer owner = this.getOwner();
        if (owner == null) {
            return;
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack;
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || (stack = owner.func_184582_a(slot)).func_190926_b()) continue;
            this.func_184201_a(slot, stack.func_77946_l());
            this.func_184642_a(slot, 0.0f);
        }
        ItemStack mainHand = owner.func_184614_ca();
        if (!mainHand.func_190926_b()) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, mainHand.func_77946_l());
            this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
        }
    }

    public EntityPlayer getOwner() {
        Optional id;
        if (this.owner == null && (id = (Optional)this.func_184212_Q().func_187225_a(OWNER_ID)).isPresent()) {
            this.owner = this.field_70170_p.func_152378_a((UUID)id.get());
        }
        return this.owner;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMeleeCustom(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowOwner(this, 1.0, 2.0f, 5.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTargetCustom(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTargetCustom(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase target) {
                EntityPlayer owner = EntityShadowClone.this.getOwner();
                if (target instanceof EntityPlayer && owner != null) {
                    return ((EntityPlayer)target).func_110124_au().equals(owner.func_110124_au());
                }
                return false;
            }
        }));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
        this.func_70606_j(1.0f);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        if (this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e) == null) {
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        EntityPlayer owner = this.getOwner();
        boolean flag = owner != null ? entityIn.func_70097_a(DamageSource.func_76365_a((EntityPlayer)owner), damage) : entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.spawnedSmoke && this.field_70170_p.field_72995_K) {
            this.spawnSmokeEffect();
            this.spawnedSmoke = true;
        }
        if (!this.field_70170_p.field_72995_K) {
            double distanceSq;
            EntityPlayer owner;
            --this.lifetime;
            if (this.lifetime <= 0) {
                this.disappear();
            }
            if ((owner = this.getOwner()) != null && (distanceSq = this.func_70068_e((Entity)owner)) > 1000.0) {
                this.func_70107_b(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_189654_d(true);
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_70133_I = true;
            this.disappear();
        }
        return super.func_70097_a(source, amount);
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187541_bC;
    }

    private void disappear() {
        if (!this.field_70170_p.field_72995_K) {
            ModNetwork.INSTANCE.sendToAllTracking((IMessage)new MessageSpawnSmoke(this.field_70165_t, this.field_70163_u, this.field_70161_v), (Entity)this);
            this.func_70106_y();
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Lifetime", this.lifetime);
        EntityPlayer owner = this.getOwner();
        if (owner != null) {
            compound.func_186854_a("OwnerUUID", owner.func_110124_au());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.lifetime = compound.func_74762_e("Lifetime");
        if (compound.func_186855_b("OwnerUUID")) {
            UUID id = compound.func_186857_a("OwnerUUID");
            this.func_184212_Q().func_187227_b(OWNER_ID, (Object)Optional.of((Object)id));
            if (this.field_70170_p != null) {
                this.owner = this.field_70170_p.func_152378_a(id);
            }
        }
    }

    private void spawnSmokeEffect() {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        for (int i = 0; i < 50; ++i) {
            double offsetX = (this.field_70146_Z.nextDouble() - 0.5) * 1.0;
            double offsetY = this.field_70146_Z.nextDouble() * 1.5;
            double offsetZ = (this.field_70146_Z.nextDouble() - 0.5) * 1.0;
            double motionX = (this.field_70146_Z.nextDouble() - 0.5) * 0.1;
            double motionY = 0.2 + this.field_70146_Z.nextDouble() * 0.1;
            double motionZ = (this.field_70146_Z.nextDouble() - 0.5) * 0.1;
            this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.field_70165_t + offsetX, this.field_70163_u + offsetY, this.field_70161_v + offsetZ, motionX, motionY, motionZ, new int[0]);
        }
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 0.5f, 1.0f);
    }

    private void spawnDisappearParticles() {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        for (int i = 0; i < 50; ++i) {
            double offsetX = (this.field_70146_Z.nextDouble() - 0.5) * 1.0;
            double offsetY = this.field_70146_Z.nextDouble() * 1.5;
            double offsetZ = (this.field_70146_Z.nextDouble() - 0.5) * 1.0;
            double motionX = (this.field_70146_Z.nextDouble() - 0.5) * 0.1;
            double motionY = 0.2 + this.field_70146_Z.nextDouble() * 0.1;
            double motionZ = (this.field_70146_Z.nextDouble() - 0.5) * 0.1;
            this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.field_70165_t + offsetX, this.field_70163_u + offsetY, this.field_70161_v + offsetZ, motionX, motionY, motionZ, new int[0]);
        }
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187541_bC, SoundCategory.PLAYERS, 0.5f, 1.0f);
    }
}

