/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu.byakugan;

import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityHeavenlyRotation
extends Entity {
    private static final int DURATION_TICKS = 120;
    private static final double RADIUS = 2.8;
    private static final double PARTICLE_RADIUS = 3.8;
    private static final double BASE_PUSH = 0.8;
    private static final double PUSH_STRENGTH = 1.8;
    private static final int DAMAGE_COOLDOWN_TICKS = 10;
    private static final float ROTATION_SPEED = 30.0f;
    private static final int SPHERE_LATITUDE_SEGMENTS = 24;
    private static final int SPHERE_LONGITUDE_SEGMENTS = 36;
    private static final int SPHERE_RING_STRIPES = 3;
    private static final double PARTICLE_ROTATION_SPEED = 0.35;
    private static final double PARTICLE_INNER_SPIRAL_SPEED = 0.5;
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(EntityHeavenlyRotation.class, (DataSerializer)DataSerializers.field_187203_m);
    private UUID ownerId;
    @Nullable
    private EntityPlayer cachedOwner;
    private final Map<UUID, Integer> lastDamageTicks = new HashMap<UUID, Integer>();

    public EntityHeavenlyRotation(World worldIn) {
        super(worldIn);
        this.func_70105_a(5.6f, 3.0f);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.func_189654_d(true);
    }

    public EntityHeavenlyRotation(World worldIn, EntityPlayer owner) {
        this(worldIn);
        this.setOwner(owner);
        this.func_70107_b(owner.field_70165_t, owner.field_70163_u - 0.5, owner.field_70161_v);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER, (Object)Optional.absent());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        EntityPlayer owner = this.getOwner();
        if (owner == null || owner.field_70128_L) {
            this.func_70106_y();
            return;
        }
        IPlayerStats stats = (IPlayerStats)owner.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats != null && !stats.isByakuganActive()) {
            this.func_70106_y();
            return;
        }
        if (this.field_70173_aa >= 120) {
            this.func_70106_y();
            return;
        }
        this.func_70107_b(owner.field_70165_t, owner.field_70163_u - 0.5, owner.field_70161_v);
        this.rotateOwner(owner);
        if (!this.field_70170_p.field_72995_K) {
            this.repelEntities(owner);
            this.cleanupDamageTracker();
        } else {
            this.spawnParticles(owner);
        }
    }

    private void rotateOwner(EntityPlayer owner) {
        float wrappedYaw;
        owner.field_70177_z = wrappedYaw = MathHelper.func_76142_g((float)(owner.field_70177_z + 30.0f));
        owner.field_70126_B = wrappedYaw;
        owner.field_70761_aq = wrappedYaw;
        owner.field_70760_ar = wrappedYaw;
        owner.field_70759_as = wrappedYaw;
        owner.field_70758_at = wrappedYaw;
        owner.field_70159_w = 0.0;
        owner.field_70179_y = 0.0;
        owner.field_70181_x *= 0.2;
        owner.field_70143_R = 0.0f;
        owner.field_70133_I = true;
    }

    private void repelEntities(EntityPlayer owner) {
        AxisAlignedBB area = this.func_174813_aQ().func_186662_g(0.5);
        List entities = this.field_70170_p.func_72839_b((Entity)owner, area);
        for (Entity entity : entities) {
            double distance;
            if (!entity.func_70089_S() && !(entity instanceof EntityPlayer) || entity == this || entity instanceof EntityHeavenlyRotation) continue;
            double dx = entity.field_70165_t - owner.field_70165_t;
            double dy = entity.field_70163_u + (double)entity.field_70131_O * 0.5 - (owner.field_70163_u + (double)owner.field_70131_O * 0.5);
            double dz = entity.field_70161_v - owner.field_70161_v;
            double distanceSq = dx * dx + dy * dy + dz * dz;
            if (distanceSq <= 1.0E-4) {
                double angle = this.field_70146_Z.nextDouble() * Math.PI * 2.0;
                dx = (double)MathHelper.func_76134_b((float)((float)angle)) * 0.01;
                dz = (double)MathHelper.func_76126_a((float)((float)angle)) * 0.01;
                dy = 0.01;
                distanceSq = dx * dx + dy * dy + dz * dz;
            }
            if ((distance = (double)MathHelper.func_76133_a((double)distanceSq)) > 2.8) continue;
            double pushRatio = (2.8 - distance) / 2.8;
            double push = 0.8 + 1.8 * pushRatio;
            double normX = dx / distance;
            double normY = dy / distance;
            double normZ = dz / distance;
            entity.field_70159_w += normX * push;
            entity.field_70181_x += normY * push * 0.5;
            entity.field_70179_y += normZ * push;
            entity.field_70133_I = true;
            if (!(entity instanceof EntityLivingBase)) continue;
            this.applyDamage(owner, (EntityLivingBase)entity);
        }
    }

    private void applyDamage(EntityPlayer owner, EntityLivingBase target) {
        UUID targetId = target.func_110124_au();
        int tick = this.field_70173_aa;
        Integer last = this.lastDamageTicks.get(targetId);
        if (last == null || tick - last >= 10) {
            this.lastDamageTicks.put(targetId, tick);
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)owner), 6.0f);
        }
    }

    private void cleanupDamageTracker() {
        int tick = this.field_70173_aa;
        this.lastDamageTicks.entrySet().removeIf(entry -> tick - (Integer)entry.getValue() > 20);
    }

    private void spawnParticles(EntityPlayer owner) {
        double centerX = owner.field_70165_t;
        double centerY = owner.field_70163_u + (double)owner.field_70131_O * 0.5;
        double centerZ = owner.field_70161_v;
        double radius = 3.8;
        double rotation = (double)this.field_70173_aa * 0.35;
        double wobble = Math.sin((double)this.field_70173_aa * 0.2) * 0.2;
        for (int lat = 0; lat <= 24; ++lat) {
            double cosLat;
            double latProgress = (double)lat / 24.0;
            double latAngle = (latProgress - 0.5) * Math.PI;
            double sinLat = Math.sin(latAngle);
            double ringRadius = cosLat = Math.cos(latAngle);
            double yOffset = sinLat;
            double ringRotationDirection = lat % 2 == 0 ? 1.0 : -1.0;
            for (int lon = 0; lon < 36; ++lon) {
                double lonBase = rotation * ringRotationDirection + (double)lon * 0.17453292519943295;
                for (int stripe = 0; stripe < 3; ++stripe) {
                    double offset = (double)stripe / 3.0;
                    double lonAngle = lonBase + offset * 0.05817764173314432;
                    double cosLon = Math.cos(lonAngle);
                    double sinLon = Math.sin(lonAngle);
                    double x = centerX + cosLon * ringRadius * radius;
                    double y = centerY + yOffset * radius + wobble * ringRadius;
                    double z = centerZ + sinLon * ringRadius * radius;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, x, y, z, 0.35, 0.85, 1.0, new int[0]);
                }
            }
        }
        double innerRadius = radius * 0.45;
        double spiralAngle = (double)this.field_70173_aa * 0.5;
        for (int i = 0; i < 18; ++i) {
            double angle = spiralAngle + (double)i * 0.3490658503988659;
            double heightOffset = Math.sin(angle * 2.0) * 0.7;
            double x = centerX + Math.cos(angle) * innerRadius;
            double z = centerZ + Math.sin(angle) * innerRadius;
            double y = centerY + heightOffset;
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, x, y, z, 0.45, 0.9, 1.0, new int[0]);
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.ownerId = compound.func_186855_b("Owner") ? compound.func_186857_a("Owner") : null;
        this.cachedOwner = null;
        this.syncOwnerData();
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.ownerId != null) {
            compound.func_186854_a("Owner", this.ownerId);
        }
    }

    @Nullable
    public EntityPlayer getOwner() {
        EntityPlayer player;
        Optional dataOwner;
        if (this.cachedOwner != null && !this.cachedOwner.field_70128_L) {
            return this.cachedOwner;
        }
        if (this.ownerId == null && (dataOwner = (Optional)this.field_70180_af.func_187225_a(OWNER)).isPresent()) {
            this.ownerId = (UUID)dataOwner.get();
        }
        if (this.ownerId != null && (player = this.field_70170_p.func_152378_a(this.ownerId)) != null) {
            this.cachedOwner = player;
            return player;
        }
        return null;
    }

    public boolean isOwner(EntityPlayer player) {
        return player != null && player.func_110124_au().equals(this.ownerId);
    }

    private void setOwner(EntityPlayer owner) {
        this.cachedOwner = owner;
        this.ownerId = owner.func_110124_au();
        this.syncOwnerData();
    }

    private void syncOwnerData() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(OWNER, (Object)Optional.fromNullable((Object)this.ownerId));
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }
}

