/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu.byakugan;

import com.f1njo.sre.chakra.api.IChakra;
import com.f1njo.sre.chakra.impl.ChakraProvider;
import com.f1njo.sre.entities.jutsu.EntityShadowClone;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntitySixtyFourPalms
extends Entity {
    private static final int DURATION_TICKS = 160;
    private static final int[] HIT_SEQUENCE = new int[]{2, 4, 8, 16, 32};
    private static final int TOTAL_HITS = 64;
    private static final int BURST_INTERVAL_TICKS = 160 / HIT_SEQUENCE.length;
    private static final double RADIUS = 3.2;
    private static final int SLOWNESS_DURATION = 12;
    private static final int SLOWNESS_AMPLIFIER = 4;
    private static final float DAMAGE_PER_HIT = 1.0f;
    private static final double CHAKRA_DRAIN_FRACTION = 0.02;
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(EntitySixtyFourPalms.class, (DataSerializer)DataSerializers.field_187203_m);
    @Nullable
    private UUID ownerId;
    @Nullable
    private EntityPlayer cachedOwner;
    private int hitsApplied;
    private int targetCursor;
    private double centerX;
    private double centerY;
    private double centerZ;
    private boolean hasCenter;

    public EntitySixtyFourPalms(World worldIn) {
        super(worldIn);
        this.func_70105_a(12.8f, 0.2f);
        this.field_70178_ae = true;
        this.field_70145_X = true;
        this.func_189654_d(true);
    }

    public EntitySixtyFourPalms(World worldIn, EntityPlayer owner) {
        this(worldIn);
        this.setOwner(owner);
        this.setCenter(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v);
        this.func_70107_b(this.centerX, this.centerY, this.centerZ);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER, (Object)Optional.absent());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        EntityPlayer owner = this.getOwner();
        if (owner == null || owner.field_70128_L) {
            this.func_70106_y();
            return;
        }
        IPlayerStats stats = (IPlayerStats)owner.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats != null && !stats.isByakuganActive()) {
            this.func_70106_y();
            return;
        }
        if (this.field_70173_aa >= 160 || this.hitsApplied >= 64) {
            this.func_70106_y();
            return;
        }
        if (!this.hasCenter) {
            this.setCenter(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v);
        }
        this.func_70107_b(this.centerX, this.centerY, this.centerZ);
        owner.field_70159_w = 0.0;
        owner.field_70181_x = 0.0;
        owner.field_70179_y = 0.0;
        owner.field_191988_bg = 0.0f;
        owner.field_70702_br = 0.0f;
        owner.field_70133_I = true;
        owner.field_70143_R = 0.0f;
        double deltaX = owner.field_70165_t - this.centerX;
        double deltaY = owner.field_70163_u - this.centerY;
        double deltaZ = owner.field_70161_v - this.centerZ;
        double distanceSq = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        if (distanceSq > 1.0E-4) {
            if (this.field_70170_p.field_72995_K) {
                owner.func_70107_b(this.centerX, this.centerY, this.centerZ);
            } else if (owner instanceof EntityPlayerMP) {
                EntityPlayerMP ownerMp = (EntityPlayerMP)owner;
                ownerMp.field_71135_a.func_147364_a(this.centerX, this.centerY, this.centerZ, owner.field_70177_z, owner.field_70125_A);
            } else {
                owner.func_70634_a(this.centerX, this.centerY, this.centerZ);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.applyEffects(owner);
        }
    }

    private void applyEffects(EntityPlayer owner) {
        List<EntityLivingBase> targets = this.findTargets(owner);
        if (targets.isEmpty()) {
            this.targetCursor = 0;
        }
        for (EntityLivingBase target : targets) {
            target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 12, 4, false, true));
        }
        int hitsToApply = this.calculateHitsToApply();
        if (this.field_70173_aa >= 159) {
            hitsToApply = Math.max(hitsToApply, 64 - this.hitsApplied);
        }
        if (hitsToApply <= 0 || targets.isEmpty()) {
            return;
        }
        for (int i = 0; i < hitsToApply && this.hitsApplied < 64; ++i) {
            EntityLivingBase target;
            if (this.targetCursor >= targets.size()) {
                this.targetCursor = 0;
            }
            if (!(target = targets.get(this.targetCursor)).func_70089_S()) {
                targets.remove(this.targetCursor);
                if (!targets.isEmpty()) continue;
                break;
            }
            this.performStrike(owner, target);
            ++this.hitsApplied;
            ++this.targetCursor;
        }
    }

    private int calculateHitsToApply() {
        int stage = Math.min(HIT_SEQUENCE.length - 1, this.field_70173_aa / BURST_INTERVAL_TICKS);
        int expectedHits = 0;
        for (int i = 0; i <= stage; ++i) {
            expectedHits += HIT_SEQUENCE[i];
        }
        expectedHits = Math.min(expectedHits, 64);
        return Math.max(0, expectedHits - this.hitsApplied);
    }

    private void performStrike(EntityPlayer owner, EntityLivingBase target) {
        target.field_70172_ad = 0;
        DamageSource source = owner != null ? DamageSource.func_76365_a((EntityPlayer)owner) : DamageSource.field_76376_m;
        target.func_70097_a(source, 1.0f);
        this.drainChakra(target);
        this.spawnStrikeParticles(target);
    }

    private void drainChakra(EntityLivingBase target) {
        if (!(target instanceof EntityPlayer)) {
            return;
        }
        IChakra chakra = (IChakra)target.getCapability(ChakraProvider.CHAKRA_CAP, null);
        if (chakra == null) {
            return;
        }
        int maxChakra = chakra.getMaxChakra();
        if (maxChakra <= 0) {
            return;
        }
        int consume = (int)Math.ceil((double)maxChakra * 0.02);
        if (consume <= 0) {
            consume = 1;
        }
        chakra.consumeChakra(consume);
    }

    private void spawnStrikeParticles(EntityLivingBase target) {
        if (!(this.field_70170_p instanceof WorldServer)) {
            return;
        }
        WorldServer server = (WorldServer)this.field_70170_p;
        double x = target.field_70165_t;
        double y = target.field_70163_u + (double)target.field_70131_O * 0.5;
        double z = target.field_70161_v;
        server.func_175739_a(EnumParticleTypes.CRIT, x, y, z, 4, 0.2, 0.3, 0.2, 0.1, new int[0]);
    }

    private List<EntityLivingBase> findTargets(EntityPlayer owner) {
        AxisAlignedBB area = new AxisAlignedBB(this.field_70165_t - 3.2, this.field_70163_u - 1.0, this.field_70161_v - 3.2, this.field_70165_t + 3.2, this.field_70163_u + 2.0, this.field_70161_v + 3.2);
        List nearby = this.field_70170_p.func_72872_a(EntityLivingBase.class, area);
        ArrayList<EntityLivingBase> valid = new ArrayList<EntityLivingBase>();
        for (EntityLivingBase entity2 : nearby) {
            if (!this.isValidTarget(owner, entity2)) continue;
            valid.add(entity2);
        }
        valid.sort(Comparator.comparingDouble(entity -> entity.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v)));
        return valid;
    }

    private boolean isValidTarget(EntityPlayer owner, EntityLivingBase entity) {
        EntityShadowClone clone;
        EntityPlayer cloneOwner;
        if (entity == owner) {
            return false;
        }
        if (!entity.func_70089_S()) {
            return false;
        }
        if (entity.func_110124_au().equals(this.ownerId)) {
            return false;
        }
        if (entity instanceof EntityShadowClone && (cloneOwner = (clone = (EntityShadowClone)entity).getOwner()) != null && cloneOwner.func_110124_au().equals(this.ownerId)) {
            return false;
        }
        return owner == null || !entity.func_184191_r((Entity)owner);
    }

    public boolean isOwner(EntityPlayer player) {
        return player != null && this.ownerId != null && this.ownerId.equals(player.func_110124_au());
    }

    public void setOwner(EntityPlayer owner) {
        this.ownerId = owner.func_110124_au();
        this.cachedOwner = owner;
        this.field_70180_af.func_187227_b(OWNER, (Object)Optional.of((Object)this.ownerId));
        if (!this.hasCenter) {
            this.setCenter(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v);
        }
    }

    @Nullable
    public EntityPlayer getOwner() {
        Optional data;
        if (this.cachedOwner == null && this.ownerId != null) {
            this.cachedOwner = this.field_70170_p.func_152378_a(this.ownerId);
        }
        if (this.cachedOwner == null && (data = (Optional)this.field_70180_af.func_187225_a(OWNER)).isPresent()) {
            this.ownerId = (UUID)data.get();
            this.cachedOwner = this.field_70170_p.func_152378_a(this.ownerId);
        }
        return this.cachedOwner;
    }

    public double getRadius() {
        return 3.2;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_186855_b("Owner")) {
            this.ownerId = compound.func_186857_a("Owner");
            this.field_70180_af.func_187227_b(OWNER, (Object)Optional.of((Object)this.ownerId));
        }
        this.hitsApplied = compound.func_74762_e("Hits");
        this.targetCursor = compound.func_74762_e("Cursor");
        if (compound.func_74764_b("CenterX")) {
            this.setCenter(compound.func_74769_h("CenterX"), compound.func_74769_h("CenterY"), compound.func_74769_h("CenterZ"));
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.ownerId != null) {
            compound.func_186854_a("Owner", this.ownerId);
        }
        compound.func_74768_a("Hits", this.hitsApplied);
        compound.func_74768_a("Cursor", this.targetCursor);
        if (this.hasCenter) {
            compound.func_74780_a("CenterX", this.centerX);
            compound.func_74780_a("CenterY", this.centerY);
            compound.func_74780_a("CenterZ", this.centerZ);
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    private void setCenter(double x, double y, double z) {
        this.centerX = x;
        this.centerY = y;
        this.centerZ = z;
        this.hasCenter = true;
    }
}

