/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu.earthrelease;

import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.entities.ai.golem.EntityAIAttackMeleeGolem;
import com.f1njo.sre.entities.ai.golem.EntityAIFollowOwnerGolem;
import com.f1njo.sre.entities.ai.golem.EntityAIOwnerHurtByTargetGolem;
import com.f1njo.sre.entities.ai.golem.EntityAIOwnerHurtTargetGolem;
import com.f1njo.sre.network.jutsu.MessageSpawnDirt;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityEarthGolem
extends EntityIronGolem {
    private static final DataParameter<Optional<UUID>> OWNER_ID = EntityDataManager.func_187226_a(EntityEarthGolem.class, (DataSerializer)DataSerializers.field_187203_m);
    private int lifetime = 600;
    private EntityPlayer owner;

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(OWNER_ID, (Object)Optional.absent());
    }

    public EntityEarthGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.4f, 2.7f);
        this.func_110163_bv();
        this.func_82142_c(false);
        this.func_70849_f(true);
    }

    public EntityEarthGolem(World worldIn, EntityPlayer owner) {
        this(worldIn);
        this.owner = owner;
        this.func_184212_Q().func_187227_b(OWNER_ID, (Object)Optional.of((Object)owner.func_110124_au()));
        this.func_70107_b(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v);
        this.func_82142_c(false);
        this.func_70849_f(true);
    }

    public EntityPlayer getOwner() {
        Optional id;
        if (this.owner == null && (id = (Optional)this.func_184212_Q().func_187225_a(OWNER_ID)).isPresent()) {
            this.owner = this.field_70170_p.func_152378_a((UUID)id.get());
        }
        return this.owner;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMeleeGolem(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowOwnerGolem((EntityCreature)this, 1.0, 2.0f, 5.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTargetGolem(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTargetGolem(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase target) {
                EntityPlayer owner = EntityEarthGolem.this.getOwner();
                if (target instanceof EntityPlayer && owner != null) {
                    return ((EntityPlayer)target).func_110124_au().equals(owner.func_110124_au());
                }
                return false;
            }
        }));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_70606_j(100.0f);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        if (this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e) == null) {
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        EntityPlayer owner = this.getOwner();
        boolean flag = owner != null ? entityIn.func_70097_a(DamageSource.func_76365_a((EntityPlayer)owner), damage) : entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            double distanceSq;
            EntityPlayer owner;
            --this.lifetime;
            if (this.lifetime <= 0) {
                this.disappear();
            }
            if ((owner = this.getOwner()) != null && (distanceSq = this.func_70068_e((Entity)owner)) > 1000.0) {
                this.func_70107_b(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean result = super.func_70097_a(source, amount);
        if (!this.field_70170_p.field_72995_K && this.func_110143_aJ() <= 0.0f) {
            this.func_189654_d(true);
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_70133_I = true;
            this.disappear();
        }
        return result;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187541_bC;
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        int count = 3 + this.field_70146_Z.nextInt(3);
        for (int i = 0; i < count; ++i) {
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150346_d), 1);
        }
    }

    private void disappear() {
        if (!this.field_70170_p.field_72995_K) {
            ModNetwork.INSTANCE.sendToAllTracking((IMessage)new MessageSpawnDirt(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v), (Entity)this);
            this.func_70106_y();
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Lifetime", this.lifetime);
        EntityPlayer owner = this.getOwner();
        if (owner != null) {
            compound.func_186854_a("OwnerUUID", owner.func_110124_au());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.lifetime = compound.func_74762_e("Lifetime");
        if (compound.func_186855_b("OwnerUUID")) {
            UUID id = compound.func_186857_a("OwnerUUID");
            this.func_184212_Q().func_187227_b(OWNER_ID, (Object)Optional.of((Object)id));
            if (this.field_70170_p != null) {
                this.owner = this.field_70170_p.func_152378_a(id);
            }
        }
    }
}

