/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu.earthrelease;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityEarthSandwich
extends Entity {
    private static final int RADIUS = 8;
    private static final int HOLD_TICKS = 160;
    private static final int COLLAPSE_INTERVAL = 5;
    private BlockPos center;
    private int buildLayer;
    private int holdTicks;
    private int collapseLayer;
    private int collapseTicks;
    private boolean alongX;

    public EntityEarthSandwich(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.1f, 0.1f);
        this.alongX = true;
    }

    public EntityEarthSandwich(World worldIn, BlockPos center, boolean alongX) {
        this(worldIn);
        this.center = center;
        this.alongX = alongX;
        this.buildLayer = 0;
        this.holdTicks = 0;
        this.collapseLayer = 8;
        this.collapseTicks = 0;
        this.func_70107_b((double)center.func_177958_n() + 0.5, center.func_177956_o(), (double)center.func_177952_p() + 0.5);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.buildLayer <= 8) {
                this.buildLayer(this.buildLayer);
                this.placeImpactLayer(this.buildLayer);
                ++this.buildLayer;
            } else if (this.holdTicks < 160) {
                ++this.holdTicks;
            } else if (this.collapseLayer >= 0) {
                if (this.collapseTicks < 5) {
                    ++this.collapseTicks;
                } else {
                    this.removeLayer(this.collapseLayer);
                    this.removeImpactLayer(this.collapseLayer);
                    --this.collapseLayer;
                    this.collapseTicks = 0;
                }
            } else {
                this.func_70106_y();
            }
        }
    }

    private void buildLayer(int layer) {
        for (int a = 0; a <= 8; ++a) {
            for (int b = -8; b <= 8; ++b) {
                BlockPos right;
                BlockPos left;
                if (a * a + layer * layer + b * b > 64) continue;
                if (this.alongX) {
                    left = this.center.func_177982_a(-a - 1, layer, b);
                    right = this.center.func_177982_a(a + 1, layer, b);
                } else {
                    left = this.center.func_177982_a(b, layer, -a - 1);
                    right = this.center.func_177982_a(b, layer, a + 1);
                }
                if (this.field_70170_p.func_175623_d(left)) {
                    this.field_70170_p.func_175656_a(left, Blocks.field_150348_b.func_176223_P());
                }
                if (!this.field_70170_p.func_175623_d(right)) continue;
                this.field_70170_p.func_175656_a(right, Blocks.field_150348_b.func_176223_P());
            }
        }
    }

    private void placeImpactLayer(int layer) {
        for (int b = -8; b <= 8; ++b) {
            BlockPos pos;
            if (layer * layer + b * b > 64) continue;
            BlockPos blockPos = pos = this.alongX ? this.center.func_177982_a(0, layer, b) : this.center.func_177982_a(b, layer, 0);
            if (!this.field_70170_p.func_175623_d(pos)) continue;
            this.field_70170_p.func_175656_a(pos, Blocks.field_150347_e.func_176223_P());
        }
    }

    private void removeLayer(int layer) {
        for (int a = 0; a <= 8; ++a) {
            for (int b = -8; b <= 8; ++b) {
                BlockPos right;
                BlockPos left;
                if (a * a + layer * layer + b * b > 64) continue;
                if (this.alongX) {
                    left = this.center.func_177982_a(-a - 1, layer, b);
                    right = this.center.func_177982_a(a + 1, layer, b);
                } else {
                    left = this.center.func_177982_a(b, layer, -a - 1);
                    right = this.center.func_177982_a(b, layer, a + 1);
                }
                if (this.field_70170_p.func_180495_p(left).func_177230_c() == Blocks.field_150348_b) {
                    this.field_70170_p.func_175718_b(2001, left, Block.func_176210_f((IBlockState)Blocks.field_150348_b.func_176223_P()));
                    this.field_70170_p.func_175698_g(left);
                }
                if (this.field_70170_p.func_180495_p(right).func_177230_c() != Blocks.field_150348_b) continue;
                this.field_70170_p.func_175718_b(2001, right, Block.func_176210_f((IBlockState)Blocks.field_150348_b.func_176223_P()));
                this.field_70170_p.func_175698_g(right);
            }
        }
    }

    private void removeImpactLayer(int layer) {
        for (int b = -8; b <= 8; ++b) {
            BlockPos pos;
            if (layer * layer + b * b > 64) continue;
            BlockPos blockPos = pos = this.alongX ? this.center.func_177982_a(0, layer, b) : this.center.func_177982_a(b, layer, 0);
            if (this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150347_e) continue;
            this.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)Blocks.field_150347_e.func_176223_P()));
            this.field_70170_p.func_175698_g(pos);
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.center = new BlockPos(compound.func_74762_e("X"), compound.func_74762_e("Y"), compound.func_74762_e("Z"));
        this.buildLayer = compound.func_74762_e("Build");
        this.holdTicks = compound.func_74762_e("Hold");
        this.collapseLayer = compound.func_74762_e("Collapse");
        this.collapseTicks = compound.func_74762_e("CollapseTicks");
        this.alongX = compound.func_74767_n("AlongX");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.center != null) {
            compound.func_74768_a("X", this.center.func_177958_n());
            compound.func_74768_a("Y", this.center.func_177956_o());
            compound.func_74768_a("Z", this.center.func_177952_p());
        }
        compound.func_74768_a("Build", this.buildLayer);
        compound.func_74768_a("Hold", this.holdTicks);
        compound.func_74768_a("Collapse", this.collapseLayer);
        compound.func_74768_a("CollapseTicks", this.collapseTicks);
        compound.func_74757_a("AlongX", this.alongX);
    }
}

