/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu.earthrelease;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityEarthWall
extends Entity {
    private static final int WIDTH = 7;
    private static final int HEIGHT = 4;
    private static final int LIFE_TIME_TICKS = 300;
    private static final int BUILD_INTERVAL = 2;
    private BlockPos origin;
    private EnumFacing facing;
    private int lifeTicks;
    private int collapseIndex;
    private int buildIndex;
    private int buildTick;

    public EntityEarthWall(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
    }

    public EntityEarthWall(World world, BlockPos origin, EnumFacing facing) {
        this(world);
        this.origin = origin;
        this.facing = facing;
        this.lifeTicks = 300;
        this.collapseIndex = 0;
        this.buildIndex = 0;
        this.buildTick = 0;
        this.func_70107_b((double)origin.func_177958_n() + 0.5, origin.func_177956_o(), (double)origin.func_177952_p() + 0.5);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.buildIndex < 4) {
                if (this.buildTick++ % 2 == 0) {
                    this.createLayer(this.buildIndex);
                    ++this.buildIndex;
                }
            } else if (this.lifeTicks > 0) {
                --this.lifeTicks;
            } else if (this.collapseIndex < 4) {
                int y = 3 - this.collapseIndex;
                EnumFacing perp = this.facing.func_176746_e();
                BlockPos start = this.origin.func_177967_a(perp, -3);
                for (int w = 0; w < 7; ++w) {
                    BlockPos pos = start.func_177967_a(perp, w).func_177981_b(y);
                    if (this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150346_d) continue;
                    this.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P()));
                    this.field_70170_p.func_175698_g(pos);
                }
                ++this.collapseIndex;
            } else {
                this.func_70106_y();
            }
        }
    }

    private void createLayer(int h) {
        EnumFacing perp = this.facing.func_176746_e();
        BlockPos start = this.origin.func_177967_a(perp, -3);
        for (int w = 0; w < 7; ++w) {
            BlockPos pos = start.func_177967_a(perp, w).func_177981_b(h);
            if (!this.field_70170_p.func_175623_d(pos)) continue;
            this.field_70170_p.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
            this.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P()));
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.origin = new BlockPos(compound.func_74762_e("OriginX"), compound.func_74762_e("OriginY"), compound.func_74762_e("OriginZ"));
        this.facing = EnumFacing.func_82600_a((int)compound.func_74771_c("Facing"));
        this.lifeTicks = compound.func_74762_e("Life");
        this.collapseIndex = compound.func_74762_e("Collapse");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.origin != null) {
            compound.func_74768_a("OriginX", this.origin.func_177958_n());
            compound.func_74768_a("OriginY", this.origin.func_177956_o());
            compound.func_74768_a("OriginZ", this.origin.func_177952_p());
        }
        if (this.facing != null) {
            compound.func_74774_a("Facing", (byte)this.facing.func_176745_a());
        }
        compound.func_74768_a("Life", this.lifeTicks);
        compound.func_74768_a("Collapse", this.collapseIndex);
    }
}

