/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu.earthrelease;

import com.f1njo.sre.entities.jutsu.earthrelease.EntityEarthGolem;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityGolemSpawner
extends Entity {
    private static final int SIZE = 3;
    private static final int HEIGHT = 4;
    private static final int BUILD_INTERVAL = 2;
    private static final int LIFE_TIME_TICKS = 60;
    private UUID ownerId;
    private BlockPos origin;
    private int buildIndex;
    private int buildTick;
    private int lifeTicks;
    private int collapseIndex;

    public EntityGolemSpawner(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.1f, 0.1f);
    }

    public EntityGolemSpawner(World worldIn, EntityPlayer owner, BlockPos origin) {
        this(worldIn);
        this.ownerId = owner.func_110124_au();
        this.origin = origin;
        this.buildIndex = 0;
        this.buildTick = 0;
        this.lifeTicks = 60;
        this.collapseIndex = 0;
        this.func_70107_b((double)origin.func_177958_n() + 0.5, origin.func_177956_o(), (double)origin.func_177952_p() + 0.5);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.buildIndex < 4) {
                if (this.buildTick++ % 2 == 0) {
                    this.createLayer(this.buildIndex);
                    ++this.buildIndex;
                }
            } else if (this.lifeTicks > 0) {
                --this.lifeTicks;
            } else if (this.collapseIndex < 4) {
                this.removeLayer(3 - this.collapseIndex);
                ++this.collapseIndex;
            } else {
                this.spawnGolem();
                this.func_70106_y();
            }
        }
    }

    private void createLayer(int h) {
        int half = 1;
        BlockPos start = this.origin.func_177982_a(-half, h, -half);
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                BlockPos pos = start.func_177982_a(x, 0, z);
                if (!this.field_70170_p.func_175623_d(pos)) continue;
                this.field_70170_p.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
                this.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P()));
            }
        }
    }

    private void removeLayer(int h) {
        int half = 1;
        BlockPos start = this.origin.func_177982_a(-half, h, -half);
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                BlockPos pos = start.func_177982_a(x, 0, z);
                if (this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150346_d) continue;
                this.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P()));
                this.field_70170_p.func_175698_g(pos);
            }
        }
    }

    private void spawnGolem() {
        EntityPlayer owner = this.field_70170_p.func_152378_a(this.ownerId);
        if (owner != null) {
            EntityEarthGolem golem = new EntityEarthGolem(this.field_70170_p, owner);
            golem.func_70107_b((double)this.origin.func_177958_n() + 0.5, this.origin.func_177956_o() + 1, (double)this.origin.func_177952_p() + 0.5);
            this.field_70170_p.func_72838_d((Entity)golem);
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_186855_b("Owner")) {
            this.ownerId = compound.func_186857_a("Owner");
        }
        this.origin = new BlockPos(compound.func_74762_e("X"), compound.func_74762_e("Y"), compound.func_74762_e("Z"));
        this.buildIndex = compound.func_74762_e("Build");
        this.buildTick = compound.func_74762_e("Tick");
        this.lifeTicks = compound.func_74762_e("Life");
        this.collapseIndex = compound.func_74762_e("Collapse");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.ownerId != null) {
            compound.func_186854_a("Owner", this.ownerId);
        }
        if (this.origin != null) {
            compound.func_74768_a("X", this.origin.func_177958_n());
            compound.func_74768_a("Y", this.origin.func_177956_o());
            compound.func_74768_a("Z", this.origin.func_177952_p());
        }
        compound.func_74768_a("Build", this.buildIndex);
        compound.func_74768_a("Tick", this.buildTick);
        compound.func_74768_a("Life", this.lifeTicks);
        compound.func_74768_a("Collapse", this.collapseIndex);
    }
}

