/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu.earthrelease;

import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityRisingEarth
extends Entity {
    private UUID ownerId;
    private int ticksAlive;
    private static final int MAX_TICKS = 100;
    private static final int GROW_TIME = 4;
    private static final int SHRINK_TIME = 20;

    public EntityRisingEarth(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 6.0f);
    }

    public EntityRisingEarth(World worldIn, EntityPlayer owner, BlockPos pos) {
        this(worldIn);
        this.ownerId = owner.func_110124_au();
        this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa > 80) {
                double height = this.getCurrentHeight(0.0f);
                for (int i = 0; i < 6; ++i) {
                    double px = this.field_70165_t;
                    double py = this.field_70163_u + height + this.field_70146_Z.nextDouble();
                    double pz = this.field_70161_v;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, px, py, pz, 0.0, -0.1, 0.0, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P())});
                }
            }
        } else {
            if (this.ticksAlive == 0) {
                AxisAlignedBB box = new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 6.0, this.field_70161_v + 0.5);
                List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, box);
                for (EntityLivingBase target : entities) {
                    EntityPlayer owner;
                    if (this.ownerId != null && target.func_110124_au().equals(this.ownerId)) continue;
                    EntityPlayer entityPlayer = owner = this.ownerId != null ? this.field_70170_p.func_152378_a(this.ownerId) : null;
                    if (owner != null) {
                        target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)owner), 8.0f);
                    } else {
                        target.func_70097_a(DamageSource.field_76377_j, 8.0f);
                    }
                    target.field_70181_x = 1.2;
                    target.field_70133_I = true;
                }
            }
            ++this.ticksAlive;
            if (this.ticksAlive >= 100) {
                this.func_70106_y();
            }
        }
    }

    public float getCurrentHeight(float partialTicks) {
        float time = (float)this.field_70173_aa + partialTicks;
        if (time < 4.0f) {
            return 6.0f * (time / 4.0f);
        }
        if (time > 80.0f) {
            float shrinkProg = (time - 80.0f) / 20.0f;
            if (shrinkProg > 1.0f) {
                shrinkProg = 1.0f;
            }
            return 6.0f * (1.0f - shrinkProg);
        }
        return 6.0f;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_186855_b("Owner")) {
            this.ownerId = compound.func_186857_a("Owner");
        }
        this.ticksAlive = compound.func_74762_e("Age");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.ownerId != null) {
            compound.func_186854_a("Owner", this.ownerId);
        }
        compound.func_74768_a("Age", this.ticksAlive);
    }
}

