/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu.firerelease;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityFireStream
extends Entity {
    private static final double SPEED = 0.6;
    private static final int MAX_LIFETIME = 20;
    private static final float DAMAGE = 6.0f;
    private static final int FIRE_DURATION = 3;
    private EntityLivingBase owner;
    private Vec3d direction = Vec3d.field_186680_a;
    private int lifetime;
    private int ownerId = -1;
    private final Set<Integer> hitEntities = new HashSet<Integer>();

    public EntityFireStream(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.6f);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.func_189654_d(true);
    }

    public EntityFireStream(World worldIn, EntityLivingBase owner, Vec3d direction) {
        this(worldIn);
        this.owner = owner;
        this.ownerId = owner.func_145782_y();
        this.direction = direction == null || direction.func_189985_c() == 0.0 ? new Vec3d(0.0, 0.0, 0.0) : direction.func_72432_b();
        Vec3d start = owner.func_174824_e(1.0f);
        this.func_70107_b(start.field_72450_a, start.field_72448_b, start.field_72449_c);
        this.field_70177_z = owner.field_70177_z;
        this.field_70125_A = owner.field_70125_A;
        this.field_70159_w = this.direction.field_72450_a * 0.6;
        this.field_70181_x = this.direction.field_72448_b * 0.6;
        this.field_70179_y = this.direction.field_72449_c * 0.6;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.resolveOwner();
        }
        if (this.owner != null && this.owner.field_70128_L) {
            this.func_70106_y();
            return;
        }
        if (this.direction.func_189985_c() < 1.0E-4) {
            double motionSq = this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y;
            if (motionSq > 1.0E-4) {
                this.direction = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b();
            } else {
                this.func_70106_y();
                return;
            }
        }
        this.field_70159_w = this.direction.field_72450_a * 0.6;
        this.field_70181_x = this.direction.field_72448_b * 0.6;
        this.field_70179_y = this.direction.field_72449_c * 0.6;
        if (this.checkBlockCollision()) {
            return;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
        } else {
            this.applyEffects();
        }
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.29577951308232) - 90.0f;
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) * 57.29577951308232);
        ++this.lifetime;
        if (this.lifetime > 20) {
            this.func_70106_y();
        }
    }

    private void resolveOwner() {
        Entity entity;
        if (this.owner == null && this.ownerId >= 0 && (entity = this.field_70170_p.func_73045_a(this.ownerId)) instanceof EntityLivingBase) {
            this.owner = (EntityLivingBase)entity;
        }
    }

    private void spawnParticles() {
        double length = 1.5;
        for (int i = 0; i < 6; ++i) {
            double factor = (double)i / 6.0;
            double px = this.field_70165_t - this.direction.field_72450_a * factor * length;
            double py = this.field_70163_u - this.direction.field_72448_b * factor * length;
            double pz = this.field_70161_v - this.direction.field_72449_c * factor * length;
            double speedX = this.direction.field_72450_a * 0.05;
            double speedY = this.direction.field_72448_b * 0.05;
            double speedZ = this.direction.field_72449_c * 0.05;
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, px, py, pz, speedX, speedY, speedZ, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, px, py, pz, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private boolean checkBlockCollision() {
        Vec3d currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d nextPos = currentPos.func_72441_c(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        RayTraceResult traceResult = this.field_70170_p.func_147447_a(currentPos, nextPos, false, true, false);
        if (traceResult != null && traceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (traceResult.field_72307_f != null) {
                this.func_70107_b(traceResult.field_72307_f.field_72450_a, traceResult.field_72307_f.field_72448_b, traceResult.field_72307_f.field_72449_c);
            }
            this.func_70106_y();
            return true;
        }
        return false;
    }

    private void applyEffects() {
        AxisAlignedBB checkBox = this.func_174813_aQ().func_186662_g(0.6);
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, checkBox);
        for (EntityLivingBase target : entities) {
            DamageSource source;
            if (target == null || target == this.owner || !target.func_70089_S() || this.hitEntities.contains(target.func_145782_y()) || !target.func_70097_a(source = this.owner instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.owner)) : (this.owner != null ? DamageSource.func_76358_a((EntityLivingBase)this.owner) : DamageSource.field_76372_a), 6.0f)) continue;
            target.func_70015_d(3);
            this.hitEntities.add(target.func_145782_y());
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.lifetime = compound.func_74762_e("Lifetime");
        this.ownerId = compound.func_74762_e("OwnerId");
        double dx = compound.func_74769_h("DirX");
        double dy = compound.func_74769_h("DirY");
        double dz = compound.func_74769_h("DirZ");
        this.direction = new Vec3d(dx, dy, dz);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Lifetime", this.lifetime);
        compound.func_74768_a("OwnerId", this.ownerId);
        compound.func_74780_a("DirX", this.direction.field_72450_a);
        compound.func_74780_a("DirY", this.direction.field_72448_b);
        compound.func_74780_a("DirZ", this.direction.field_72449_c);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }
}

