/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu.firerelease;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityFlameCone
extends Entity
implements IEntityAdditionalSpawnData {
    private static final double STEP_SPEED = 0.9;
    private static final int MAX_LIFETIME = 18;
    private static final float DAMAGE = 10.0f;
    private static final int FIRE_DURATION = 5;
    private static final double[] RING_RADII = new double[]{0.0, 0.45, 0.9, 1.35};
    private static final int[] RING_COUNTS = new int[]{1, 3, 3, 5};
    private static final double[] RING_ROTATIONS = new double[]{0.0, 0.0, 1.0471975511965976, 0.0};
    private static final int SEGMENTS = 6;
    private EntityLivingBase owner;
    private Vec3d origin = Vec3d.field_186680_a;
    private Vec3d direction = Vec3d.field_186680_a;
    private double distanceTraveled;
    private int lifetime;
    private int ownerId = -1;
    private final Set<Integer> hitEntities = new HashSet<Integer>();

    public EntityFlameCone(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.func_189654_d(true);
    }

    public EntityFlameCone(World worldIn, EntityLivingBase owner, Vec3d direction) {
        this(worldIn);
        this.owner = owner;
        this.ownerId = owner.func_145782_y();
        this.direction = direction == null || direction.func_189985_c() == 0.0 ? Vec3d.field_186680_a : direction.func_72432_b();
        this.origin = owner.func_174824_e(1.0f);
        this.func_70107_b(this.origin.field_72450_a, this.origin.field_72448_b, this.origin.field_72449_c);
        this.field_70177_z = owner.field_70177_z;
        this.field_70125_A = owner.field_70125_A;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        Vec3d end;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.resolveOwner();
        }
        if (this.owner != null && this.owner.field_70128_L) {
            this.func_70106_y();
            return;
        }
        if (this.direction.func_189985_c() < 1.0E-4) {
            this.func_70106_y();
            return;
        }
        double previousDistance = this.distanceTraveled;
        double nextDistance = previousDistance + 0.9;
        Vec3d start = this.origin.func_178787_e(this.direction.func_186678_a(previousDistance));
        RayTraceResult hit = this.field_70170_p.func_147447_a(start, end = this.origin.func_178787_e(this.direction.func_186678_a(nextDistance)), false, true, false);
        if (hit != null && hit.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (hit.field_72307_f != null) {
                nextDistance = this.origin.func_72438_d(hit.field_72307_f);
                end = hit.field_72307_f;
            }
            this.distanceTraveled = nextDistance;
            this.func_70107_b(end.field_72450_a, end.field_72448_b, end.field_72449_c);
            this.playEffects(this.distanceTraveled);
            this.func_70106_y();
            return;
        }
        this.distanceTraveled = nextDistance;
        this.func_70107_b(end.field_72450_a, end.field_72448_b, end.field_72449_c);
        this.playEffects(this.distanceTraveled);
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.direction.field_72449_c, (double)this.direction.field_72450_a) * 57.29577951308232) - 90.0f;
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.direction.field_72448_b, (double)MathHelper.func_76133_a((double)(this.direction.field_72450_a * this.direction.field_72450_a + this.direction.field_72449_c * this.direction.field_72449_c))) * 57.29577951308232);
        ++this.lifetime;
        if (this.lifetime > 18) {
            this.func_70106_y();
        }
    }

    private void playEffects(double distance) {
        if (distance <= 0.0) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles(distance);
        } else {
            this.applyEffects(distance);
        }
    }

    private void resolveOwner() {
        Entity entity;
        if (this.owner == null && this.ownerId >= 0 && (entity = this.field_70170_p.func_73045_a(this.ownerId)) instanceof EntityLivingBase) {
            this.owner = (EntityLivingBase)entity;
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.ownerId);
        buffer.writeDouble(this.direction.field_72450_a);
        buffer.writeDouble(this.direction.field_72448_b);
        buffer.writeDouble(this.direction.field_72449_c);
        buffer.writeDouble(this.origin.field_72450_a);
        buffer.writeDouble(this.origin.field_72448_b);
        buffer.writeDouble(this.origin.field_72449_c);
        buffer.writeDouble(this.distanceTraveled);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.ownerId = additionalData.readInt();
        double dirX = additionalData.readDouble();
        double dirY = additionalData.readDouble();
        double dirZ = additionalData.readDouble();
        this.direction = new Vec3d(dirX, dirY, dirZ);
        double originX = additionalData.readDouble();
        double originY = additionalData.readDouble();
        double originZ = additionalData.readDouble();
        this.origin = new Vec3d(originX, originY, originZ);
        this.distanceTraveled = additionalData.readDouble();
        this.func_70107_b(this.origin.field_72450_a + this.direction.field_72450_a * this.distanceTraveled, this.origin.field_72448_b + this.direction.field_72448_b * this.distanceTraveled, this.origin.field_72449_c + this.direction.field_72449_c * this.distanceTraveled);
    }

    private void spawnParticles(double distance) {
        Vec3d[] basis = this.computeBasis();
        if (basis == null) {
            return;
        }
        Vec3d right = basis[0];
        Vec3d up = basis[1];
        int segments = Math.max(2, 6);
        double steps = segments - 1;
        for (int segment = 0; segment < segments; ++segment) {
            double progress = steps == 0.0 ? 0.0 : (double)segment / steps;
            Vec3d center = this.origin.func_178787_e(this.direction.func_186678_a(distance * progress));
            List<Vec3d> offsets = this.buildOffsets(right, up, distance, progress);
            for (Vec3d offset : offsets) {
                Vec3d pos = center.func_178787_e(offset);
                double velX = this.direction.field_72450_a * 0.05;
                double velY = this.direction.field_72448_b * 0.05;
                double velZ = this.direction.field_72449_c * 0.05;
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, velX, velY, velZ, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    private void applyEffects(double distance) {
        Vec3d[] basis = this.computeBasis();
        if (basis == null) {
            return;
        }
        Vec3d right = basis[0];
        Vec3d up = basis[1];
        DamageSource source = this.owner instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.owner)) : (this.owner != null ? DamageSource.func_76358_a((EntityLivingBase)this.owner) : DamageSource.field_76372_a);
        int segments = Math.max(2, 6);
        double steps = segments - 1;
        for (int segment = 0; segment < segments; ++segment) {
            double progress = steps == 0.0 ? 0.0 : (double)segment / steps;
            Vec3d center = this.origin.func_178787_e(this.direction.func_186678_a(distance * progress));
            List<Vec3d> offsets = this.buildOffsets(right, up, distance, progress);
            for (Vec3d offset : offsets) {
                Vec3d sample = center.func_178787_e(offset);
                AxisAlignedBB box = new AxisAlignedBB(sample.field_72450_a - 0.45, sample.field_72448_b - 0.45, sample.field_72449_c - 0.45, sample.field_72450_a + 0.45, sample.field_72448_b + 0.45, sample.field_72449_c + 0.45);
                List targets = this.field_70170_p.func_72872_a(EntityLivingBase.class, box);
                for (EntityLivingBase target : targets) {
                    if (target == null || target == this.owner || !target.func_70089_S() || this.hitEntities.contains(target.func_145782_y()) || !target.func_174813_aQ().func_72326_a(box) || !target.func_70097_a(source, 10.0f)) continue;
                    target.func_70015_d(5);
                    this.hitEntities.add(target.func_145782_y());
                }
            }
        }
    }

    private List<Vec3d> buildOffsets(Vec3d right, Vec3d up, double distance, double progress) {
        ArrayList<Vec3d> offsets = new ArrayList<Vec3d>();
        double spreadScale = 0.25 + distance * 0.05 * progress;
        for (int i = 0; i < RING_RADII.length; ++i) {
            int count = RING_COUNTS[i];
            double radius = RING_RADII[i] * (1.0 + progress * 1.4) * spreadScale;
            if (count <= 1 || radius < 1.0E-4) {
                offsets.add(Vec3d.field_186680_a);
                continue;
            }
            double rotationOffset = RING_ROTATIONS[i];
            for (int index = 0; index < count; ++index) {
                double angle = Math.PI * 2 * (double)index / (double)count + rotationOffset;
                double cos = Math.cos(angle);
                double sin = Math.sin(angle);
                Vec3d offset = right.func_186678_a(cos * radius).func_178787_e(up.func_186678_a(sin * radius));
                offsets.add(offset);
            }
        }
        return offsets;
    }

    private Vec3d[] computeBasis() {
        Vec3d forward = this.direction;
        if (forward.func_189985_c() < 1.0E-4) {
            return null;
        }
        Vec3d arbitrary = Math.abs(forward.field_72448_b) < 0.99 ? new Vec3d(0.0, 1.0, 0.0) : new Vec3d(1.0, 0.0, 0.0);
        Vec3d right = forward.func_72431_c(arbitrary);
        if (right.func_189985_c() < 1.0E-4) {
            arbitrary = new Vec3d(0.0, 0.0, 1.0);
            right = forward.func_72431_c(arbitrary);
        }
        right = right.func_72432_b();
        Vec3d up = right.func_72431_c(forward).func_72432_b();
        return new Vec3d[]{right, up};
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.lifetime = compound.func_74762_e("Lifetime");
        this.ownerId = compound.func_74762_e("OwnerId");
        double dirX = compound.func_74769_h("DirX");
        double dirY = compound.func_74769_h("DirY");
        double dirZ = compound.func_74769_h("DirZ");
        this.direction = new Vec3d(dirX, dirY, dirZ);
        double originX = compound.func_74769_h("OriginX");
        double originY = compound.func_74769_h("OriginY");
        double originZ = compound.func_74769_h("OriginZ");
        this.origin = new Vec3d(originX, originY, originZ);
        this.distanceTraveled = compound.func_74769_h("Distance");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Lifetime", this.lifetime);
        compound.func_74768_a("OwnerId", this.ownerId);
        compound.func_74780_a("DirX", this.direction.field_72450_a);
        compound.func_74780_a("DirY", this.direction.field_72448_b);
        compound.func_74780_a("DirZ", this.direction.field_72449_c);
        compound.func_74780_a("OriginX", this.origin.field_72450_a);
        compound.func_74780_a("OriginY", this.origin.field_72448_b);
        compound.func_74780_a("OriginZ", this.origin.field_72449_c);
        compound.func_74780_a("Distance", this.distanceTraveled);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
    }
}

