/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu.firerelease;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityGreatFireDestruction
extends Entity
implements IEntityAdditionalSpawnData {
    private static final int MAX_LIFETIME = 40;
    private static final float DAMAGE = 25.0f;
    private static final int FIRE_DURATION = 10;
    private static final int RINGS = 6;
    private static final int POINTS_PER_RING = 10;
    private static final double INITIAL_GROW = 0.3;
    private static final double MAX_GROW = 1.0;
    private static final double PEAK_PROGRESS = 0.7;
    private static final double BURST_START_PROGRESS = 0.82;
    private static final int BURST_DURATION = 6;
    private static final double BURST_TRAVEL_DISTANCE = 15.0;
    private static final double FORWARD_SPEED = 0.08;
    private static final double BURST_FORWARD_SPEED = 0.45;
    private static final double JITTER_XZ = 0.08;
    private static final double JITTER_Y = 0.04;
    private static final double SMOKE_CHANCE = 0.2;
    private static final double LAVA_CHANCE = 0.025;
    private static final double SMOKE_BACK_OFFSET = 0.2;
    private EntityLivingBase owner;
    private int ownerId = -1;
    private Vec3d origin = Vec3d.field_186680_a;
    private Vec3d direction = Vec3d.field_186680_a;
    private boolean chargeSpawned;
    private boolean finalBurstTriggered;
    private int finalBurstTick;
    private double finalBurstRadius;
    private double finalBurstDistance;
    private final Set<Integer> hitEntities = new HashSet<Integer>();

    public EntityGreatFireDestruction(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.25f, 0.25f);
        this.field_70178_ae = true;
        this.field_70145_X = true;
    }

    public EntityGreatFireDestruction(World worldIn, EntityLivingBase owner, Vec3d direction) {
        this(worldIn);
        this.owner = owner;
        this.ownerId = owner == null ? -1 : owner.func_145782_y();
        this.direction = this.normalize(direction);
        this.origin = owner == null ? Vec3d.field_186680_a : owner.func_174824_e(1.0f);
        this.func_70107_b(this.origin.field_72450_a, this.origin.field_72448_b, this.origin.field_72449_c);
        this.field_70177_z = owner == null ? 0.0f : owner.field_70177_z;
        this.field_70125_A = owner == null ? 0.0f : owner.field_70125_A;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.resolveOwner();
        }
        if (this.owner != null && this.owner.field_70128_L) {
            this.func_70106_y();
            return;
        }
        if (this.direction.func_189985_c() < 1.0E-6) {
            this.func_70106_y();
            return;
        }
        double progress = this.computeProgress();
        double grow = this.computeGrow(progress);
        if (grow <= 0.0 && this.field_70173_aa >= 40) {
            this.func_70106_y();
            return;
        }
        double currentLength = 20.0 * grow;
        double halfAngle = Math.toRadians(50.0 * grow);
        if (this.field_70170_p.field_72995_K) {
            if (!this.chargeSpawned) {
                this.spawnCharge();
                this.chargeSpawned = true;
            }
            this.spawnConeParticles(currentLength, halfAngle);
            this.handleFinalBurst(progress, currentLength, halfAngle);
        } else {
            this.applyEffects(currentLength, halfAngle);
        }
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.direction.field_72449_c, (double)this.direction.field_72450_a) * 57.29577951308232) - 90.0f;
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.direction.field_72448_b, (double)MathHelper.func_76133_a((double)(this.direction.field_72450_a * this.direction.field_72450_a + this.direction.field_72449_c * this.direction.field_72449_c))) * 57.29577951308232);
        if (this.field_70173_aa > 40) {
            this.func_70106_y();
        }
    }

    private double computeProgress() {
        return (double)this.field_70173_aa / 40.0;
    }

    private double computeGrow(double progress) {
        if (progress >= 1.0) {
            return 0.0;
        }
        if (progress <= 0.7) {
            double ratio = progress / 0.7;
            return 0.3 + ratio * 0.7;
        }
        double tailRatio = (progress - 0.7) / 0.30000000000000004;
        return Math.max(0.0, 1.0 * (1.0 - tailRatio));
    }

    private void resolveOwner() {
        Entity entity;
        if (this.owner == null && this.ownerId >= 0 && (entity = this.field_70170_p.func_73045_a(this.ownerId)) instanceof EntityLivingBase) {
            this.owner = (EntityLivingBase)entity;
        }
    }

    private void spawnCharge() {
        Vec3d[] basis = this.computeBasis();
        if (basis == null) {
            return;
        }
        Vec3d right = basis[0];
        Vec3d up = basis[1];
        Vec3d mouthCenter = this.origin.func_178788_d(this.direction.func_186678_a(0.2)).func_178787_e(up.func_186678_a(-0.1));
        double radius = 0.3;
        for (int i = 0; i < 12; ++i) {
            double angle = Math.PI * 2 * (double)i / 12.0;
            Vec3d offset = right.func_186678_a(Math.cos(angle) * radius).func_178787_e(up.func_186678_a(Math.sin(angle) * radius));
            Vec3d pos = mouthCenter.func_178787_e(offset);
            Vec3d velocity = this.direction.func_186678_a(0.02);
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c, new int[0]);
        }
        int smokeCount = 2 + this.field_70146_Z.nextInt(2);
        for (int i = 0; i < smokeCount; ++i) {
            Vec3d pos = mouthCenter.func_178787_e(this.direction.func_186678_a(0.1));
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void spawnConeParticles(double currentLength, double halfAngle) {
        if (currentLength <= 0.0 || halfAngle <= 0.0) {
            return;
        }
        Vec3d[] basis = this.computeBasis();
        if (basis == null) {
            return;
        }
        Vec3d right = basis[0];
        Vec3d up = basis[1];
        double maxRadius = Math.tan(halfAngle) * currentLength;
        if (Double.isNaN(maxRadius) || Double.isInfinite(maxRadius)) {
            return;
        }
        double ringsMinusOne = Math.max(1.0, 5.0);
        for (int ring = 0; ring < 6; ++ring) {
            double ringProgress = (double)ring / ringsMinusOne;
            double distance = currentLength * ringProgress;
            Vec3d center = this.origin.func_178787_e(this.direction.func_186678_a(distance));
            double radius = Math.tan(halfAngle) * distance;
            for (int point = 0; point < 10; ++point) {
                double angle = Math.PI * 2 * (double)point / 10.0;
                Vec3d radial = right.func_186678_a(Math.cos(angle) * radius).func_178787_e(up.func_186678_a(Math.sin(angle) * radius));
                Vec3d pos = center.func_178787_e(radial);
                double jitterX = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.08;
                double jitterY = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.04;
                double jitterZ = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.08;
                Vec3d velocity = this.direction.func_186678_a(0.08).func_72441_c(jitterX, jitterY, jitterZ);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c, new int[0]);
                if (this.field_70146_Z.nextDouble() < 0.2) {
                    Vec3d smokePos = pos.func_178788_d(this.direction.func_186678_a(0.2));
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, smokePos.field_72450_a, smokePos.field_72448_b, smokePos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
                }
                if (!(this.field_70146_Z.nextDouble() < 0.025)) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    private void handleFinalBurst(double progress, double currentLength, double halfAngle) {
        if (!this.finalBurstTriggered && progress >= 0.82) {
            this.finalBurstTriggered = true;
            this.finalBurstTick = 0;
            double radius = Math.tan(halfAngle) * currentLength;
            this.finalBurstRadius = Double.isFinite(radius) ? Math.max(0.0, radius) : 0.0;
            this.finalBurstDistance = Math.max(0.0, currentLength);
        }
        if (!this.finalBurstTriggered || this.finalBurstTick >= 6 || this.finalBurstRadius <= 0.0) {
            return;
        }
        Vec3d[] basis = this.computeBasis();
        if (basis == null) {
            return;
        }
        Vec3d right = basis[0];
        Vec3d up = basis[1];
        double stepDenominator = Math.max(1, 5);
        double travelProgress = (double)this.finalBurstTick / stepDenominator;
        double travel = 15.0 * travelProgress;
        Vec3d center = this.origin.func_178787_e(this.direction.func_186678_a(this.finalBurstDistance + Math.max(0.0, travel)));
        for (int point = 0; point < 10; ++point) {
            double angle = Math.PI * 2 * (double)point / 10.0;
            Vec3d radial = right.func_186678_a(Math.cos(angle) * this.finalBurstRadius).func_178787_e(up.func_186678_a(Math.sin(angle) * this.finalBurstRadius));
            Vec3d pos = center.func_178787_e(radial);
            double jitterX = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.08;
            double jitterY = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.04;
            double jitterZ = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.08;
            Vec3d velocity = this.direction.func_186678_a(0.45).func_72441_c(jitterX, jitterY, jitterZ);
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c, new int[0]);
            if (this.field_70146_Z.nextDouble() < 0.2) {
                Vec3d smokePos = pos.func_178788_d(this.direction.func_186678_a(0.2));
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, smokePos.field_72450_a, smokePos.field_72448_b, smokePos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            }
            if (!(this.field_70146_Z.nextDouble() < 0.025)) continue;
            this.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
        }
        ++this.finalBurstTick;
    }

    private void applyEffects(double currentLength, double halfAngle) {
        if (currentLength <= 0.0 || halfAngle <= 0.0) {
            return;
        }
        double maxRadius = Math.tan(halfAngle) * currentLength;
        Vec3d end = this.origin.func_178787_e(this.direction.func_186678_a(currentLength));
        AxisAlignedBB bounds = new AxisAlignedBB(this.origin.field_72450_a, this.origin.field_72448_b, this.origin.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c).func_186662_g(maxRadius + 1.0);
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, bounds);
        for (EntityLivingBase target : entities) {
            DamageSource source;
            Vec3d targetPos;
            Vec3d relative;
            double along;
            if (target == null || target == this.owner || !target.func_70089_S() || this.hitEntities.contains(target.func_145782_y()) || (along = (relative = (targetPos = target.func_174791_d().func_72441_c(0.0, (double)target.field_70131_O * 0.5, 0.0)).func_178788_d(this.origin)).func_72430_b(this.direction)) < 0.0 || along > currentLength) continue;
            double radiusAtPoint = Math.tan(halfAngle) * along;
            double perpendicularSq = relative.func_189985_c() - along * along;
            if (perpendicularSq > radiusAtPoint * radiusAtPoint || !target.func_70097_a(source = this.owner instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)this.owner)) : (this.owner != null ? DamageSource.func_76358_a((EntityLivingBase)this.owner) : DamageSource.field_76372_a), 25.0f)) continue;
            target.func_70015_d(10);
            this.hitEntities.add(target.func_145782_y());
        }
    }

    private Vec3d[] computeBasis() {
        Vec3d forward = this.normalize(this.direction);
        if (forward.func_189985_c() < 1.0E-6) {
            return null;
        }
        Vec3d upGuess = Math.abs(forward.field_72448_b) < 0.999 ? new Vec3d(0.0, 1.0, 0.0) : new Vec3d(1.0, 0.0, 0.0);
        Vec3d right = forward.func_72431_c(upGuess);
        if (right.func_189985_c() < 1.0E-6) {
            return null;
        }
        right = right.func_72432_b();
        Vec3d up = right.func_72431_c(forward).func_72432_b();
        return new Vec3d[]{right, up};
    }

    private Vec3d normalize(Vec3d vec) {
        if (vec == null || vec.func_189985_c() < 1.0E-6) {
            return Vec3d.field_186680_a;
        }
        return vec.func_72432_b();
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.ownerId = compound.func_74762_e("OwnerId");
        double originX = compound.func_74769_h("OriginX");
        double originY = compound.func_74769_h("OriginY");
        double originZ = compound.func_74769_h("OriginZ");
        this.origin = new Vec3d(originX, originY, originZ);
        double dirX = compound.func_74769_h("DirX");
        double dirY = compound.func_74769_h("DirY");
        double dirZ = compound.func_74769_h("DirZ");
        this.direction = new Vec3d(dirX, dirY, dirZ);
        this.chargeSpawned = compound.func_74767_n("ChargeSpawned");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("OwnerId", this.ownerId);
        compound.func_74780_a("OriginX", this.origin.field_72450_a);
        compound.func_74780_a("OriginY", this.origin.field_72448_b);
        compound.func_74780_a("OriginZ", this.origin.field_72449_c);
        compound.func_74780_a("DirX", this.direction.field_72450_a);
        compound.func_74780_a("DirY", this.direction.field_72448_b);
        compound.func_74780_a("DirZ", this.direction.field_72449_c);
        compound.func_74757_a("ChargeSpawned", this.chargeSpawned);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.ownerId);
        buffer.writeDouble(this.origin.field_72450_a);
        buffer.writeDouble(this.origin.field_72448_b);
        buffer.writeDouble(this.origin.field_72449_c);
        buffer.writeDouble(this.direction.field_72450_a);
        buffer.writeDouble(this.direction.field_72448_b);
        buffer.writeDouble(this.direction.field_72449_c);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.ownerId = additionalData.readInt();
        double originX = additionalData.readDouble();
        double originY = additionalData.readDouble();
        double originZ = additionalData.readDouble();
        this.origin = new Vec3d(originX, originY, originZ);
        double dirX = additionalData.readDouble();
        double dirY = additionalData.readDouble();
        double dirZ = additionalData.readDouble();
        this.direction = new Vec3d(dirX, dirY, dirZ);
        this.func_70107_b(this.origin.field_72450_a, this.origin.field_72448_b, this.origin.field_72449_c);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }
}

