/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu.lightningrelease;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityChidori
extends Entity
implements IEntityAdditionalSpawnData {
    private static final float DAMAGE = 50.0f;
    private static final int LIFETIME = 200;
    private UUID ownerId;
    private int ticks;

    public EntityChidori(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.3f, 0.3f);
    }

    public EntityChidori(World worldIn, EntityPlayer owner) {
        this(worldIn);
        this.ownerId = owner.func_110124_au();
    }

    public EntityPlayer getOwner() {
        return this.ownerId == null ? null : this.field_70170_p.func_152378_a(this.ownerId);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.ticks;
        if (this.ownerId == null) {
            this.func_70106_y();
            return;
        }
        EntityPlayer owner = this.field_70170_p.func_152378_a(this.ownerId);
        if (owner == null || this.ticks > 200) {
            this.removeFromOwner();
            this.func_70106_y();
            return;
        }
        float partialTicks = this.field_70170_p.field_72995_K ? Minecraft.func_71410_x().func_184121_ak() : 1.0f;
        float swing = owner.field_70732_aI + (owner.field_70733_aJ - owner.field_70732_aI) * partialTicks;
        float swingRot = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swing) * (float)Math.PI));
        Vec3d look = owner.func_70040_Z();
        Vec3d right = look.func_72431_c(new Vec3d(0.0, 1.0, 0.0)).func_72432_b();
        Vec3d offset = right.func_186678_a(0.4).func_178787_e(look.func_186678_a(0.4));
        offset = offset.func_178789_a(-swingRot * 0.6f);
        double x = owner.field_70165_t + offset.field_72450_a;
        double y = owner.field_70163_u + (double)owner.func_70047_e() - 0.9 + look.field_72448_b * 0.2 + offset.field_72448_b;
        double z = owner.field_70161_v + offset.field_72449_c;
        this.func_70107_b(x, y, z);
        Vec3d ownerPos = owner.func_174824_e(partialTicks);
        Vec3d vec = ownerPos.func_178786_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        double horiz = MathHelper.func_76133_a((double)(vec.field_72450_a * vec.field_72450_a + vec.field_72449_c * vec.field_72449_c));
        this.field_70177_z = (float)(Math.toDegrees(Math.atan2(vec.field_72449_c, vec.field_72450_a)) - 90.0);
        this.field_70125_A = (float)(-Math.toDegrees(Math.atan2(vec.field_72448_b, horiz)));
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    private void strike(EntityLivingBase target, EntityPlayer owner) {
        if (!this.field_70170_p.field_72995_K) {
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)owner), 50.0f);
            this.expire();
        }
    }

    public void expire() {
        this.removeFromOwner();
        this.func_70106_y();
    }

    private void removeFromOwner() {
        EntityPlayer owner;
        if (this.ownerId != null && (owner = this.field_70170_p.func_152378_a(this.ownerId)) != null) {
            owner.getEntityData().func_82580_o("ChidoriID");
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_186855_b("Owner")) {
            this.ownerId = compound.func_186857_a("Owner");
        }
        this.ticks = compound.func_74762_e("Ticks");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.ownerId != null) {
            compound.func_186854_a("Owner", this.ownerId);
        }
        compound.func_74768_a("Ticks", this.ticks);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.ownerId != null);
        if (this.ownerId != null) {
            buffer.writeLong(this.ownerId.getMostSignificantBits());
            buffer.writeLong(this.ownerId.getLeastSignificantBits());
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        if (additionalData.readBoolean()) {
            long most = additionalData.readLong();
            long least = additionalData.readLong();
            this.ownerId = new UUID(most, least);
        }
    }
}

