/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu.lightningrelease;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityLightningDog
extends EntityWolf
implements IEntityAdditionalSpawnData {
    private static final float DAMAGE = 14.0f;
    private static final int LIFETIME = 40;
    private UUID ownerId;
    private Vec3d direction;

    public EntityLightningDog(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 1.0f);
        this.func_189654_d(true);
    }

    public EntityLightningDog(World worldIn, EntityPlayer owner) {
        this(worldIn);
        this.ownerId = owner.func_110124_au();
        this.direction = owner.func_70040_Z().func_72432_b();
        this.func_70107_b(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v);
        this.field_70177_z = owner.field_70177_z;
        this.field_70125_A = owner.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public EntityPlayer getOwner() {
        return this.ownerId == null ? null : this.field_70170_p.func_152378_a(this.ownerId);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected void func_184651_r() {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
        this.func_70606_j(1.0f);
    }

    public void func_70071_h_() {
        EntityPlayer owner;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 40) {
            this.func_70106_y();
            return;
        }
        if (this.field_70170_p.field_72995_K && (owner = this.getOwner()) != null) {
            Vec3d start = owner.func_174824_e(1.0f);
            Vec3d end = this.func_174791_d().func_178787_e(new Vec3d(0.0, 0.5, 0.0));
            Vec3d diff = end.func_178788_d(start);
            for (int i = 0; i <= 10; ++i) {
                double t = (double)i / 20.0;
                Vec3d pos = start.func_178787_e(diff.func_186678_a(t));
                this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.01, 0.8, 1.0, new int[0]);
            }
        }
        if (this.direction != null) {
            float yaw;
            this.field_70159_w = this.direction.field_72450_a * 1.2;
            this.field_70181_x = 0.0;
            this.field_70179_y = this.direction.field_72449_c * 1.2;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70177_z = yaw = (float)(MathHelper.func_181159_b((double)this.direction.field_72449_c, (double)this.direction.field_72450_a) * 57.29577951308232) - 90.0f;
            this.field_70761_aq = yaw;
            this.field_70759_as = yaw;
            this.field_70126_B = yaw;
        }
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB box = this.func_174813_aQ().func_186662_g(0.2);
            List targets = this.field_70170_p.func_72872_a(EntityLivingBase.class, box);
            for (EntityLivingBase target : targets) {
                if (target == this || target == this.getOwner()) continue;
                EntityPlayer owner2 = this.getOwner();
                if (owner2 != null) {
                    target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)owner2), 14.0f);
                } else {
                    target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 14.0f);
                }
                EntityLightningBolt bolt = new EntityLightningBolt(this.field_70170_p, target.field_70165_t, target.field_70163_u, target.field_70161_v, false);
                this.func_70106_y();
                break;
            }
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("Owner")) {
            this.ownerId = compound.func_186857_a("Owner");
        }
        if (compound.func_74764_b("DirX")) {
            double x = compound.func_74769_h("DirX");
            double y = compound.func_74769_h("DirY");
            double z = compound.func_74769_h("DirZ");
            this.direction = new Vec3d(x, y, z);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.ownerId != null) {
            compound.func_186854_a("Owner", this.ownerId);
        }
        if (this.direction != null) {
            compound.func_74780_a("DirX", this.direction.field_72450_a);
            compound.func_74780_a("DirY", this.direction.field_72448_b);
            compound.func_74780_a("DirZ", this.direction.field_72449_c);
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.ownerId != null);
        if (this.ownerId != null) {
            buffer.writeLong(this.ownerId.getMostSignificantBits());
            buffer.writeLong(this.ownerId.getLeastSignificantBits());
        }
        buffer.writeBoolean(this.direction != null);
        if (this.direction != null) {
            buffer.writeDouble(this.direction.field_72450_a);
            buffer.writeDouble(this.direction.field_72448_b);
            buffer.writeDouble(this.direction.field_72449_c);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        if (additionalData.readBoolean()) {
            long most = additionalData.readLong();
            long least = additionalData.readLong();
            this.ownerId = new UUID(most, least);
        }
        if (additionalData.readBoolean()) {
            double x = additionalData.readDouble();
            double y = additionalData.readDouble();
            double z = additionalData.readDouble();
            this.direction = new Vec3d(x, y, z);
        }
    }
}

