/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu.waterrelease;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityGreatWaterfall
extends Entity {
    private static final int MAX_RANGE = 25;
    private static final float SPEED = 1.0f;
    private static final float START_RADIUS = 1.0f;
    private static final float MAX_RADIUS = 25.0f;
    private static final float DAMAGE = 40.0f;
    private static final int BLOCK_LIFE = 6;
    private UUID ownerId;
    private Vec3d direction = Vec3d.field_186680_a;
    private Vec3d origin = Vec3d.field_186680_a;
    private double distance = 0.0;
    private Set<UUID> hitEntities = new HashSet<UUID>();
    private List<TempBlock> tempBlocks = new ArrayList<TempBlock>();

    public EntityGreatWaterfall(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
    }

    public EntityGreatWaterfall(World world, EntityPlayer owner) {
        this(world);
        this.ownerId = owner.func_110124_au();
        this.direction = owner.func_70040_Z();
        this.origin = new Vec3d(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v);
        this.func_70107_b(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v);
        this.field_70177_z = owner.field_70177_z;
        this.field_70125_A = owner.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.updateTempBlocks();
        }
        if (this.distance >= 25.0) {
            if (!this.field_70170_p.field_72995_K && this.tempBlocks.isEmpty()) {
                this.func_70106_y();
            }
            return;
        }
        Vec3d forward = this.direction.func_72432_b();
        this.distance += 1.0;
        Vec3d center = this.origin.func_178787_e(forward.func_186678_a(this.distance));
        this.func_70107_b(center.field_72450_a, center.field_72448_b, center.field_72449_c);
        int step = Math.max(0, (int)Math.floor(this.distance - 1.0));
        float radius = Math.min(1.0f + (float)step, 25.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.spawnWaterRow(center, radius);
            this.applyDamage(center, radius);
        }
    }

    private void applyDamage(Vec3d center, float radius) {
        AxisAlignedBB area = new AxisAlignedBB(center.field_72450_a - (double)radius, center.field_72448_b - 1.0, center.field_72449_c - (double)radius, center.field_72450_a + (double)radius, center.field_72448_b + 1.0, center.field_72449_c + (double)radius);
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, area);
        for (EntityLivingBase target : entities) {
            EntityPlayer owner;
            if (this.ownerId != null && target.func_110124_au().equals(this.ownerId) || !this.hitEntities.add(target.func_110124_au())) continue;
            EntityPlayer entityPlayer = owner = this.ownerId != null ? this.field_70170_p.func_152378_a(this.ownerId) : null;
            if (owner != null) {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)owner), 40.0f);
                continue;
            }
            target.func_70097_a(DamageSource.field_76369_e, 40.0f);
        }
    }

    private void spawnWaterRow(Vec3d center, float radius) {
        double yaw = Math.atan2(this.direction.field_72449_c, this.direction.field_72450_a);
        double px = -Math.sin(yaw);
        double pz = Math.cos(yaw);
        for (int i = -((int)radius); i <= (int)radius; ++i) {
            BlockPos pos = new BlockPos(center.field_72450_a + px * (double)i, (double)Math.round(center.field_72448_b), center.field_72449_c + pz * (double)i);
            if (!this.field_70170_p.func_175623_d(pos)) continue;
            IBlockState state = Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(7));
            this.field_70170_p.func_180501_a(pos, state, 2);
            this.tempBlocks.add(new TempBlock(pos, 6));
        }
    }

    private void updateTempBlocks() {
        Iterator<TempBlock> it = this.tempBlocks.iterator();
        while (it.hasNext()) {
            TempBlock tb = it.next();
            --tb.ticks;
            if (tb.ticks > 0) continue;
            this.clearWater(tb.pos);
            it.remove();
        }
    }

    private void clearWater(BlockPos pos) {
        if (this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
            this.field_70170_p.func_175698_g(pos);
        }
        for (EnumFacing face : EnumFacing.values()) {
            BlockPos off = pos.func_177972_a(face);
            if (this.isTracked(off) || this.field_70170_p.func_180495_p(off).func_185904_a() != Material.field_151586_h) continue;
            this.field_70170_p.func_175698_g(off);
        }
    }

    private boolean isTracked(BlockPos pos) {
        for (TempBlock tb : this.tempBlocks) {
            if (!tb.pos.equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_186855_b("Owner")) {
            this.ownerId = compound.func_186857_a("Owner");
        }
        this.distance = compound.func_74769_h("Distance");
        double dx = compound.func_74769_h("DirX");
        double dy = compound.func_74769_h("DirY");
        double dz = compound.func_74769_h("DirZ");
        this.direction = new Vec3d(dx, dy, dz);
        this.origin = new Vec3d(compound.func_74769_h("OrgX"), compound.func_74769_h("OrgY"), compound.func_74769_h("OrgZ"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.ownerId != null) {
            compound.func_186854_a("Owner", this.ownerId);
        }
        compound.func_74780_a("Distance", this.distance);
        compound.func_74780_a("DirX", this.direction.field_72450_a);
        compound.func_74780_a("DirY", this.direction.field_72448_b);
        compound.func_74780_a("DirZ", this.direction.field_72449_c);
        compound.func_74780_a("OrgX", this.origin.field_72450_a);
        compound.func_74780_a("OrgY", this.origin.field_72448_b);
        compound.func_74780_a("OrgZ", this.origin.field_72449_c);
    }

    private static class TempBlock {
        final BlockPos pos;
        int ticks;

        TempBlock(BlockPos pos, int ticks) {
            this.pos = pos;
            this.ticks = ticks;
        }
    }
}

