/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu.waterrelease;

import com.f1njo.sre.entities.jutsu.EntityShadowClone;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntitySyrupField
extends Entity {
    private UUID ownerId;
    private static final int GROW_TIME = 20;
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(EntitySyrupField.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> DURATION = EntityDataManager.func_187226_a(EntitySyrupField.class, (DataSerializer)DataSerializers.field_187192_b);
    private float maxRadius;
    private int lifeTicks;

    public EntitySyrupField(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
        this.maxRadius = 0.0f;
        this.lifeTicks = 0;
    }

    public EntitySyrupField(World world, EntityPlayer owner, float radius, int duration) {
        this(world);
        this.ownerId = owner.func_110124_au();
        this.func_70107_b(owner.field_70165_t, owner.field_70163_u, owner.field_70161_v);
        this.maxRadius = radius;
        this.lifeTicks = duration;
        this.func_184212_Q().func_187227_b(RADIUS, (Object)Float.valueOf(radius));
        this.func_184212_Q().func_187227_b(DURATION, (Object)duration);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(RADIUS, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DURATION, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        float radius = this.field_70170_p.field_72995_K ? ((Float)this.field_70180_af.func_187225_a(RADIUS)).floatValue() : this.maxRadius;
        float progress = Math.min((float)this.field_70173_aa / 20.0f, 1.0f);
        float currentRadius = radius * progress;
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double angle = this.field_70146_Z.nextDouble() * Math.PI * 2.0;
                double dist = this.field_70146_Z.nextDouble() * (double)currentRadius;
                double x = this.field_70165_t + dist * Math.cos(angle);
                double z = this.field_70161_v + dist * Math.sin(angle);
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, x, this.field_70163_u + 0.1, z, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            AxisAlignedBB box = new AxisAlignedBB(this.field_70165_t - (double)currentRadius, this.field_70163_u - 1.0, this.field_70161_v - (double)currentRadius, this.field_70165_t + (double)currentRadius, this.field_70163_u + 2.0, this.field_70161_v + (double)currentRadius);
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, box);
            for (EntityLivingBase target : entities) {
                EntityShadowClone clone;
                if (target.func_110124_au().equals(this.ownerId) || target instanceof EntityShadowClone && (clone = (EntityShadowClone)target).getOwner() != null && clone.getOwner().func_110124_au().equals(this.ownerId)) continue;
                target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 40, 1));
            }
            --this.lifeTicks;
            this.field_70180_af.func_187227_b(DURATION, (Object)this.lifeTicks);
            if (this.lifeTicks <= 0) {
                this.func_70106_y();
            }
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_186855_b("Owner")) {
            this.ownerId = compound.func_186857_a("Owner");
        }
        this.lifeTicks = compound.func_74762_e("Duration");
        this.maxRadius = compound.func_74760_g("Radius");
        this.field_70180_af.func_187227_b(DURATION, (Object)this.lifeTicks);
        this.field_70180_af.func_187227_b(RADIUS, (Object)Float.valueOf(this.maxRadius));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.ownerId != null) {
            compound.func_186854_a("Owner", this.ownerId);
        }
        compound.func_74768_a("Duration", this.lifeTicks);
        compound.func_74776_a("Radius", this.maxRadius);
    }
}

