/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.jutsu.waterrelease;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityWaterDragonBullet
extends EntityThrowable {
    private static final float DAMAGE = 20.0f;
    private boolean launched = false;
    private Vec3d direction;
    private int ticksAlive = 0;
    private static final double MOTION_THRESHOLD = 1.0E-4;

    public EntityWaterDragonBullet(World worldIn) {
        super(worldIn);
        this.func_189654_d(true);
    }

    public EntityWaterDragonBullet(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
        this.func_189654_d(true);
        this.direction = throwerIn.func_70040_Z();
        Vec3d look = this.direction.func_72432_b();
        double offset = 0.5;
        this.func_70107_b(throwerIn.field_70165_t + look.field_72450_a * offset, throwerIn.field_70163_u + (double)throwerIn.func_70047_e() - 0.1 + look.field_72448_b * offset, throwerIn.field_70161_v + look.field_72449_c * offset);
        this.field_70177_z = throwerIn.field_70177_z;
        this.field_70125_A = throwerIn.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void func_70071_h_() {
        double motionSq;
        super.func_70071_h_();
        ++this.ticksAlive;
        EntityLivingBase shooter = this.func_85052_h();
        if (!this.launched && shooter != null) {
            Vec3d look;
            this.direction = look = shooter.func_70040_Z();
            double offset = 0.5;
            double baseX = shooter.field_70165_t + look.field_72450_a * offset;
            double baseY = shooter.field_70163_u + (double)shooter.func_70047_e() - 0.1 + look.field_72448_b * offset;
            double baseZ = shooter.field_70161_v + look.field_72449_c * offset;
            double lift = Math.min(2.0, (double)this.ticksAlive * 0.2);
            this.func_70107_b(baseX, baseY + lift, baseZ);
        }
        if (!this.field_70170_p.field_72995_K && !this.launched && this.ticksAlive >= 10) {
            this.launched = true;
            if (shooter != null) {
                Vec3d dir = this.direction.func_72432_b();
                this.func_70186_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, 2.5f, 0.0f);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.launched && this.ticksAlive > 200) {
            this.func_70106_y();
        }
        if ((motionSq = this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y) > 1.0E-4) {
            double horiz = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            float yaw = (float)(Math.toDegrees(Math.atan2(this.field_70179_y, this.field_70159_w)) - 90.0);
            float pitch = (float)(-Math.toDegrees(Math.atan2(this.field_70181_x, horiz)));
            this.field_70177_z = yaw;
            this.field_70125_A = pitch;
        } else if (shooter != null) {
            this.field_70177_z = shooter.field_70177_z;
            this.field_70125_A = shooter.field_70125_A;
        } else if (this.direction != null) {
            float yaw = (float)(Math.toDegrees(Math.atan2(this.direction.field_72449_c, this.direction.field_72450_a)) - 90.0);
            float pitch = (float)(-Math.toDegrees(Math.atan2(this.direction.field_72448_b, MathHelper.func_76133_a((double)(this.direction.field_72450_a * this.direction.field_72450_a + this.direction.field_72449_c * this.direction.field_72449_c)))));
            this.field_70177_z = yaw;
            this.field_70125_A = pitch;
        }
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        if (this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result.field_72308_g != null) {
                result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 20.0f);
            }
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Launched", this.launched);
        compound.func_74768_a("Ticks", this.ticksAlive);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.launched = compound.func_74767_n("Launched");
        this.ticksAlive = compound.func_74762_e("Ticks");
    }
}

