/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.misc;

import com.f1njo.sre.stats.IOwnedSummon;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntitySummonSign
extends Entity {
    private static final int DEFAULT_LIFETIME_TICKS = 60;
    private ResourceLocation summonEntityId;
    private UUID summonOwnerId;
    private double summonX;
    private double summonY;
    private double summonZ;
    private float summonYaw;
    private float summonPitch;
    private int summonDelay = 60;
    private boolean summonPending;
    private boolean summonCompleted;

    public EntitySummonSign(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 0.01f);
        this.field_70145_X = true;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("SummonEntity")) {
            this.summonEntityId = new ResourceLocation(compound.func_74779_i("SummonEntity"));
        }
        if (compound.func_74764_b("SummonOwner")) {
            try {
                this.summonOwnerId = UUID.fromString(compound.func_74779_i("SummonOwner"));
            }
            catch (IllegalArgumentException ignored) {
                this.summonOwnerId = null;
            }
        }
        this.summonX = compound.func_74769_h("SummonX");
        this.summonY = compound.func_74769_h("SummonY");
        this.summonZ = compound.func_74769_h("SummonZ");
        this.summonYaw = compound.func_74760_g("SummonYaw");
        this.summonPitch = compound.func_74760_g("SummonPitch");
        this.summonDelay = compound.func_74762_e("SummonDelay");
        this.summonPending = compound.func_74767_n("SummonPending");
        this.summonCompleted = compound.func_74767_n("SummonCompleted");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.summonEntityId != null) {
            compound.func_74778_a("SummonEntity", this.summonEntityId.toString());
        }
        if (this.summonOwnerId != null) {
            compound.func_74778_a("SummonOwner", this.summonOwnerId.toString());
        }
        compound.func_74780_a("SummonX", this.summonX);
        compound.func_74780_a("SummonY", this.summonY);
        compound.func_74780_a("SummonZ", this.summonZ);
        compound.func_74776_a("SummonYaw", this.summonYaw);
        compound.func_74776_a("SummonPitch", this.summonPitch);
        compound.func_74768_a("SummonDelay", this.summonDelay);
        compound.func_74757_a("SummonPending", this.summonPending);
        compound.func_74757_a("SummonCompleted", this.summonCompleted);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.summonPending && !this.summonCompleted && this.field_70173_aa >= this.summonDelay) {
            this.spawnSummonedEntity();
        }
        if (!this.summonPending && this.field_70173_aa > 60) {
            this.func_70106_y();
        }
    }

    private void spawnSummonedEntity() {
        if (this.summonEntityId == null) {
            this.func_70106_y();
            return;
        }
        Entity entity = EntityList.func_188429_b((ResourceLocation)this.summonEntityId, (World)this.field_70170_p);
        if (entity == null) {
            this.func_70106_y();
            return;
        }
        entity.func_70012_b(this.summonX, this.summonY, this.summonZ, this.summonYaw, this.summonPitch);
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).field_70759_as = this.summonYaw;
            ((EntityLivingBase)entity).field_70761_aq = this.summonYaw;
        }
        if (entity instanceof IOwnedSummon && this.summonOwnerId != null) {
            EntityPlayer owner = this.field_70170_p.func_152378_a(this.summonOwnerId);
            IOwnedSummon summon = (IOwnedSummon)entity;
            if (owner != null) {
                summon.setOwner(owner);
            } else {
                summon.setOwnerId(this.summonOwnerId);
            }
        }
        if (!this.field_70170_p.func_72838_d(entity)) {
            this.func_70106_y();
            return;
        }
        this.summonCompleted = true;
        this.func_70106_y();
    }

    public void prepareSummon(ResourceLocation entityId, UUID ownerId, double x, double y, double z, float yaw, float pitch, int delayTicks) {
        this.summonEntityId = entityId;
        this.summonOwnerId = ownerId;
        this.summonX = x;
        this.summonY = y;
        this.summonZ = z;
        this.summonYaw = yaw;
        this.summonPitch = pitch;
        this.summonDelay = delayTicks;
        this.summonPending = true;
        this.summonCompleted = false;
    }

    public boolean isSummonPendingFor(UUID playerId) {
        return this.summonPending && this.summonOwnerId != null && this.summonOwnerId.equals(playerId) && !this.summonCompleted;
    }
}

