/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.npc;

import com.f1njo.sre.core.ModArmor;
import com.f1njo.sre.core.ModItems;
import com.f1njo.sre.entities.npc.EntityHumanBase;
import com.f1njo.sre.entities.npc.SummonBeast;
import com.f1njo.sre.events.NpcMessageScheduler;
import com.f1njo.sre.events.SummonContractEvents;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class EntityHealer
extends EntityHumanBase {
    private static final int REQUIRED_LEVEL = 50;
    private static final int REQUIRED_CHAKRA_CONTROL = 25;
    private static final int SCROLL_STAGE_NOT_STARTED = 0;
    private static final int SCROLL_STAGE_ACTIVE = 1;
    private static final int MAIN_STAGE_READY = 2;
    private static final int MAIN_STAGE_FLOWERS = 3;
    private static final int MAIN_STAGE_TRAINING = 4;
    private static final int MAIN_STAGE_MEDICINE = 5;
    private static final int MAIN_STAGE_COMPLETE = 6;
    private static final Item RED_FLOWER = Item.func_150898_a((Block)Blocks.field_150328_O);
    private static final Item YELLOW_FLOWER = Item.func_150898_a((Block)Blocks.field_150327_N);
    private int vanishTimer = -1;
    private UUID farewellTarget;

    public EntityHealer(World worldIn) {
        super(worldIn);
        this.func_110163_bv();
        this.func_96094_a(I18n.func_74838_a((String)"entity.sre.healer.name"));
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModArmor.HEADBAND_SAND));
        this.func_184642_a(EntityEquipmentSlot.HEAD, 0.0f);
    }

    public boolean func_174833_aM() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("entity.sre.healer.name", new Object[0]);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        NBTTagCompound data = player.getEntityData();
        int stage = data.func_74762_e("healerQuestStage");
        switch (stage) {
            case 0: {
                if (this.canStartQuest(player)) {
                    this.startScrollQuest(player, data);
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.healer.requirements", new Object[0]));
                }
                return true;
            }
            case 1: {
                this.handleCarrotDelivery(player, data);
                return true;
            }
            case 2: {
                this.startMainQuest(player, data);
                return true;
            }
            case 3: {
                this.handleFlowers(player, data);
                return true;
            }
            case 4: {
                this.handleTraining(player, data);
                return true;
            }
            case 5: {
                this.handleMedicine(player, data);
                return true;
            }
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.healer.complete", new Object[0]));
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.vanishTimer > 0) {
            --this.vanishTimer;
            if (this.vanishTimer == 0) {
                this.sendFarewell();
                this.spawnSmokeAndDisappear();
            }
        }
    }

    private boolean canStartQuest(EntityPlayer player) {
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null) {
            return false;
        }
        return stats.getLevel() >= 50 && stats.getChakraControl() >= 25;
    }

    private void startScrollQuest(EntityPlayer player, NBTTagCompound data) {
        data.func_74768_a("healerQuestStage", 1);
        NpcMessageScheduler.sendWithDelay(player, new ITextComponent[]{new TextComponentTranslation("message.healer.scroll_start", new Object[0]), new TextComponentTranslation("message.healer.scroll_request", new Object[0])});
    }

    private void handleCarrotDelivery(EntityPlayer player, NBTTagCompound data) {
        int carrots = this.countItems(player, Items.field_151150_bK);
        if (carrots >= 1) {
            player.field_71071_by.func_174925_a(Items.field_151150_bK, -1, 1, null);
            data.func_74768_a("healerQuestStage", 2);
            this.giveMedicalTrainingScroll(player);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.healer.scroll_delivered", new Object[0]));
            this.startVanishTimer(player);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.healer.scroll_missing", new Object[0]));
        }
    }

    private void startMainQuest(EntityPlayer player, NBTTagCompound data) {
        data.func_74768_a("healerQuestStage", 3);
        NpcMessageScheduler.sendWithDelay(player, new ITextComponent[]{new TextComponentTranslation("message.healer.start", new Object[0]), new TextComponentTranslation("message.healer.flowers_request", new Object[0])});
    }

    private void handleFlowers(EntityPlayer player, NBTTagCompound data) {
        int red = this.countFlowers(player, RED_FLOWER, BlockFlower.EnumFlowerType.POPPY.func_176968_b());
        int yellow = this.countFlowers(player, YELLOW_FLOWER, BlockFlower.EnumFlowerType.DANDELION.func_176968_b());
        int daisy = this.countFlowers(player, RED_FLOWER, BlockFlower.EnumFlowerType.OXEYE_DAISY.func_176968_b());
        if (red >= 5 && yellow >= 5 && daisy >= 5) {
            this.removeFlowers(player, RED_FLOWER, BlockFlower.EnumFlowerType.POPPY.func_176968_b(), 5);
            this.removeFlowers(player, YELLOW_FLOWER, BlockFlower.EnumFlowerType.DANDELION.func_176968_b(), 5);
            this.removeFlowers(player, RED_FLOWER, BlockFlower.EnumFlowerType.OXEYE_DAISY.func_176968_b(), 5);
            data.func_74768_a("healerQuestStage", 4);
            NpcMessageScheduler.sendWithDelay(player, new ITextComponent[]{new TextComponentTranslation("message.healer.flowers_delivered", new Object[0]), new TextComponentTranslation("message.healer.training_request", new Object[0])});
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.healer.flowers_missing", new Object[]{Math.max(0, 5 - red), Math.max(0, 5 - yellow), Math.max(0, 5 - daisy)}));
        }
    }

    private void handleTraining(EntityPlayer player, NBTTagCompound data) {
        int iryo;
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        int n = iryo = stats != null ? stats.getIryo() : 0;
        if (iryo >= 100) {
            data.func_74768_a("healerQuestStage", 5);
            NpcMessageScheduler.sendWithDelay(player, new ITextComponent[]{new TextComponentTranslation("message.healer.training_complete", new Object[0]), new TextComponentTranslation("message.healer.medicine_request", new Object[0])});
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.healer.training_progress", new Object[]{iryo}));
        }
    }

    private void handleMedicine(EntityPlayer player, NBTTagCompound data) {
        int apples = this.countItems(player, Items.field_151153_ao);
        int carrots = this.countItems(player, Items.field_151150_bK);
        int melons = this.countItems(player, Items.field_151060_bw);
        if (apples >= 1 && carrots >= 1 && melons >= 3) {
            player.field_71071_by.func_174925_a(Items.field_151153_ao, -1, 1, null);
            player.field_71071_by.func_174925_a(Items.field_151150_bK, -1, 1, null);
            player.field_71071_by.func_174925_a(Items.field_151060_bw, -1, 3, null);
            data.func_74768_a("healerQuestStage", 6);
            data.func_74757_a("healerQuestComplete", true);
            BlockPos coords = this.getOrCreateHint(player, data, "healerQuestHint");
            this.giveCoordinateBook(player, "book.healer.title", "book.healer.page", coords);
            if (player instanceof EntityPlayerMP) {
                SummonContractEvents.prepareSummonBeast((EntityPlayerMP)player, SummonBeast.KATSUYU, coords);
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.healer.medicine_delivered", new Object[0]));
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.healer.medicine_missing", new Object[]{Math.max(0, 1 - apples), Math.max(0, 1 - carrots), Math.max(0, 3 - melons)}));
        }
    }

    private int countFlowers(EntityPlayer player, Item item, int meta) {
        int count = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || stack.func_77973_b() != item || stack.func_77960_j() != meta) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    private void removeFlowers(EntityPlayer player, Item item, int meta, int amount) {
        player.field_71071_by.func_174925_a(item, meta, amount, null);
    }

    private int countItems(EntityPlayer player, Item item) {
        int count = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    private void giveMedicalTrainingScroll(EntityPlayer player) {
        ItemStack reward = new ItemStack(ModItems.MEDICAL_SCROLL);
        if (!player.field_71071_by.func_70441_a(reward)) {
            player.func_71019_a(reward, false);
        }
    }

    private void startVanishTimer(EntityPlayer player) {
        this.vanishTimer = 100;
        this.farewellTarget = player.func_110124_au();
    }

    private void sendFarewell() {
        if (this.farewellTarget == null) {
            return;
        }
        EntityPlayer target = this.field_70170_p.func_152378_a(this.farewellTarget);
        if (target != null) {
            target.func_145747_a((ITextComponent)new TextComponentTranslation("message.healer.farewell", new Object[0]));
        }
    }

    private void spawnSmokeAndDisappear() {
        for (int i = 0; i < 20; ++i) {
            double offsetX = (this.field_70146_Z.nextDouble() - 0.5) * 0.6;
            double offsetY = this.field_70146_Z.nextDouble() * 0.5;
            double offsetZ = (this.field_70146_Z.nextDouble() - 0.5) * 0.6;
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + offsetX, this.field_70163_u + offsetY, this.field_70161_v + offsetZ, 0.0, 0.0, 0.0, new int[0]);
        }
        this.func_70106_y();
    }

    private BlockPos getOrCreateHint(EntityPlayer player, NBTTagCompound data, String prefix) {
        if (data.func_74764_b(prefix + "X")) {
            return new BlockPos(data.func_74762_e(prefix + "X"), data.func_74762_e(prefix + "Y"), data.func_74762_e(prefix + "Z"));
        }
        Random rand = this.func_70681_au();
        double angle = rand.nextDouble() * Math.PI * 2.0;
        int distance = 1500 + rand.nextInt(1001);
        int baseX = player.func_180425_c().func_177958_n();
        int baseZ = player.func_180425_c().func_177952_p();
        int x = baseX + MathHelper.func_76128_c((double)(Math.cos(angle) * (double)distance));
        int z = baseZ + MathHelper.func_76128_c((double)(Math.sin(angle) * (double)distance));
        BlockPos target = new BlockPos(x, 0, z);
        player.field_70170_p.func_175726_f(target);
        BlockPos pos = player.field_70170_p.func_175645_m(target);
        data.func_74768_a(prefix + "X", pos.func_177958_n());
        data.func_74768_a(prefix + "Y", pos.func_177956_o());
        data.func_74768_a(prefix + "Z", pos.func_177952_p());
        return pos;
    }

    private void giveCoordinateBook(EntityPlayer player, String titleKey, String pageKey, BlockPos pos) {
        ItemStack book = new ItemStack(Items.field_151164_bB);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("title", I18n.func_74838_a((String)titleKey));
        tag.func_74778_a("author", this.func_145748_c_().func_150260_c());
        NBTTagList pages = new NBTTagList();
        TextComponentTranslation page = new TextComponentTranslation(pageKey, new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        pages.func_74742_a((NBTBase)new NBTTagString(ITextComponent.Serializer.func_150696_a((ITextComponent)page)));
        tag.func_74782_a("pages", (NBTBase)pages);
        book.func_77982_d(tag);
        if (!player.field_71071_by.func_70441_a(book)) {
            player.func_71019_a(book, false);
        }
    }
}

