/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.npc;

import com.f1njo.sre.stats.IOwnedSummon;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityManda
extends EntityCreature
implements IOwnedSummon {
    public static final int CHAKRA_COST = 200;
    private static final int LIFETIME_TICKS = 900;
    private UUID ownerId;

    public EntityManda(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.0f, 2.0f);
        this.func_110163_bv();
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 32.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(250.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.8);
        if (this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e) == null) {
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(16.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        IEntityLivingData data = super.func_180482_a(difficulty, livingdata);
        this.func_70606_j(this.func_110138_aP());
        return data;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.ownerId != null) {
            if (this.field_70173_aa > 900) {
                this.func_70106_y();
                return;
            }
            EntityPlayer owner = this.getOwner();
            if (owner == null || owner.field_70128_L) {
                this.func_70106_y();
            } else {
                this.updateAttackTarget(owner);
            }
        }
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.ownerId = player.func_110124_au();
    }

    @Override
    public void setOwnerId(UUID ownerId) {
        this.ownerId = ownerId;
    }

    @Override
    public UUID getOwnerId() {
        return this.ownerId;
    }

    @Override
    @Nullable
    public EntityPlayer getOwner() {
        return this.ownerId == null ? null : this.field_70170_p.func_152378_a(this.ownerId);
    }

    private void updateAttackTarget(EntityPlayer owner) {
        EntityLivingBase currentTarget;
        EntityLivingBase lastAttacked;
        EntityLivingBase revengeTarget = owner.func_70643_av();
        if (this.isValidTarget(owner, revengeTarget)) {
            this.func_70624_b(revengeTarget);
        }
        if (this.isValidTarget(owner, lastAttacked = owner.func_110144_aD()) && owner.func_142013_aG() >= owner.field_70173_aa - 40) {
            this.func_70624_b(lastAttacked);
        }
        if (!this.isValidTarget(owner, currentTarget = this.func_70638_az())) {
            this.func_70624_b(null);
            this.func_70661_as().func_75499_g();
        }
    }

    private boolean isValidTarget(EntityPlayer owner, @Nullable EntityLivingBase target) {
        UUID targetOwnerId;
        EntityPlayer targetPlayer;
        if (target == null || target == this || !target.func_70089_S()) {
            return false;
        }
        if (owner.func_184191_r((Entity)target)) {
            return false;
        }
        if (target instanceof EntityPlayer && (targetPlayer = (EntityPlayer)target).func_110124_au().equals(owner.func_110124_au())) {
            return false;
        }
        return !(target instanceof IOwnedSummon) || (targetOwnerId = ((IOwnedSummon)target).getOwnerId()) == null || !targetOwnerId.equals(owner.func_110124_au());
    }

    public boolean func_70652_k(Entity entityIn) {
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.ownerId != null) {
            compound.func_74778_a("OwnerUUID", this.ownerId.toString());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("OwnerUUID")) {
            try {
                this.ownerId = UUID.fromString(compound.func_74779_i("OwnerUUID"));
            }
            catch (IllegalArgumentException ignored) {
                this.ownerId = null;
            }
        }
    }

    protected float getStandingEyeHeight() {
        return 1.5f;
    }
}

