/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.npc;

import com.f1njo.sre.core.ModArmor;
import com.f1njo.sre.entities.npc.EntityHumanBase;
import com.f1njo.sre.entities.npc.EntityQuestSpider;
import com.f1njo.sre.entities.npc.SummonBeast;
import com.f1njo.sre.events.NpcMessageScheduler;
import com.f1njo.sre.events.SummonContractEvents;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class EntityOrochimaruApprentice
extends EntityHumanBase {
    private static final int WITCH_SPAWN_DELAY_TICKS = 60;
    private final List<DelayedFight> pendingFights = new ArrayList<DelayedFight>();

    public EntityOrochimaruApprentice(World worldIn) {
        super(worldIn);
        this.func_110163_bv();
        this.func_96094_a(I18n.func_74838_a((String)"entity.sre.orochi_apprentice.name"));
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ModArmor.HEADBAND_SOUND_CROSSED));
        this.func_184642_a(EntityEquipmentSlot.HEAD, 0.0f);
    }

    public boolean func_174833_aM() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("entity.sre.orochi_apprentice.name", new Object[0]);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        NBTTagCompound data = player.getEntityData();
        int stage = data.func_74762_e("orochiQuestStage");
        switch (stage) {
            case 0: {
                this.startQuest(player, data);
                return true;
            }
            case 1: {
                this.handleSupplies(player, data);
                return true;
            }
            case 2: {
                this.handleSpider(player, data);
                return true;
            }
            case 3: {
                this.handleBattle(player, data);
                return true;
            }
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.orochi_apprentice.complete", new Object[0]));
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.pendingFights.isEmpty()) {
            return;
        }
        Iterator<DelayedFight> iterator = this.pendingFights.iterator();
        while (iterator.hasNext()) {
            DelayedFight fight = iterator.next();
            fight.ticksRemaining--;
            if (fight.ticksRemaining > 0) continue;
            this.spawnWitches(this.field_70170_p, fight.origin);
            iterator.remove();
        }
    }

    private void startQuest(EntityPlayer player, NBTTagCompound data) {
        data.func_74768_a("orochiQuestStage", 1);
        data.func_74757_a("orochiQuestSpiderSpawned", false);
        data.func_74757_a("orochiQuestSpiderDelivered", false);
        data.func_74757_a("orochiQuestWitchesCleared", false);
        data.func_74757_a("orochiQuestFightStarted", false);
        NpcMessageScheduler.sendWithDelay(player, new ITextComponent[]{new TextComponentTranslation("message.orochi_apprentice.start", new Object[0]), new TextComponentTranslation("message.orochi_apprentice.fish_request", new Object[0])});
    }

    private void handleSupplies(EntityPlayer player, NBTTagCompound data) {
        int fish = this.countItems(player, stack -> stack.func_77973_b() == Items.field_151115_aP);
        int eyes = this.countItems(player, stack -> stack.func_77973_b() == Items.field_151070_bp);
        if (fish >= 10 && eyes >= 5) {
            player.field_71071_by.func_174925_a(Items.field_151115_aP, -1, 10, null);
            player.field_71071_by.func_174925_a(Items.field_151070_bp, -1, 5, null);
            data.func_74768_a("orochiQuestStage", 2);
            data.func_74757_a("orochiQuestSpiderDelivered", false);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.orochi_apprentice.fish_delivered", new Object[0]));
            this.spawnQuestSpiderIfNeeded(player, data);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.orochi_apprentice.fish_missing", new Object[]{Math.max(0, 10 - fish), Math.max(0, 5 - eyes)}));
        }
    }

    private void handleSpider(EntityPlayer player, NBTTagCompound data) {
        if (player instanceof EntityPlayerMP) {
            this.spawnQuestSpiderIfNeeded(player, data);
        }
        List spiders = player.field_70170_p.func_72872_a(EntityQuestSpider.class, new AxisAlignedBB(this.func_180425_c()).func_186662_g(6.0));
        for (EntityQuestSpider spider : spiders) {
            if (!spider.isFollowingPlayer(player)) continue;
            spider.func_70106_y();
            data.func_74757_a("orochiQuestSpiderDelivered", true);
            data.func_74768_a("orochiQuestStage", 3);
            data.func_74757_a("orochiQuestWitchesCleared", false);
            data.func_74757_a("orochiQuestFightStarted", false);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.orochi_apprentice.spider_delivered", new Object[0]));
            return;
        }
        if (data.func_74764_b("orochiQuestSpiderX")) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.orochi_apprentice.spider_request", new Object[]{data.func_74762_e("orochiQuestSpiderX"), data.func_74762_e("orochiQuestSpiderY"), data.func_74762_e("orochiQuestSpiderZ")}));
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.orochi_apprentice.spider_wait", new Object[0]));
        }
    }

    private void handleBattle(EntityPlayer player, NBTTagCompound data) {
        if (!data.func_74767_n("orochiQuestFightStarted")) {
            data.func_74757_a("orochiQuestFightStarted", true);
            data.func_74768_a("orochiQuestWitchesRemaining", 5);
            data.func_74757_a("orochiQuestWitchesCleared", false);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.orochi_apprentice.fight_start", new Object[0]));
            this.queueFightStart(this.func_180425_c());
            return;
        }
        if (data.func_74767_n("orochiQuestWitchesCleared")) {
            data.func_74768_a("orochiQuestStage", 4);
            data.func_74757_a("orochiQuestComplete", true);
            BlockPos coords = this.getOrCreateHint(player, data, "orochiQuestHint");
            this.giveCoordinateBook(player, "book.orochi_apprentice.title", "book.orochi_apprentice.page", coords);
            if (player instanceof EntityPlayerMP) {
                SummonContractEvents.prepareSummonBeast((EntityPlayerMP)player, SummonBeast.MANDA, coords);
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.orochi_apprentice.fight_complete", new Object[0]));
        } else {
            int remaining = Math.max(0, data.func_74762_e("orochiQuestWitchesRemaining"));
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.orochi_apprentice.fight_progress", new Object[]{remaining}));
        }
    }

    private void spawnQuestSpiderIfNeeded(EntityPlayer player, NBTTagCompound data) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        if (data.func_74767_n("orochiQuestSpiderDelivered")) {
            return;
        }
        if (!data.func_74767_n("orochiQuestSpiderSpawned")) {
            BlockPos pos = this.getOrCreateSpiderPos(player, data);
            SummonContractEvents.spawnQuestSpider((EntityPlayerMP)player, pos);
            data.func_74757_a("orochiQuestSpiderSpawned", true);
        }
    }

    private BlockPos getOrCreateSpiderPos(EntityPlayer player, NBTTagCompound data) {
        if (data.func_74764_b("orochiQuestSpiderX")) {
            return new BlockPos(data.func_74762_e("orochiQuestSpiderX"), data.func_74762_e("orochiQuestSpiderY"), data.func_74762_e("orochiQuestSpiderZ"));
        }
        BlockPos pos = this.findSpiderLocation(player.field_70170_p, this.func_180425_c());
        if (pos == null) {
            pos = player.field_70170_p.func_175672_r(this.func_180425_c());
        }
        data.func_74768_a("orochiQuestSpiderX", pos.func_177958_n());
        data.func_74768_a("orochiQuestSpiderY", pos.func_177956_o());
        data.func_74768_a("orochiQuestSpiderZ", pos.func_177952_p());
        return pos;
    }

    private BlockPos findSpiderLocation(World world, BlockPos origin) {
        Random rand = this.func_70681_au();
        for (int i = 0; i < 40; ++i) {
            int z;
            double angle = rand.nextDouble() * Math.PI * 2.0;
            int distance = 250 + rand.nextInt(751);
            int x = origin.func_177958_n() + MathHelper.func_76128_c((double)(Math.cos(angle) * (double)distance));
            BlockPos top = world.func_175672_r(new BlockPos(x, 0, z = origin.func_177952_p() + MathHelper.func_76128_c((double)(Math.sin(angle) * (double)distance))));
            if (top.func_177956_o() <= 0 || world.func_180495_p(top.func_177977_b()).func_185904_a().func_76224_d() || !world.func_175665_u(top.func_177977_b()) || !world.func_175623_d(top) && !world.func_175623_d(top = top.func_177984_a())) continue;
            return top;
        }
        return null;
    }

    private void spawnWitches(World world, BlockPos origin) {
        Random rand = world.field_73012_v;
        for (int i = 0; i < 5; ++i) {
            EntityWitch witch = new EntityWitch(world);
            double ox = (double)origin.func_177958_n() + rand.nextGaussian() * 3.0;
            double oz = (double)origin.func_177952_p() + rand.nextGaussian() * 3.0;
            witch.func_70012_b(ox, (double)origin.func_177956_o(), oz, rand.nextFloat() * 360.0f, 0.0f);
            witch.func_110163_bv();
            world.func_72838_d((Entity)witch);
        }
    }

    private void queueFightStart(BlockPos origin) {
        this.pendingFights.add(new DelayedFight(origin, 60));
    }

    private int countItems(EntityPlayer player, Predicate<ItemStack> predicate) {
        int count = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || !predicate.test(stack)) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    private BlockPos getOrCreateHint(EntityPlayer player, NBTTagCompound data, String prefix) {
        if (data.func_74764_b(prefix + "X")) {
            return new BlockPos(data.func_74762_e(prefix + "X"), data.func_74762_e(prefix + "Y"), data.func_74762_e(prefix + "Z"));
        }
        Random rand = this.func_70681_au();
        double angle = rand.nextDouble() * Math.PI * 2.0;
        int distance = 1500 + rand.nextInt(1001);
        int baseX = player.func_180425_c().func_177958_n();
        int baseZ = player.func_180425_c().func_177952_p();
        int x = baseX + MathHelper.func_76128_c((double)(Math.cos(angle) * (double)distance));
        int z = baseZ + MathHelper.func_76128_c((double)(Math.sin(angle) * (double)distance));
        BlockPos base = new BlockPos(x, 0, z);
        player.field_70170_p.func_175726_f(base);
        BlockPos pos = player.field_70170_p.func_175645_m(base);
        data.func_74768_a(prefix + "X", pos.func_177958_n());
        data.func_74768_a(prefix + "Y", pos.func_177956_o());
        data.func_74768_a(prefix + "Z", pos.func_177952_p());
        return pos;
    }

    private void giveCoordinateBook(EntityPlayer player, String titleKey, String pageKey, BlockPos pos) {
        ItemStack book = new ItemStack(Items.field_151164_bB);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("title", I18n.func_74838_a((String)titleKey));
        tag.func_74778_a("author", this.func_145748_c_().func_150260_c());
        NBTTagList pages = new NBTTagList();
        TextComponentTranslation page = new TextComponentTranslation(pageKey, new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        pages.func_74742_a((NBTBase)new NBTTagString(ITextComponent.Serializer.func_150696_a((ITextComponent)page)));
        tag.func_74782_a("pages", (NBTBase)pages);
        book.func_77982_d(tag);
        if (!player.field_71071_by.func_70441_a(book)) {
            player.func_71019_a(book, false);
        }
    }

    private static class DelayedFight {
        private final BlockPos origin;
        private int ticksRemaining;

        private DelayedFight(BlockPos origin, int ticksRemaining) {
            this.origin = origin;
            this.ticksRemaining = ticksRemaining;
        }
    }
}

