/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.npc;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class EntityQuestSpider
extends EntityCaveSpider {
    private UUID ownerUUID;
    private boolean following;

    public EntityQuestSpider(World worldIn) {
        super(worldIn);
        this.func_110163_bv();
        this.func_96094_a("\u0420\u045b\u0420\u00b1\u0421\u0409\u0420\u00b5\u0420\u0454\u0421\u201a-141");
        this.func_70105_a(0.7f, 0.5f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.field_75782_a.clear();
        this.field_70715_bh.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new FollowOwnerGoal(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public boolean func_70652_k(Entity entityIn) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer && !this.field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.orochi_apprentice.spider_harmed", new Object[0]));
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70692_ba() {
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.ownerUUID != null && !player.func_110124_au().equals(this.ownerUUID)) {
            return false;
        }
        if (this.ownerUUID == null) {
            this.ownerUUID = player.func_110124_au();
        }
        if (player.getEntityData().func_74762_e("orochiQuestStage") == 2) {
            this.following = true;
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.orochi_apprentice.spider_follow", new Object[0]));
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70636_d() {
        EntityPlayer owner;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.following && (owner = this.getOwner()) != null && owner.func_70068_e((Entity)this) > 6.0) {
            this.func_70661_as().func_75497_a((Entity)owner, 1.0);
        }
    }

    public void setSummonOwner(EntityPlayer player) {
        this.ownerUUID = player.func_110124_au();
    }

    public void setFollowing(boolean following) {
        this.following = following;
    }

    public boolean isFollowingPlayer(EntityPlayer player) {
        return this.following && player != null && player.func_110124_au().equals(this.ownerUUID);
    }

    @Nullable
    private EntityPlayer getOwner() {
        return this.ownerUUID == null ? null : this.field_70170_p.func_152378_a(this.ownerUUID);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.ownerUUID != null) {
            compound.func_74778_a("QuestOwner", this.ownerUUID.toString());
        }
        compound.func_74757_a("Following", this.following);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("QuestOwner")) {
            try {
                this.ownerUUID = UUID.fromString(compound.func_74779_i("QuestOwner"));
            }
            catch (IllegalArgumentException e) {
                this.ownerUUID = null;
            }
        }
        this.following = compound.func_74767_n("Following");
    }

    private static class FollowOwnerGoal
    extends EntityAIBase {
        private final EntityQuestSpider spider;

        private FollowOwnerGoal(EntityQuestSpider spider) {
            this.spider = spider;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            if (!this.spider.following) {
                return false;
            }
            EntityPlayer owner = this.spider.getOwner();
            return owner != null && owner.func_70068_e((Entity)this.spider) > 4.0;
        }

        public boolean func_75253_b() {
            if (!this.spider.following) {
                return false;
            }
            EntityPlayer owner = this.spider.getOwner();
            return owner != null && owner.func_70068_e((Entity)this.spider) > 3.0;
        }

        public void func_75249_e() {
            EntityPlayer owner = this.spider.getOwner();
            if (owner != null) {
                this.spider.func_70661_as().func_75497_a((Entity)owner, 1.0);
            }
        }

        public void func_75246_d() {
            EntityPlayer owner = this.spider.getOwner();
            if (owner != null) {
                this.spider.func_70661_as().func_75497_a((Entity)owner, 1.0);
            }
        }

        public void func_75251_c() {
            this.spider.func_70661_as().func_75499_g();
        }
    }
}

