/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.npc;

import com.f1njo.sre.core.ModItems;
import com.f1njo.sre.entities.npc.EntityHumanBase;
import java.util.Random;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class EntityShinobiCourier
extends EntityHumanBase {
    private static final int MAX_LIFETIME_TICKS = 6000;
    private boolean metPlayer;
    private boolean announcedScrollCount;
    private int availableScrolls;
    private int lifetimeTicks;

    public EntityShinobiCourier(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
        this.func_110163_bv();
        this.field_70728_aV = 0;
        this.func_96094_a(I18n.func_74838_a((String)"entity.sre.shinobi_courier.name"));
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            ++this.lifetimeTicks;
            if (this.lifetimeTicks >= 6000) {
                this.func_70106_y();
            }
        }
    }

    public boolean func_70692_ba() {
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (!this.metPlayer) {
            this.metPlayer = true;
            player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.sre.shinobi_courier.greeting", new Object[0]));
            player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.sre.shinobi_courier.intro", new Object[0]));
            player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.sre.shinobi_courier.prompt", new Object[0]));
            return true;
        }
        if (!this.announcedScrollCount) {
            this.announcedScrollCount = true;
            this.availableScrolls = this.generateScrollCount(this.field_70146_Z);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.sre.shinobi_courier.available_scrolls", new Object[]{this.availableScrolls}));
            return true;
        }
        if (this.availableScrolls > 0) {
            ItemStack scroll = new ItemStack(ModItems.D_RANK_MISSION_SCROLL);
            boolean added = player.field_71071_by.func_70441_a(scroll);
            if (!added) {
                player.func_71019_a(scroll, false);
            }
            --this.availableScrolls;
            player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.sre.shinobi_courier.provide_scroll", new Object[0]));
            return true;
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("entity.sre.shinobi_courier.no_scrolls", new Object[0]));
        return true;
    }

    private int generateScrollCount(Random random) {
        int[] weightedValues = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 3, 3, 4, 5};
        return weightedValues[random.nextInt(weightedValues.length)];
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("MetPlayer", this.metPlayer);
        compound.func_74757_a("AnnouncedScrollCount", this.announcedScrollCount);
        compound.func_74768_a("AvailableScrolls", this.availableScrolls);
        compound.func_74768_a("LifetimeTicks", this.lifetimeTicks);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.metPlayer = compound.func_74767_n("MetPlayer");
        this.announcedScrollCount = compound.func_74767_n("AnnouncedScrollCount");
        this.availableScrolls = compound.func_74762_e("AvailableScrolls");
        this.lifetimeTicks = compound.func_74762_e("LifetimeTicks");
    }
}

