/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.npc;

import com.f1njo.sre.entities.npc.EntityHumanBase;
import com.f1njo.sre.entities.npc.SummonBeast;
import com.f1njo.sre.events.NpcMessageScheduler;
import com.f1njo.sre.events.SummonContractEvents;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class EntityToadHermit
extends EntityHumanBase {
    private static final String QUEST_SLIME_TAG = "sreToadQuestSlime";

    public EntityToadHermit(World worldIn) {
        super(worldIn);
        this.func_110163_bv();
        this.func_96094_a(I18n.func_74838_a((String)"entity.sre.toad_hermit.name"));
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("entity.sre.toad_hermit.name", new Object[0]);
    }

    public boolean func_174833_aM() {
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        NBTTagCompound data = player.getEntityData();
        int stage = data.func_74762_e("toadQuestStage");
        switch (stage) {
            case 0: {
                this.startQuest(player, data);
                return true;
            }
            case 1: {
                this.handleSlimeTask(player, data);
                return true;
            }
            case 2: {
                this.handleFoodTask(player, data);
                return true;
            }
            case 3: {
                this.handlePotionTask(player, data);
                return true;
            }
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.toad_hermit.complete", new Object[0]));
        return true;
    }

    private void startQuest(EntityPlayer player, NBTTagCompound data) {
        data.func_74768_a("toadQuestStage", 1);
        data.func_74768_a("toadQuestSlimeKills", 0);
        data.func_74768_a("toadQuestSlimeTarget", 5);
        BlockPos spawnPos = this.spawnSlimes(player.field_70170_p, this.func_180425_c());
        if (spawnPos != null) {
            data.func_74768_a("toadQuestSlimeX", spawnPos.func_177958_n());
            data.func_74768_a("toadQuestSlimeY", spawnPos.func_177956_o());
            data.func_74768_a("toadQuestSlimeZ", spawnPos.func_177952_p());
            NpcMessageScheduler.sendWithDelay(player, new ITextComponent[]{new TextComponentTranslation("message.toad_hermit.start", new Object[0]), new TextComponentTranslation("message.toad_hermit.slime_coords", new Object[]{spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p()})});
        } else {
            NpcMessageScheduler.sendWithDelay(player, new ITextComponent[]{new TextComponentTranslation("message.toad_hermit.start", new Object[0]), new TextComponentTranslation("message.toad_hermit.slime_failed", new Object[0])});
        }
    }

    private void handleSlimeTask(EntityPlayer player, NBTTagCompound data) {
        int target;
        int kills = data.func_74762_e("toadQuestSlimeKills");
        if (kills >= (target = Math.max(1, data.func_74762_e("toadQuestSlimeTarget")))) {
            data.func_74768_a("toadQuestStage", 2);
            NpcMessageScheduler.sendWithDelay(player, new ITextComponent[]{new TextComponentTranslation("message.toad_hermit.slime_done", new Object[0]), new TextComponentTranslation("message.toad_hermit.need_soup", new Object[0])});
        } else {
            BlockPos previous = this.getStoredSlimePos(data);
            BlockPos location = this.ensureQuestSlimes(player, data, target - kills);
            if (location == null) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.toad_hermit.slime_failed", new Object[0]));
                return;
            }
            if (previous == null) {
                NpcMessageScheduler.sendWithDelay(player, new ITextComponent[]{new TextComponentTranslation("message.toad_hermit.slime_progress", new Object[]{kills, target}), new TextComponentTranslation("message.toad_hermit.slime_coords", new Object[]{location.func_177958_n(), location.func_177956_o(), location.func_177952_p()})});
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.toad_hermit.slime_progress", new Object[]{kills, target}));
            }
        }
    }

    private void handleFoodTask(EntityPlayer player, NBTTagCompound data) {
        if (this.countItems(player, stack -> stack.func_77973_b() == Items.field_151009_A) >= 3) {
            player.field_71071_by.func_174925_a(Items.field_151009_A, -1, 3, null);
            data.func_74768_a("toadQuestStage", 3);
            NpcMessageScheduler.sendWithDelay(player, new ITextComponent[]{new TextComponentTranslation("message.toad_hermit.soup_delivered", new Object[0]), new TextComponentTranslation("message.toad_hermit.need_potion", new Object[0])});
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.toad_hermit.need_soup", new Object[0]));
        }
    }

    private void handlePotionTask(EntityPlayer player, NBTTagCompound data) {
        if (this.consumePotion(player, PotionTypes.field_185248_t)) {
            data.func_74768_a("toadQuestStage", 4);
            data.func_74757_a("toadQuestComplete", true);
            BlockPos coords = this.getOrCreateHint(player, data, "toadQuestHint");
            this.giveCoordinateBook(player, "book.toad_hermit.title", "book.toad_hermit.page", coords);
            if (player instanceof EntityPlayerMP) {
                SummonContractEvents.prepareSummonBeast((EntityPlayerMP)player, SummonBeast.GAMABUNTA, coords);
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.toad_hermit.potion_delivered", new Object[0]));
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.toad_hermit.need_potion", new Object[0]));
        }
    }

    private BlockPos spawnSlimes(World world, BlockPos origin) {
        BlockPos pos = this.findSpawnLocation(world, origin, 250, 750);
        if (pos == null) {
            return null;
        }
        world.func_175726_f(pos);
        this.spawnQuestSlimes(world, pos, 5);
        return pos;
    }

    private void spawnQuestSlimes(World world, BlockPos pos, int count) {
        if (world == null || world.field_72995_K || pos == null || count <= 0) {
            return;
        }
        world.func_175726_f(pos);
        for (int i = 0; i < count; ++i) {
            EntitySlime slime = new EntitySlime(world);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Size", 2);
            slime.func_70037_a(tag);
            double angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            double distance = 3.0 + world.field_73012_v.nextDouble() * 4.0;
            double ox = (double)pos.func_177958_n() + 0.5 + Math.cos(angle) * distance;
            double oz = (double)pos.func_177952_p() + 0.5 + Math.sin(angle) * distance;
            slime.func_70012_b(ox, (double)pos.func_177956_o(), oz, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            slime.func_110163_bv();
            slime.getEntityData().func_74757_a(QUEST_SLIME_TAG, true);
            slime.func_180482_a(world.func_175649_E(new BlockPos(ox, (double)pos.func_177956_o(), oz)), null);
            world.func_72838_d((Entity)slime);
        }
    }

    private BlockPos ensureQuestSlimes(EntityPlayer player, NBTTagCompound data, int needed) {
        if (needed <= 0) {
            return this.getStoredSlimePos(data);
        }
        BlockPos stored = this.getStoredSlimePos(data);
        if (stored == null) {
            stored = this.spawnSlimes(player.field_70170_p, this.func_180425_c());
            if (stored != null) {
                data.func_74768_a("toadQuestSlimeX", stored.func_177958_n());
                data.func_74768_a("toadQuestSlimeY", stored.func_177956_o());
                data.func_74768_a("toadQuestSlimeZ", stored.func_177952_p());
            } else {
                return null;
            }
        }
        AxisAlignedBB area = new AxisAlignedBB(stored).func_186662_g(12.0);
        int alive = 0;
        for (EntitySlime slime : player.field_70170_p.func_72872_a(EntitySlime.class, area)) {
            if (slime.field_70128_L || !slime.getEntityData().func_74767_n(QUEST_SLIME_TAG)) continue;
            ++alive;
        }
        int missing = Math.max(0, needed - alive);
        if (missing > 0) {
            this.spawnQuestSlimes(player.field_70170_p, stored, missing);
        }
        return stored;
    }

    private BlockPos getStoredSlimePos(NBTTagCompound data) {
        if (data.func_74764_b("toadQuestSlimeX") && data.func_74764_b("toadQuestSlimeY") && data.func_74764_b("toadQuestSlimeZ")) {
            return new BlockPos(data.func_74762_e("toadQuestSlimeX"), data.func_74762_e("toadQuestSlimeY"), data.func_74762_e("toadQuestSlimeZ"));
        }
        return null;
    }

    private BlockPos findSpawnLocation(World world, BlockPos origin, int minDistance, int maxDistance) {
        Random rand = world.field_73012_v;
        for (int i = 0; i < 40; ++i) {
            int z;
            double angle = rand.nextDouble() * Math.PI * 2.0;
            int distance = minDistance + rand.nextInt(Math.max(1, maxDistance - minDistance + 1));
            int x = origin.func_177958_n() + MathHelper.func_76128_c((double)(Math.cos(angle) * (double)distance));
            BlockPos top = world.func_175672_r(new BlockPos(x, 0, z = origin.func_177952_p() + MathHelper.func_76128_c((double)(Math.sin(angle) * (double)distance))));
            if (top.func_177956_o() <= 0 || world.func_180495_p(top.func_177977_b()).func_185904_a().func_76224_d() || !world.func_175665_u(top.func_177977_b()) || !world.func_175623_d(top) && !world.func_175623_d(top = top.func_177984_a())) continue;
            return top;
        }
        return null;
    }

    private boolean consumePotion(EntityPlayer player, PotionType type) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            PotionType potion;
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack.func_190926_b() || stack.func_77973_b() != Items.field_151068_bn || (potion = PotionUtils.func_185191_c((ItemStack)stack)) != type) continue;
            stack.func_190918_g(1);
            if (stack.func_190916_E() <= 0) {
                player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            player.field_71071_by.func_70296_d();
            return true;
        }
        return false;
    }

    private int countItems(EntityPlayer player, Predicate<ItemStack> predicate) {
        int count = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || !predicate.test(stack)) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    private BlockPos getOrCreateHint(EntityPlayer player, NBTTagCompound data, String prefix) {
        if (data.func_74764_b(prefix + "X") && data.func_74764_b(prefix + "Y") && data.func_74764_b(prefix + "Z")) {
            return new BlockPos(data.func_74762_e(prefix + "X"), data.func_74762_e(prefix + "Y"), data.func_74762_e(prefix + "Z"));
        }
        Random rand = this.func_70681_au();
        double angle = rand.nextDouble() * Math.PI * 2.0;
        int distance = 1500 + rand.nextInt(1001);
        int baseX = player.func_180425_c().func_177958_n();
        int baseZ = player.func_180425_c().func_177952_p();
        int x = baseX + MathHelper.func_76128_c((double)(Math.cos(angle) * (double)distance));
        int z = baseZ + MathHelper.func_76128_c((double)(Math.sin(angle) * (double)distance));
        BlockPos target = new BlockPos(x, 0, z);
        player.field_70170_p.func_175726_f(target);
        BlockPos heightPos = player.field_70170_p.func_175645_m(target);
        data.func_74768_a(prefix + "X", heightPos.func_177958_n());
        data.func_74768_a(prefix + "Y", heightPos.func_177956_o());
        data.func_74768_a(prefix + "Z", heightPos.func_177952_p());
        return heightPos;
    }

    private void giveCoordinateBook(EntityPlayer player, String titleKey, String pageKey, BlockPos pos) {
        ItemStack book = new ItemStack(Items.field_151164_bB);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("title", I18n.func_74838_a((String)titleKey));
        tag.func_74778_a("author", this.func_145748_c_().func_150260_c());
        NBTTagList pages = new NBTTagList();
        TextComponentTranslation page = new TextComponentTranslation(pageKey, new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        pages.func_74742_a((NBTBase)new NBTTagString(ITextComponent.Serializer.func_150696_a((ITextComponent)page)));
        tag.func_74782_a("pages", (NBTBase)pages);
        book.func_77982_d(tag);
        if (!player.field_71071_by.func_70441_a(book)) {
            player.func_71019_a(book, false);
        }
    }
}

