/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.entities.npc;

import com.f1njo.sre.entities.npc.EntityGamabunta;
import com.f1njo.sre.entities.npc.EntityKatsuyu;
import com.f1njo.sre.entities.npc.EntityManda;
import java.util.Locale;
import java.util.function.IntSupplier;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;

public enum SummonBeast {
    GAMABUNTA("Gamabunta", "gamabunta", EntityGamabunta.class, true, () -> 250),
    MANDA("Manda", "manda", EntityManda.class, true, () -> 200),
    KATSUYU("Katsuyu", "katsuyu", EntityKatsuyu.class, true, () -> 300);

    private final String displayName;
    private final String entityPath;
    private final Class<? extends EntityLiving> entityClass;
    private final boolean ownerBound;
    private final IntSupplier chakraCostSupplier;

    private SummonBeast(String displayName, String entityPath, Class<? extends EntityLiving> entityClass, boolean ownerBound, IntSupplier chakraCostSupplier) {
        this.displayName = displayName;
        this.entityPath = entityPath;
        this.entityClass = entityClass;
        this.ownerBound = ownerBound;
        this.chakraCostSupplier = chakraCostSupplier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ResourceLocation getEntityId() {
        return new ResourceLocation("sre", this.entityPath);
    }

    public Class<? extends EntityLiving> getEntityClass() {
        return this.entityClass;
    }

    public boolean isOwnerBound() {
        return this.ownerBound;
    }

    public int getChakraCost() {
        return this.chakraCostSupplier.getAsInt();
    }

    public static SummonBeast fromString(String value) {
        if (value == null) {
            return null;
        }
        String normalized = value.toLowerCase(Locale.ROOT);
        for (SummonBeast beast : SummonBeast.values()) {
            if (!beast.name().equalsIgnoreCase(value) && !beast.entityPath.equals(normalized) && !beast.displayName.toLowerCase(Locale.ROOT).equals(normalized)) continue;
            return beast;
        }
        return null;
    }
}

