/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class ElderMessageHandler {
    private static final Map<EntityPlayerMP, List<QueuedMessage>> QUEUES = new HashMap<EntityPlayerMP, List<QueuedMessage>>();

    public static void queueMessages(EntityPlayerMP player, String ... keys) {
        List list = QUEUES.computeIfAbsent(player, p -> new ArrayList());
        int start = 0;
        for (QueuedMessage qm : list) {
            if (qm.delay <= start) continue;
            start = qm.delay;
        }
        for (int i = 0; i < keys.length; ++i) {
            list.add(new QueuedMessage(keys[i], start + i * 100));
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<EntityPlayerMP, List<QueuedMessage>>> mapIt = QUEUES.entrySet().iterator();
        block0: while (mapIt.hasNext()) {
            Map.Entry<EntityPlayerMP, List<QueuedMessage>> entry = mapIt.next();
            List<QueuedMessage> queue = entry.getValue();
            if (queue.isEmpty()) {
                mapIt.remove();
                continue;
            }
            Iterator<QueuedMessage> it = queue.iterator();
            while (it.hasNext()) {
                QueuedMessage qm = it.next();
                --qm.delay;
                if (qm.delay > 0) continue;
                entry.getKey().func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)qm.key)));
                it.remove();
                continue block0;
            }
        }
    }

    private static class QueuedMessage {
        String key;
        int delay;

        QueuedMessage(String key, int delay) {
            this.key = key;
            this.delay = delay;
        }
    }
}

