/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.events;

import com.f1njo.sre.core.ModItems;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LootTableInjectionHandler {
    private static final ResourceLocation BONUS_CHEST = new ResourceLocation("minecraft", "chests/spawn_bonus_chest");
    private static final ResourceLocation VILLAGE_BLACKSMITH = new ResourceLocation("minecraft", "chests/village_blacksmith");
    private static final ResourceLocation DUNGEON = new ResourceLocation("minecraft", "chests/simple_dungeon");
    private static final ResourceLocation MINESHAFT = new ResourceLocation("minecraft", "chests/abandoned_mineshaft");
    private static final ResourceLocation IGLOO = new ResourceLocation("minecraft", "chests/igloo_chest");
    private static final ResourceLocation STRONGHOLD_CORRIDOR = new ResourceLocation("minecraft", "chests/stronghold_corridor");
    private static final ResourceLocation WOODLAND_MANSION = new ResourceLocation("minecraft", "chests/woodland_mansion");
    private static final ResourceLocation STRONGHOLD_LIBRARY = new ResourceLocation("minecraft", "chests/stronghold_library");
    private static final ResourceLocation STRONGHOLD_PORTAL = new ResourceLocation("minecraft", "chests/stronghold_crossing");
    private static final ResourceLocation NETHER_BRIDGE = new ResourceLocation("minecraft", "chests/nether_bridge");
    private static final ResourceLocation DESERT_PYRAMID = new ResourceLocation("minecraft", "chests/desert_pyramid");
    private static final ResourceLocation JUNGLE_TEMPLE = new ResourceLocation("minecraft", "chests/jungle_temple");
    private static final ResourceLocation END_CITY = new ResourceLocation("minecraft", "chests/end_city_treasure");

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        this.injectScroll(event, ModItems.ACADEMIC_SCROLL, BONUS_CHEST, 0.2f, "bonus_chest");
        this.injectScroll(event, ModItems.ACADEMIC_SCROLL, VILLAGE_BLACKSMITH, 0.15f, "village_blacksmith");
        this.injectScroll(event, ModItems.ACADEMIC_SCROLL, DUNGEON, 0.15f, "dungeon");
        this.injectScroll(event, ModItems.ACADEMIC_SCROLL, MINESHAFT, 0.12f, "mineshaft");
        this.injectScroll(event, ModItems.ACADEMIC_SCROLL, IGLOO, 0.15f, "igloo");
        this.injectScroll(event, ModItems.ACADEMIC_SCROLL, STRONGHOLD_CORRIDOR, 0.1f, "stronghold_corridor");
        this.injectScroll(event, ModItems.ACADEMIC_SCROLL, WOODLAND_MANSION, 0.1f, "woodland_mansion");
        this.injectScroll(event, ModItems.ADVANCED_SCHOLAR_SCROLL, DESERT_PYRAMID, 0.125f, "desert_pyramid");
        this.injectScroll(event, ModItems.ADVANCED_SCHOLAR_SCROLL, JUNGLE_TEMPLE, 0.15f, "jungle_temple");
        this.injectScroll(event, ModItems.ADVANCED_SCHOLAR_SCROLL, MINESHAFT, 0.05f, "mineshaft_advanced");
        this.injectScroll(event, ModItems.ADVANCED_SCHOLAR_SCROLL, STRONGHOLD_LIBRARY, 0.2f, "stronghold_library");
        this.injectScroll(event, ModItems.ADVANCED_SCHOLAR_SCROLL, STRONGHOLD_CORRIDOR, 0.075f, "stronghold_corridor_advanced");
        this.injectScroll(event, ModItems.ADVANCED_SCHOLAR_SCROLL, WOODLAND_MANSION, 0.1f, "woodland_mansion_advanced");
        this.injectScroll(event, ModItems.ADVANCED_SCHOLAR_SCROLL, NETHER_BRIDGE, 0.075f, "nether_bridge");
        this.injectScroll(event, ModItems.MASTER_SAGE_SCROLL, STRONGHOLD_LIBRARY, 0.015f, "stronghold_library_master");
        this.injectScroll(event, ModItems.MASTER_SAGE_SCROLL, STRONGHOLD_PORTAL, 0.025f, "stronghold_portal_master");
        this.injectScroll(event, ModItems.MASTER_SAGE_SCROLL, STRONGHOLD_CORRIDOR, 0.01f, "stronghold_corridor_master");
        this.injectScroll(event, ModItems.MASTER_SAGE_SCROLL, END_CITY, 0.05f, "end_city_master");
        this.injectScroll(event, ModItems.MASTER_SAGE_SCROLL, DESERT_PYRAMID, 0.01f, "desert_pyramid_master");
        this.injectScroll(event, ModItems.MASTER_SAGE_SCROLL, JUNGLE_TEMPLE, 0.015f, "jungle_temple_master");
        this.injectScroll(event, ModItems.MASTER_SAGE_SCROLL, WOODLAND_MANSION, 0.015f, "woodland_mansion_master");
    }

    private void injectScroll(LootTableLoadEvent event, Item scroll, ResourceLocation target, float chance, String suffix) {
        if (!event.getName().equals((Object)target)) {
            return;
        }
        LootEntryItem entry = new LootEntryItem(scroll, 1, 0, new LootFunction[0], new LootCondition[0], "sre:" + scroll.getRegistryName().func_110623_a() + "_" + suffix);
        LootPool pool = new LootPool(new LootEntry[]{entry}, new LootCondition[]{new RandomChance(chance)}, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "sre:" + scroll.getRegistryName().func_110623_a() + "_pool_" + suffix);
        event.getTable().addPool(pool);
    }
}

