/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.events;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public final class NpcMessageScheduler {
    private static final int DELAY_TICKS = 60;
    private static final Map<EntityPlayerMP, Deque<QueuedMessage>> QUEUES = new HashMap<EntityPlayerMP, Deque<QueuedMessage>>();

    private NpcMessageScheduler() {
    }

    public static void sendWithDelay(EntityPlayer player, ITextComponent ... messages) {
        ITextComponent first;
        if (player == null || messages == null || messages.length == 0) {
            return;
        }
        if (!(player instanceof EntityPlayerMP)) {
            for (ITextComponent message : messages) {
                if (message == null) continue;
                player.func_145747_a(message);
            }
            return;
        }
        EntityPlayerMP mp = (EntityPlayerMP)player;
        Deque queue = QUEUES.computeIfAbsent(mp, p -> new ArrayDeque());
        int index = 0;
        if (queue.isEmpty()) {
            first = messages[0];
            if (first != null) {
                mp.func_145747_a(first);
            }
            index = 1;
        } else {
            first = messages[0];
            if (first != null) {
                queue.add(new QueuedMessage(first.func_150259_f(), 60));
            }
            index = 1;
        }
        for (int i = index; i < messages.length; ++i) {
            ITextComponent component = messages[i];
            if (component == null) continue;
            queue.add(new QueuedMessage(component.func_150259_f(), 60));
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<EntityPlayerMP, Deque<QueuedMessage>>> iterator = QUEUES.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<EntityPlayerMP, Deque<QueuedMessage>> entry = iterator.next();
            EntityPlayerMP player = entry.getKey();
            if (player == null || player.field_71135_a == null || player.field_70128_L) {
                iterator.remove();
                continue;
            }
            Deque<QueuedMessage> queue = entry.getValue();
            if (queue.isEmpty()) {
                iterator.remove();
                continue;
            }
            QueuedMessage current = queue.peek();
            if (current == null) {
                iterator.remove();
                continue;
            }
            current.delay--;
            if (current.delay > 0) continue;
            player.func_145747_a(current.component);
            queue.poll();
            if (!queue.isEmpty()) continue;
            iterator.remove();
        }
    }

    private static final class QueuedMessage {
        private final ITextComponent component;
        private int delay;

        private QueuedMessage(ITextComponent component, int delay) {
            this.component = component;
            this.delay = delay;
        }
    }
}

