/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.events;

import com.f1njo.sre.entities.npc.EntityShinobiCourier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ShinobiCourierSpawnHandler {
    private static final int CHECK_INTERVAL = 100;
    private static final int SPAWN_CHANCE = 200;
    private static final double SEARCH_RADIUS = 64.0;
    private static final Map<UUID, Integer> PLAYER_TICK_COUNTER = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (world.field_72995_K || event.phase != TickEvent.Phase.END || player.field_71093_bK != 0) {
            return;
        }
        int ticks = PLAYER_TICK_COUNTER.getOrDefault(player.func_110124_au(), 0) + 1;
        if (ticks < 100) {
            PLAYER_TICK_COUNTER.put(player.func_110124_au(), ticks);
            return;
        }
        PLAYER_TICK_COUNTER.put(player.func_110124_au(), 0);
        if (world.field_73012_v.nextInt(200) != 0) {
            return;
        }
        AxisAlignedBB searchBox = player.func_174813_aQ().func_186662_g(64.0);
        List existing = world.func_72872_a(EntityShinobiCourier.class, searchBox);
        if (!existing.isEmpty()) {
            return;
        }
        BlockPos spawnPos = ShinobiCourierSpawnHandler.findSpawnPosition(world, player);
        if (spawnPos == null) {
            return;
        }
        EntityShinobiCourier courier = new EntityShinobiCourier(world);
        courier.func_70012_b((double)spawnPos.func_177958_n() + 0.5, spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)courier);
    }

    private static BlockPos findSpawnPosition(World world, EntityPlayer player) {
        double offsetZ;
        double angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
        double distance = 16.0 + (double)world.field_73012_v.nextInt(9);
        double offsetX = Math.cos(angle) * distance;
        BlockPos basePos = new BlockPos(player.field_70165_t + offsetX, player.field_70163_u, player.field_70161_v + (offsetZ = Math.sin(angle) * distance));
        BlockPos topPos = world.func_175672_r(basePos);
        IBlockState below = world.func_180495_p(topPos.func_177977_b());
        if (!below.func_185904_a().func_76220_a()) {
            return null;
        }
        if (!world.func_175623_d(topPos) || !world.func_175623_d(topPos.func_177984_a())) {
            return null;
        }
        return topPos;
    }
}

