/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.events;

import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.entities.npc.EntityGamabunta;
import com.f1njo.sre.entities.npc.EntityHealer;
import com.f1njo.sre.entities.npc.EntityKatsuyu;
import com.f1njo.sre.entities.npc.EntityManda;
import com.f1njo.sre.entities.npc.EntityOrochimaruApprentice;
import com.f1njo.sre.entities.npc.EntityQuestSpider;
import com.f1njo.sre.entities.npc.EntityToadHermit;
import com.f1njo.sre.entities.npc.SummonBeast;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class SummonContractEvents {
    private static final String GAMABUNTA_STAGE = "summonGamabuntaStage";
    private static final String MANDA_STAGE = "summonMandaStage";
    private static final String KATSUYU_STAGE = "summonKatsuyuStage";
    private static final String GAMABUNTA_WARNINGS = "summonGamabuntaWarnings";
    private static final String MANDA_WARNINGS = "summonMandaWarnings";
    private static final String KATSUYU_WARNINGS = "summonKatsuyuWarnings";
    private static final String GAMABUNTA_SPAWNED = "summonGamabuntaSpawned";
    private static final String MANDA_SPAWNED = "summonMandaSpawned";
    private static final String KATSUYU_SPAWNED = "summonKatsuyuSpawned";
    private static final String MANDA_SPIDER_OWNER_TAG = "sreMandaTrialOwner";
    private static final String KATSUYU_SLIME_OWNER_TAG = "sreKatsuyuTrialOwner";
    private static final int STAGE_READY = 0;
    private static final int STAGE_ACTIVE = 1;
    private static final int STAGE_COMPLETE = 2;
    private static final int STAGE_CONTRACT = 3;
    private static final int GAMABUNTA_REQUIRED_DAMAGE = 50;
    private static final int GAMABUNTA_TIME_LIMIT = 600;
    private static final int MANDA_WAVE_ONE = 3;
    private static final int MANDA_WAVE_TWO = 6;
    private static final int MANDA_WAVE_THREE = 9;
    private static final int MANDA_SECOND_WAVE_DELAY = 200;
    private static final int MANDA_THIRD_WAVE_DELAY = 300;
    private static final double MANDA_FAIL_DISTANCE_SQ = 400.0;
    private static final Map<UUID, GamabuntaTrial> GAMABUNTA_TRIALS = new HashMap<UUID, GamabuntaTrial>();
    private static final Map<UUID, MandaTrial> MANDA_TRIALS = new HashMap<UUID, MandaTrial>();
    private static final Map<UUID, KatsuyuTrial> KATSUYU_TRIALS = new HashMap<UUID, KatsuyuTrial>();

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (event.getSource() == null) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        NBTTagCompound data = player.getEntityData();
        if (event.getEntity() instanceof EntitySlime) {
            if (data.func_74762_e("toadQuestStage") == 1) {
                int kills = data.func_74762_e("toadQuestSlimeKills") + 1;
                data.func_74768_a("toadQuestSlimeKills", kills);
                if (kills >= data.func_74762_e("toadQuestSlimeTarget")) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.toad_hermit.slime_complete", new Object[0]));
                }
            }
        } else if (event.getEntity() instanceof EntityWitch) {
            if (data.func_74762_e("orochiQuestStage") == 3 && data.func_74762_e("orochiQuestWitchesRemaining") > 0) {
                int remaining = data.func_74762_e("orochiQuestWitchesRemaining") - 1;
                if (remaining < 0) {
                    remaining = 0;
                }
                data.func_74768_a("orochiQuestWitchesRemaining", remaining);
                if (remaining <= 0) {
                    data.func_74757_a("orochiQuestWitchesCleared", true);
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.orochi_apprentice.witches_cleared", new Object[0]));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.orochi_apprentice.witches_remaining", new Object[]{remaining}));
                }
            }
        } else if (event.getEntity() instanceof EntityCaveSpider) {
            SummonContractEvents.handleMandaSpiderDeath((EntityCaveSpider)event.getEntity(), player);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityGamabunta)) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
        GamabuntaTrial trial = GAMABUNTA_TRIALS.get(player.func_110124_au());
        if (trial == null) {
            return;
        }
        if (player.getEntityData().func_74762_e(GAMABUNTA_STAGE) != 1) {
            return;
        }
        trial.damageDealt = Math.min(50.0f, trial.damageDealt + event.getAmount());
        if (trial.damageDealt >= 50.0f) {
            SummonContractEvents.completeGamabuntaTrial(player, (EntityGamabunta)event.getEntityLiving());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        boolean handled = false;
        if (event.getTarget() instanceof EntityGamabunta) {
            handled = SummonContractEvents.handleGamabuntaInteraction(player, (EntityGamabunta)event.getTarget());
        } else if (event.getTarget() instanceof EntityManda) {
            handled = SummonContractEvents.handleMandaInteraction(player, (EntityManda)event.getTarget());
        } else if (event.getTarget() instanceof EntityKatsuyu) {
            handled = SummonContractEvents.handleKatsuyuInteraction(player, (EntityKatsuyu)event.getTarget());
        }
        if (handled) {
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.world.field_72995_K) {
            return;
        }
        World world = event.world;
        SummonContractEvents.updateGamabuntaTrials(world);
        SummonContractEvents.updateMandaTrials(world);
        SummonContractEvents.updateKatsuyuTrials(world);
        if (world.func_82737_E() % 200L != 0L) {
            return;
        }
        for (EntityPlayer player : world.field_73010_i) {
            SummonContractEvents.attemptSpawnHermit(world, player);
            SummonContractEvents.attemptSpawnApprentice(world, player);
            SummonContractEvents.attemptSpawnHealer(world, player);
        }
    }

    private static void attemptSpawnHermit(World world, EntityPlayer player) {
        Biome biome = world.func_180494_b(player.func_180425_c());
        if (biome != Biomes.field_76789_p && biome != Biomes.field_76788_q && biome != Biomes.field_76780_h && biome != Biomes.field_150599_m && biome != Biomes.field_76769_d && biome != Biomes.field_76786_s) {
            return;
        }
        if (world.field_73012_v.nextFloat() > 0.005f) {
            return;
        }
        if (!world.func_72872_a(EntityToadHermit.class, new AxisAlignedBB(player.func_180425_c()).func_186662_g(64.0)).isEmpty()) {
            return;
        }
        BlockPos pos = SummonContractEvents.findSurfaceSpawn(world, player.func_180425_c(), world.field_73012_v, 24);
        if (pos == null) {
            return;
        }
        EntityToadHermit hermit = new EntityToadHermit(world);
        hermit.func_110163_bv();
        hermit.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)hermit);
    }

    private static void attemptSpawnApprentice(World world, EntityPlayer player) {
        boolean inCave;
        BlockPos playerPos = player.func_180425_c();
        Biome biome = world.func_180494_b(playerPos);
        boolean inMountain = biome == Biomes.field_76770_e || biome == Biomes.field_150580_W || biome == Biomes.field_76783_v || biome == Biomes.field_185443_S || biome == Biomes.field_185434_af;
        boolean bl = inCave = playerPos.func_177956_o() < 40;
        if (!inMountain && !inCave) {
            return;
        }
        if (world.field_73012_v.nextFloat() > 0.005f) {
            return;
        }
        if (!world.func_72872_a(EntityOrochimaruApprentice.class, new AxisAlignedBB(playerPos).func_186662_g(64.0)).isEmpty()) {
            return;
        }
        BlockPos pos = SummonContractEvents.findCaveOrSurfaceSpawn(world, playerPos, world.field_73012_v, 24, inCave);
        if (pos == null) {
            return;
        }
        EntityOrochimaruApprentice apprentice = new EntityOrochimaruApprentice(world);
        apprentice.func_110163_bv();
        apprentice.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)apprentice);
    }

    private static void attemptSpawnHealer(World world, EntityPlayer player) {
        Biome biome = world.func_180494_b(player.func_180425_c());
        if (biome != Biomes.field_185444_T && biome != Biomes.field_76772_c) {
            return;
        }
        if (biome == Biomes.field_76772_c && world.field_73012_v.nextFloat() > 0.005f) {
            return;
        }
        if (biome == Biomes.field_185444_T && world.field_73012_v.nextFloat() > 0.005f) {
            return;
        }
        if (!world.func_72872_a(EntityHealer.class, new AxisAlignedBB(player.func_180425_c()).func_186662_g(64.0)).isEmpty()) {
            return;
        }
        BlockPos pos = SummonContractEvents.findSurfaceSpawn(world, player.func_180425_c(), world.field_73012_v, 16);
        if (pos == null) {
            return;
        }
        if (biome == Biomes.field_76772_c && !SummonContractEvents.hasNearbyFlowers(world, pos)) {
            return;
        }
        EntityHealer healer = new EntityHealer(world);
        healer.func_110163_bv();
        healer.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)healer);
    }

    private static boolean handleGamabuntaInteraction(EntityPlayer player, EntityGamabunta gamabunta) {
        NBTTagCompound data = player.getEntityData();
        if (!data.func_74767_n("toadQuestComplete")) {
            SummonContractEvents.issueWarning(player, (EntityLiving)gamabunta, GAMABUNTA_WARNINGS, "message.summon_contract.gamabunta.warn1", "message.summon_contract.gamabunta.warn2", "message.summon_contract.gamabunta.warn3");
            return true;
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null) {
            return true;
        }
        SummonBeast current = stats.getSummonBeast();
        if (current != null && current != SummonBeast.GAMABUNTA) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.different", new Object[]{current.getDisplayName()}));
            return true;
        }
        if (current == SummonBeast.GAMABUNTA) {
            data.func_74768_a(GAMABUNTA_STAGE, 3);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.already", new Object[]{SummonBeast.GAMABUNTA.getDisplayName()}));
            gamabunta.func_70106_y();
            return true;
        }
        int stage = data.func_74762_e(GAMABUNTA_STAGE);
        if (stage <= 0) {
            SummonContractEvents.startGamabuntaTrial(player, gamabunta);
            return true;
        }
        if (stage == 1) {
            GamabuntaTrial trial = GAMABUNTA_TRIALS.get(player.func_110124_au());
            int dealt = trial != null ? Math.round(trial.damageDealt) : 0;
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.gamabunta.progress", new Object[]{dealt, 50}));
            return true;
        }
        if (stage == 2) {
            SummonContractEvents.signSummonContract(player, SummonBeast.GAMABUNTA, (EntityLiving)gamabunta, GAMABUNTA_STAGE, GAMABUNTA_SPAWNED);
            return true;
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.already", new Object[]{SummonBeast.GAMABUNTA.getDisplayName()}));
        gamabunta.func_70106_y();
        return true;
    }

    private static boolean handleMandaInteraction(EntityPlayer player, EntityManda manda) {
        NBTTagCompound data = player.getEntityData();
        if (!data.func_74767_n("orochiQuestComplete")) {
            SummonContractEvents.issueWarning(player, (EntityLiving)manda, MANDA_WARNINGS, "message.summon_contract.manda.warn1", "message.summon_contract.manda.warn2", "message.summon_contract.manda.warn3");
            return true;
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null) {
            return true;
        }
        SummonBeast current = stats.getSummonBeast();
        if (current != null && current != SummonBeast.MANDA) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.different", new Object[]{current.getDisplayName()}));
            return true;
        }
        if (current == SummonBeast.MANDA) {
            data.func_74768_a(MANDA_STAGE, 3);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.already", new Object[]{SummonBeast.MANDA.getDisplayName()}));
            manda.func_70106_y();
            return true;
        }
        int stage = data.func_74762_e(MANDA_STAGE);
        if (stage <= 0) {
            SummonContractEvents.startMandaTrial(player, manda);
            return true;
        }
        if (stage == 1) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.manda.in_progress", new Object[0]));
            return true;
        }
        if (stage == 2) {
            SummonContractEvents.signSummonContract(player, SummonBeast.MANDA, (EntityLiving)manda, MANDA_STAGE, MANDA_SPAWNED);
            return true;
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.already", new Object[]{SummonBeast.MANDA.getDisplayName()}));
        manda.func_70106_y();
        return true;
    }

    private static boolean handleKatsuyuInteraction(EntityPlayer player, EntityKatsuyu katsuyu) {
        NBTTagCompound data = player.getEntityData();
        if (!data.func_74767_n("healerQuestComplete")) {
            SummonContractEvents.issueWarning(player, (EntityLiving)katsuyu, KATSUYU_WARNINGS, "message.summon_contract.katsuyu.warn1", "message.summon_contract.katsuyu.warn2", "message.summon_contract.katsuyu.warn3");
            return true;
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null) {
            return true;
        }
        SummonBeast current = stats.getSummonBeast();
        if (current != null && current != SummonBeast.KATSUYU) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.different", new Object[]{current.getDisplayName()}));
            return true;
        }
        if (current == SummonBeast.KATSUYU) {
            data.func_74768_a(KATSUYU_STAGE, 3);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.already", new Object[]{SummonBeast.KATSUYU.getDisplayName()}));
            katsuyu.func_70106_y();
            return true;
        }
        int stage = data.func_74762_e(KATSUYU_STAGE);
        if (stage <= 0) {
            SummonContractEvents.startKatsuyuTrial(player, katsuyu);
            return true;
        }
        if (stage == 1) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.katsuyu.in_progress", new Object[0]));
            return true;
        }
        if (stage == 2) {
            SummonContractEvents.signSummonContract(player, SummonBeast.KATSUYU, (EntityLiving)katsuyu, KATSUYU_STAGE, KATSUYU_SPAWNED);
            return true;
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.already", new Object[]{SummonBeast.KATSUYU.getDisplayName()}));
        katsuyu.func_70106_y();
        return true;
    }

    private static void startGamabuntaTrial(EntityPlayer player, EntityGamabunta gamabunta) {
        NBTTagCompound data = player.getEntityData();
        data.func_74768_a(GAMABUNTA_STAGE, 1);
        data.func_82580_o(GAMABUNTA_WARNINGS);
        GamabuntaTrial trial = new GamabuntaTrial();
        GAMABUNTA_TRIALS.put(player.func_110124_au(), trial);
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.gamabunta.start", new Object[]{50}));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.gamabunta.limit", new Object[]{30}));
        gamabunta.func_70606_j(gamabunta.func_110138_aP());
    }

    private static void completeGamabuntaTrial(EntityPlayer player, EntityGamabunta gamabunta) {
        NBTTagCompound data = player.getEntityData();
        data.func_74768_a(GAMABUNTA_STAGE, 2);
        GAMABUNTA_TRIALS.remove(player.func_110124_au());
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.gamabunta.complete", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.ready", new Object[]{SummonBeast.GAMABUNTA.getDisplayName()}));
        gamabunta.func_70606_j(gamabunta.func_110138_aP());
    }

    private static void failGamabuntaTrial(EntityPlayer player) {
        NBTTagCompound data = player.getEntityData();
        data.func_74768_a(GAMABUNTA_STAGE, 0);
        GAMABUNTA_TRIALS.remove(player.func_110124_au());
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.gamabunta.fail", new Object[0]));
    }

    private static void startMandaTrial(EntityPlayer player, EntityManda manda) {
        NBTTagCompound data = player.getEntityData();
        data.func_74768_a(MANDA_STAGE, 1);
        data.func_82580_o(MANDA_WARNINGS);
        MandaTrial trial = new MandaTrial();
        trial.center = manda.func_180425_c();
        MANDA_TRIALS.put(player.func_110124_au(), trial);
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.manda.start", new Object[0]));
        SummonContractEvents.spawnMandaWave(player.field_70170_p, player, trial, 3);
    }

    private static void spawnMandaWave(World world, EntityPlayer owner, MandaTrial trial, int count) {
        if (world.field_72995_K) {
            return;
        }
        if (trial.center == null) {
            trial.center = owner.func_180425_c();
        }
        trial.wave++;
        trial.spidersRemaining = count;
        trial.pendingNextWave = false;
        world.func_175726_f(trial.center);
        UUID ownerId = owner.func_110124_au();
        for (int i = 0; i < count; ++i) {
            EntityCaveSpider spider = new EntityCaveSpider(world);
            spider.func_110163_bv();
            spider.getEntityData().func_186854_a(MANDA_SPIDER_OWNER_TAG, ownerId);
            double angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            double distance = 3.0 + world.field_73012_v.nextDouble() * 4.0;
            double x = (double)trial.center.func_177958_n() + 0.5 + Math.cos(angle) * distance;
            double z = (double)trial.center.func_177952_p() + 0.5 + Math.sin(angle) * distance;
            spider.func_70012_b(x, (double)trial.center.func_177956_o(), z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            world.func_72838_d((Entity)spider);
        }
    }

    private static void handleMandaSpiderDeath(EntityCaveSpider spider, EntityPlayer killer) {
        if (spider.field_70170_p.field_72995_K) {
            return;
        }
        NBTTagCompound tag = spider.getEntityData();
        if (!tag.func_186855_b(MANDA_SPIDER_OWNER_TAG)) {
            return;
        }
        UUID ownerId = tag.func_186857_a(MANDA_SPIDER_OWNER_TAG);
        MandaTrial trial = MANDA_TRIALS.get(ownerId);
        if (trial == null) {
            return;
        }
        WorldServer world = (WorldServer)spider.field_70170_p;
        EntityPlayerMP owner = world.func_73046_m().func_184103_al().func_177451_a(ownerId);
        if (owner == null) {
            MANDA_TRIALS.remove(ownerId);
            return;
        }
        if (killer == null || !killer.func_110124_au().equals(ownerId)) {
            return;
        }
        if (owner.getEntityData().func_74762_e(MANDA_STAGE) != 1) {
            MANDA_TRIALS.remove(ownerId);
            return;
        }
        if (trial.spidersRemaining > 0) {
            trial.spidersRemaining = Math.max(0, trial.spidersRemaining - 1);
        }
        if (trial.spidersRemaining <= 0 && !trial.pendingNextWave) {
            if (trial.wave == 1) {
                trial.pendingNextWave = true;
                trial.ticksUntilNextWave = 200;
                owner.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.manda.wave_two", new Object[0]));
            } else if (trial.wave == 2) {
                trial.pendingNextWave = true;
                trial.ticksUntilNextWave = 300;
                owner.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.manda.wave_three", new Object[0]));
            } else if (trial.wave >= 3) {
                SummonContractEvents.completeMandaTrial((EntityPlayer)owner, trial);
            }
        }
    }

    private static void completeMandaTrial(EntityPlayer player, MandaTrial trial) {
        player.getEntityData().func_74768_a(MANDA_STAGE, 2);
        MANDA_TRIALS.remove(player.func_110124_au());
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.manda.complete", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.ready", new Object[]{SummonBeast.MANDA.getDisplayName()}));
        SummonContractEvents.removeMandaSpiders(player.field_70170_p, trial, player.func_110124_au());
    }

    private static void failMandaTrial(EntityPlayer player, MandaTrial trial, boolean distance) {
        player.getEntityData().func_74768_a(MANDA_STAGE, 0);
        MANDA_TRIALS.remove(player.func_110124_au());
        player.func_145747_a((ITextComponent)new TextComponentTranslation(distance ? "message.summon_contract.manda.fail_distance" : "message.summon_contract.manda.fail", new Object[0]));
        SummonContractEvents.removeMandaSpiders(player.field_70170_p, trial, player.func_110124_au());
    }

    private static void removeMandaSpiders(World world, MandaTrial trial, UUID ownerId) {
        if (trial == null || trial.center == null) {
            return;
        }
        AxisAlignedBB area = new AxisAlignedBB(trial.center).func_186662_g(32.0);
        for (EntityCaveSpider spider : world.func_72872_a(EntityCaveSpider.class, area)) {
            NBTTagCompound data = spider.getEntityData();
            if (!data.func_186855_b(MANDA_SPIDER_OWNER_TAG) || !ownerId.equals(data.func_186857_a(MANDA_SPIDER_OWNER_TAG))) continue;
            spider.func_70106_y();
        }
    }

    private static void startKatsuyuTrial(EntityPlayer player, EntityKatsuyu katsuyu) {
        NBTTagCompound data = player.getEntityData();
        data.func_74768_a(KATSUYU_STAGE, 1);
        data.func_82580_o(KATSUYU_WARNINGS);
        KatsuyuTrial trial = new KatsuyuTrial();
        EntitySlime slime = new EntitySlime(player.field_70170_p);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Size", 1);
        slime.func_70037_a(tag);
        slime.func_110163_bv();
        slime.func_94061_f(true);
        slime.func_70606_j(1.0f);
        slime.getEntityData().func_186854_a(KATSUYU_SLIME_OWNER_TAG, player.func_110124_au());
        slime.func_70012_b(katsuyu.field_70165_t + 2.0, katsuyu.field_70163_u, katsuyu.field_70161_v + 2.0, player.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
        player.field_70170_p.func_72838_d((Entity)slime);
        trial.slimeId = slime.func_110124_au();
        KATSUYU_TRIALS.put(player.func_110124_au(), trial);
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.katsuyu.start", new Object[0]));
    }

    private static void completeKatsuyuTrial(EntityPlayer player, KatsuyuTrial trial, EntitySlime slime) {
        player.getEntityData().func_74768_a(KATSUYU_STAGE, 2);
        if (slime != null) {
            slime.func_70106_y();
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.katsuyu.complete", new Object[0]));
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.ready", new Object[]{SummonBeast.KATSUYU.getDisplayName()}));
    }

    private static void failKatsuyuTrial(EntityPlayer player, KatsuyuTrial trial) {
        player.getEntityData().func_74768_a(KATSUYU_STAGE, 0);
        KATSUYU_TRIALS.remove(player.func_110124_au());
        EntitySlime slime = SummonContractEvents.getTrialSlime(player.field_70170_p, trial);
        if (slime != null) {
            slime.func_70106_y();
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.katsuyu.fail", new Object[0]));
    }

    private static EntitySlime getTrialSlime(World world, KatsuyuTrial trial) {
        if (!(world instanceof WorldServer) || trial == null || trial.slimeId == null) {
            return null;
        }
        Entity entity = ((WorldServer)world).func_175733_a(trial.slimeId);
        return entity instanceof EntitySlime ? (EntitySlime)entity : null;
    }

    private static void updateGamabuntaTrials(World world) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        Iterator<Map.Entry<UUID, GamabuntaTrial>> iterator = GAMABUNTA_TRIALS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, GamabuntaTrial> entry = iterator.next();
            EntityPlayerMP player = ((WorldServer)world).func_73046_m().func_184103_al().func_177451_a(entry.getKey());
            if (player == null) {
                iterator.remove();
                continue;
            }
            if (player.field_70170_p != world) continue;
            if (player.getEntityData().func_74762_e(GAMABUNTA_STAGE) != 1) {
                iterator.remove();
                continue;
            }
            GamabuntaTrial trial = entry.getValue();
            trial.ticksRemaining--;
            if (trial.ticksRemaining > 0) continue;
            SummonContractEvents.failGamabuntaTrial((EntityPlayer)player);
            iterator.remove();
        }
    }

    private static void updateMandaTrials(World world) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        Iterator<Map.Entry<UUID, MandaTrial>> iterator = MANDA_TRIALS.entrySet().iterator();
        while (iterator.hasNext()) {
            double distanceSq;
            Map.Entry<UUID, MandaTrial> entry = iterator.next();
            EntityPlayerMP player = ((WorldServer)world).func_73046_m().func_184103_al().func_177451_a(entry.getKey());
            if (player == null) {
                iterator.remove();
                continue;
            }
            if (player.field_70170_p != world) continue;
            if (player.getEntityData().func_74762_e(MANDA_STAGE) != 1) {
                iterator.remove();
                continue;
            }
            MandaTrial trial = entry.getValue();
            if (trial.center == null) {
                trial.center = player.func_180425_c();
            }
            if ((distanceSq = player.func_70092_e((double)trial.center.func_177958_n() + 0.5, (double)trial.center.func_177956_o(), (double)trial.center.func_177952_p() + 0.5)) > 400.0) {
                SummonContractEvents.failMandaTrial((EntityPlayer)player, trial, true);
                iterator.remove();
                continue;
            }
            if (!trial.pendingNextWave) continue;
            trial.ticksUntilNextWave--;
            if (trial.ticksUntilNextWave > 0) continue;
            if (trial.wave == 1) {
                SummonContractEvents.spawnMandaWave(world, (EntityPlayer)player, trial, 6);
                continue;
            }
            if (trial.wave != 2) continue;
            SummonContractEvents.spawnMandaWave(world, (EntityPlayer)player, trial, 9);
        }
    }

    private static void updateKatsuyuTrials(World world) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        Iterator<Map.Entry<UUID, KatsuyuTrial>> iterator = KATSUYU_TRIALS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, KatsuyuTrial> entry = iterator.next();
            EntityPlayerMP player = ((WorldServer)world).func_73046_m().func_184103_al().func_177451_a(entry.getKey());
            if (player == null) {
                iterator.remove();
                continue;
            }
            if (player.field_70170_p != world) continue;
            if (player.getEntityData().func_74762_e(KATSUYU_STAGE) != 1) {
                iterator.remove();
                continue;
            }
            KatsuyuTrial trial = entry.getValue();
            EntitySlime slime = SummonContractEvents.getTrialSlime(world, trial);
            if (slime == null || !slime.func_70089_S()) {
                SummonContractEvents.failKatsuyuTrial((EntityPlayer)player, trial);
                iterator.remove();
                continue;
            }
            if (!(slime.func_110143_aJ() >= slime.func_110138_aP() - 0.1f)) continue;
            SummonContractEvents.completeKatsuyuTrial((EntityPlayer)player, trial, slime);
            iterator.remove();
        }
    }

    private static void issueWarning(EntityPlayer player, EntityLiving entity, String warningKey, String ... messages) {
        int index;
        NBTTagCompound data = player.getEntityData();
        int warnings = data.func_74762_e(warningKey) + 1;
        data.func_74768_a(warningKey, warnings);
        if (messages != null && messages.length > 0 && (index = Math.min(messages.length, warnings) - 1) >= 0 && index < messages.length) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation(messages[index], new Object[0]));
        }
        if (warnings >= 3 && entity instanceof EntityCreature) {
            ((EntityCreature)entity).func_70624_b((EntityLivingBase)player);
        }
    }

    public static void prepareSummonBeast(EntityPlayerMP player, SummonBeast beast, BlockPos pos) {
        if (player == null || beast == null || pos == null) {
            return;
        }
        World world = player.field_70170_p;
        world.func_175726_f(pos);
        if (!SummonContractEvents.isBeastPresent(world, beast, pos)) {
            SummonContractEvents.spawnSummonBeast(world, beast, pos);
        }
        NBTTagCompound data = player.getEntityData();
        data.func_74768_a(SummonContractEvents.getStageKey(beast), 0);
        data.func_74757_a(SummonContractEvents.getSpawnFlag(beast), true);
        data.func_82580_o(SummonContractEvents.getWarningKey(beast));
        SummonContractEvents.clearTrial(player, beast);
    }

    private static void spawnSummonBeast(World world, SummonBeast beast, BlockPos pos) {
        try {
            EntityLiving entity = beast.getEntityClass().getConstructor(World.class).newInstance(world);
            entity.func_110163_bv();
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            world.func_72838_d((Entity)entity);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    private static boolean isBeastPresent(World world, SummonBeast beast, BlockPos pos) {
        AxisAlignedBB area = new AxisAlignedBB(pos).func_186662_g(8.0);
        return !world.func_72872_a(beast.getEntityClass(), area).isEmpty();
    }

    private static String getStageKey(SummonBeast beast) {
        switch (beast) {
            case GAMABUNTA: {
                return GAMABUNTA_STAGE;
            }
            case MANDA: {
                return MANDA_STAGE;
            }
            case KATSUYU: {
                return KATSUYU_STAGE;
            }
        }
        return GAMABUNTA_STAGE;
    }

    private static String getWarningKey(SummonBeast beast) {
        switch (beast) {
            case GAMABUNTA: {
                return GAMABUNTA_WARNINGS;
            }
            case MANDA: {
                return MANDA_WARNINGS;
            }
            case KATSUYU: {
                return KATSUYU_WARNINGS;
            }
        }
        return GAMABUNTA_WARNINGS;
    }

    private static String getSpawnFlag(SummonBeast beast) {
        switch (beast) {
            case GAMABUNTA: {
                return GAMABUNTA_SPAWNED;
            }
            case MANDA: {
                return MANDA_SPAWNED;
            }
            case KATSUYU: {
                return KATSUYU_SPAWNED;
            }
        }
        return GAMABUNTA_SPAWNED;
    }

    private static void clearTrial(EntityPlayerMP player, SummonBeast beast) {
        UUID id = player.func_110124_au();
        switch (beast) {
            case GAMABUNTA: {
                GAMABUNTA_TRIALS.remove(id);
                break;
            }
            case MANDA: {
                MandaTrial mandaTrial = MANDA_TRIALS.remove(id);
                if (mandaTrial == null) break;
                SummonContractEvents.removeMandaSpiders(player.field_70170_p, mandaTrial, id);
                break;
            }
            case KATSUYU: {
                EntitySlime slime;
                KatsuyuTrial katsuyuTrial = KATSUYU_TRIALS.remove(id);
                if (katsuyuTrial == null || (slime = SummonContractEvents.getTrialSlime(player.field_70170_p, katsuyuTrial)) == null) break;
                slime.func_70106_y();
            }
        }
    }

    private static void signSummonContract(EntityPlayer player, SummonBeast beast, EntityLiving entity, String stageKey, String spawnFlag) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null) {
            return;
        }
        SummonBeast current = stats.getSummonBeast();
        if (current != null && current != beast) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.different", new Object[]{current.getDisplayName()}));
            return;
        }
        if (current == beast) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.already", new Object[]{beast.getDisplayName()}));
            if (entity != null) {
                entity.func_70106_y();
            }
            return;
        }
        stats.setSummonBeast(beast);
        ModNetwork.sendTo(new MessageSyncStats(stats), (EntityPlayerMP)player);
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.summon_contract.signed", new Object[]{beast.getDisplayName()}));
        NBTTagCompound data = player.getEntityData();
        data.func_74768_a(stageKey, 3);
        data.func_74757_a(spawnFlag, false);
        if (entity != null) {
            entity.func_70106_y();
        }
        SummonContractEvents.clearTrial((EntityPlayerMP)player, beast);
    }

    private static BlockPos findSurfaceSpawn(World world, BlockPos center, Random rand, int radius) {
        for (int i = 0; i < 16; ++i) {
            BlockPos ground;
            int x = center.func_177958_n() + rand.nextInt(radius * 2 + 1) - radius;
            int z = center.func_177952_p() + rand.nextInt(radius * 2 + 1) - radius;
            BlockPos top = world.func_175672_r(new BlockPos(x, center.func_177956_o(), z));
            if (!world.func_175623_d(top) && world.func_180495_p(top).func_185904_a().func_76224_d() || !world.func_175665_u(ground = top.func_177977_b())) continue;
            return top;
        }
        return null;
    }

    private static BlockPos findCaveOrSurfaceSpawn(World world, BlockPos center, Random rand, int radius, boolean preferCave) {
        for (int i = 0; i < 16; ++i) {
            int x = center.func_177958_n() + rand.nextInt(radius * 2 + 1) - radius;
            int z = center.func_177952_p() + rand.nextInt(radius * 2 + 1) - radius;
            BlockPos base = new BlockPos(x, center.func_177956_o(), z);
            BlockPos pos = preferCave ? SummonContractEvents.findCaveFloor(world, base) : world.func_175672_r(base);
            if (pos == null || !world.func_175665_u(pos.func_177977_b())) continue;
            return pos;
        }
        return null;
    }

    private static BlockPos findCaveFloor(World world, BlockPos start) {
        for (int y = start.func_177956_o(); y > 10; --y) {
            BlockPos pos = new BlockPos(start.func_177958_n(), y, start.func_177952_p());
            if (world.func_175623_d(pos) || !world.func_175623_d(pos.func_177984_a())) continue;
            return pos.func_177984_a();
        }
        return null;
    }

    private static boolean hasNearbyFlowers(World world, BlockPos pos) {
        BlockPos min = pos.func_177982_a(-6, -1, -6);
        BlockPos max = pos.func_177982_a(6, 1, 6);
        int flowers = 0;
        Iterable blocks = BlockPos.func_177980_a((BlockPos)min, (BlockPos)max);
        for (BlockPos p : blocks) {
            if (world.func_175623_d(p) || !(world.func_180495_p(p).func_177230_c() instanceof BlockFlower) || ++flowers < 6) continue;
            return true;
        }
        return false;
    }

    public static void spawnQuestSpider(EntityPlayerMP player, BlockPos pos) {
        World world = player.field_70170_p;
        world.func_175726_f(pos);
        EntityQuestSpider spider = new EntityQuestSpider(world);
        spider.func_110163_bv();
        spider.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        spider.setSummonOwner((EntityPlayer)player);
        spider.setFollowing(false);
        world.func_72838_d((Entity)spider);
        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.orochi_apprentice.spider_hint", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
    }

    private SummonContractEvents() {
    }

    private static final class KatsuyuTrial {
        private UUID slimeId;

        private KatsuyuTrial() {
        }
    }

    private static final class MandaTrial {
        private int ticksUntilNextWave = 0;
        private int wave = 0;
        private int spidersRemaining = 0;
        private boolean pendingNextWave = false;
        private BlockPos center;

        private MandaTrial() {
        }
    }

    private static final class GamabuntaTrial {
        private int ticksRemaining = 600;
        private float damageDealt = 0.0f;

        private GamabuntaTrial() {
        }
    }
}

