/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.events;

import com.f1njo.sre.core.ModPotions;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TaijutsuDamageHandler {
    public TaijutsuDamageHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onUnarmedAttack(AttackEntityEvent event) {
        Entity target;
        if (event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!player.func_184614_ca().func_190926_b()) {
            return;
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null) {
            return;
        }
        int taijutsu = stats.getTaijutsu();
        int damage = taijutsu / 100;
        damage = Math.max(damage, 1);
        if (ModPotions.TWIN_LION_FISTS != null && player.func_70644_a(ModPotions.TWIN_LION_FISTS)) {
            damage = Math.max(damage, 5);
        }
        if ((target = event.getTarget()) instanceof EntityLivingBase) {
            int gateLevel;
            EntityLivingBase livingTarget = (EntityLivingBase)target;
            livingTarget.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)damage);
            livingTarget.func_70604_c((EntityLivingBase)player);
            if (livingTarget instanceof EntityCreature) {
                ((EntityCreature)livingTarget).func_70624_b((EntityLivingBase)player);
            }
            if ((gateLevel = player.getEntityData().func_74762_e("eightGatesLevel")) > 0) {
                float knockback = 0.5f * (float)gateLevel;
                Vec3d look = player.func_70040_Z();
                livingTarget.func_70653_a((Entity)player, knockback, -look.field_72450_a, -look.field_72449_c);
            }
        } else {
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (float)damage);
        }
        event.setCanceled(true);
    }
}

