/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.events;

import com.f1njo.sre.core.ModArmor;
import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatEvents;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class WeightTrainingHandler {
    private static final int TICKS_PER_LEVEL = 12000;
    private final Map<UUID, Vec3d> lastPositions = new HashMap<UUID, Vec3d>();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayer player = event.player;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
        if (!legs.func_190926_b() && legs.func_77973_b() == ModArmor.WEIGHT_LEGS) {
            boolean moving;
            player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 5, 1, false, false));
            Vec3d lastPos = this.lastPositions.get(player.func_110124_au());
            if (lastPos == null) {
                this.lastPositions.put(player.func_110124_au(), new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v));
                return;
            }
            double dx = player.field_70165_t - lastPos.field_72450_a;
            double dy = player.field_70163_u - lastPos.field_72448_b;
            double dz = player.field_70161_v - lastPos.field_72449_c;
            this.lastPositions.put(player.func_110124_au(), new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v));
            boolean bl = moving = dx * dx + dz * dz > 1.0E-4 || Math.abs(dy) > 0.001;
            if (moving) {
                int progress = player.getEntityData().func_74762_e("weightTrainingProgress");
                if (++progress >= 12000) {
                    progress = 0;
                    IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
                    if (stats != null && stats.getSpeed() < 25) {
                        stats.setSpeed(stats.getSpeed() + 1);
                        ModNetwork.sendTo(new MessageSyncStats(stats), (EntityPlayerMP)player);
                        PlayerStatEvents.applySpeedToPlayer(player);
                    }
                }
                player.getEntityData().func_74768_a("weightTrainingProgress", progress);
            }
        } else {
            this.lastPositions.remove(player.func_110124_au());
        }
    }
}

