/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.blocks.tile;

import com.f1njo.sre.core.ModItems;
import com.f1njo.sre.items.misc.ItemDNA;
import com.f1njo.sre.stats.Element;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityScholarsDesk
extends TileEntity
implements ITickable,
IInventory {
    public static final int SLOT_DECODE_INPUT = 0;
    public static final int SLOT_DECODE_OUTPUT = 1;
    public static final int SLOT_COMBINATION_START = 2;
    public static final int SLOT_COMBINATION_END = 4;
    public static final int SLOT_COMBINATION_OUTPUT = 5;
    private static final int INVENTORY_SIZE = 6;
    public static final int FIELD_DECODE_TIME = 0;
    public static final int FIELD_DECODE_TIME_TOTAL = 1;
    private static final int DECODE_TIME_TICKS = 48000;
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    private String customName;
    private int decodeTime;
    private float decodeProgressRemainder;

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        boolean wasDecoding = this.decodeTime > 0;
        boolean dirty = false;
        if (this.canDecode()) {
            float progress = this.getDecodeProgressPerTick();
            this.decodeProgressRemainder += progress;
            int progressTicks = (int)this.decodeProgressRemainder;
            if (progressTicks > 0) {
                this.decodeTime += progressTicks;
                this.decodeProgressRemainder -= (float)progressTicks;
            }
            if (this.decodeTime >= 48000) {
                this.decodeItem();
                this.decodeTime = 0;
                this.decodeProgressRemainder = 0.0f;
                dirty = true;
            }
        } else if (this.decodeTime != 0 || this.decodeProgressRemainder != 0.0f) {
            this.decodeTime = 0;
            this.decodeProgressRemainder = 0.0f;
            dirty = true;
        }
        if (this.updateCombinationOutput()) {
            dirty = true;
        }
        if (dirty || wasDecoding != this.decodeTime > 0) {
            this.func_70296_d();
        }
    }

    private boolean canDecode() {
        ItemStack input = (ItemStack)this.items.get(0);
        if (!this.isDecodeInput(input)) {
            return false;
        }
        ItemStack output = (ItemStack)this.items.get(1);
        return output.func_190926_b();
    }

    private void decodeItem() {
        ItemStack input = (ItemStack)this.items.get(0);
        if (!this.isDecodeInput(input)) {
            return;
        }
        ItemDNA dnaItem = (ItemDNA)ModItems.DNA;
        ItemStack result = new ItemStack(ModItems.DNA);
        if (this.field_145850_b.field_73012_v.nextFloat() <= this.getIdentificationChance()) {
            Element element = Element.values()[this.field_145850_b.field_73012_v.nextInt(Element.values().length)];
            dnaItem.identify(result, element);
        } else {
            dnaItem.markDamaged(result);
        }
        this.items.set(1, (Object)result);
        input.func_190918_g(1);
        if (input.func_190926_b()) {
            this.items.set(0, (Object)ItemStack.field_190927_a);
        }
    }

    private float getIdentificationChance() {
        int intelligence = this.getNearbyPlayerIntelligence();
        float chance = 0.02f + (float)intelligence / 100.0f * 0.73f;
        return MathHelper.func_76131_a((float)chance, (float)0.0f, (float)0.75f);
    }

    private float getDecodeProgressPerTick() {
        int intelligence = this.getNearbyPlayerIntelligence();
        return 1.0f + (float)intelligence / 100.0f;
    }

    private int getNearbyPlayerIntelligence() {
        if (this.field_145850_b == null) {
            return 0;
        }
        EntityPlayer player = this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 8.0, false);
        if (player == null) {
            return 0;
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats == null) {
            return 0;
        }
        return MathHelper.func_76125_a((int)stats.getIntelligence(), (int)0, (int)100);
    }

    private boolean updateCombinationOutput() {
        ItemStack current;
        ItemStack expected = ItemStack.field_190927_a;
        Element element = this.getCombinationElement();
        if (element != null) {
            expected = new ItemStack(ModItems.DNA);
            ((ItemDNA)ModItems.DNA).identify(expected, element);
        }
        if (!ItemStack.func_77989_b((ItemStack)(current = (ItemStack)this.items.get(5)), (ItemStack)expected)) {
            this.items.set(5, (Object)expected);
            return true;
        }
        return false;
    }

    private Element getCombinationElement() {
        ItemDNA dna = (ItemDNA)ModItems.DNA;
        Element element = null;
        for (int slot = 2; slot <= 4; ++slot) {
            ItemStack stack = (ItemStack)this.items.get(slot);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.DNA) {
                return null;
            }
            if (!dna.isIdentified(stack)) {
                return null;
            }
            Element stackElement = dna.getElement(stack);
            if (stackElement == null) {
                return null;
            }
            if (element == null) {
                element = stackElement;
                continue;
            }
            if (element == stackElement) continue;
            return null;
        }
        return element;
    }

    public void consumeCombinationInputs() {
        boolean consumed = false;
        for (int slot = 2; slot <= 4; ++slot) {
            ItemStack stack = (ItemStack)this.items.get(slot);
            if (stack.func_190926_b()) continue;
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                this.items.set(slot, (Object)ItemStack.field_190927_a);
            }
            consumed = true;
        }
        if (consumed) {
            this.updateCombinationOutput();
            this.func_70296_d();
        }
    }

    public boolean isDecodeInput(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() != ModItems.DNA) {
            return false;
        }
        return !((ItemDNA)ModItems.DNA).isProcessed(stack);
    }

    public boolean isCombinationInput(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() != ModItems.DNA) {
            return false;
        }
        return ((ItemDNA)ModItems.DNA).isIdentified(stack);
    }

    public int getDecodeProgressScaled(int pixels) {
        return this.decodeTime * pixels / 48000;
    }

    public int func_70302_i_() {
        return 6;
    }

    public boolean func_191420_l() {
        return this.items.stream().allMatch(ItemStack::func_190926_b);
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
        if (index >= 2 && index <= 5) {
            this.updateCombinationOutput();
        }
        if (!stack.func_190926_b()) {
            this.func_70296_d();
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = ItemStackHelper.func_188383_a(this.items, (int)index);
        if (index >= 2 && index <= 5) {
            this.updateCombinationOutput();
        }
        if (!stack.func_190926_b()) {
            this.func_70296_d();
        }
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0) {
            this.decodeTime = 0;
            this.decodeProgressRemainder = 0.0f;
        }
        if (index >= 2 && index <= 5) {
            this.updateCombinationOutput();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return false;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return this.isDecodeInput(stack);
        }
        if (index == 1 || index == 5) {
            return false;
        }
        if (index >= 2 && index <= 4) {
            return this.isCombinationInput(stack);
        }
        return false;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.decodeTime;
            }
            case 1: {
                return 48000;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        if (id == 0) {
            this.decodeTime = value;
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
        this.items = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
        this.updateCombinationOutput();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.scholars_desk";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("DecodeTime", this.decodeTime);
        compound.func_74776_a("DecodeProgressRemainder", this.decodeProgressRemainder);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.items);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.items = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.items);
        this.decodeTime = compound.func_74762_e("DecodeTime");
        this.decodeProgressRemainder = compound.func_74760_g("DecodeProgressRemainder");
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.updateCombinationOutput();
    }

    public int getDecodeTime() {
        return this.decodeTime;
    }

    public int getTotalDecodeTime() {
        return 48000;
    }
}

