/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.jutsu;

import com.f1njo.sre.chakra.api.IChakra;
import com.f1njo.sre.chakra.impl.ChakraProvider;
import com.f1njo.sre.core.ModNetwork;
import com.f1njo.sre.main.ShinobiTab;
import com.f1njo.sre.network.stats.MessageSyncStats;
import com.f1njo.sre.stats.Element;
import com.f1njo.sre.stats.IPlayerStats;
import com.f1njo.sre.stats.PlayerStatsProvider;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public abstract class ItemJutsu
extends Item {
    private static final String NBT_OWNER_UUID = "OwnerUUID";
    private static final String NBT_OWNER_NAME = "OwnerName";

    public ItemJutsu() {
        this.func_77625_d(1);
        this.func_77637_a(ShinobiTab.INSTANCE);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        this.ensureOwner(stack, player);
        if (!this.isOwner(stack, player)) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"tooltip.owner", (Object[])new Object[]{this.getOwnerName(stack)})));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!this.hasRequiredElement(player)) {
            if (!world.field_72995_K) {
                TextComponentString msg = new TextComponentString(I18n.func_135052_a((String)"message.missing_element", (Object[])new Object[]{String.valueOf((Object)this.getRequiredElement())}));
                player.func_145747_a((ITextComponent)msg);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!this.hasRequiredMastery(player)) {
            if (!world.field_72995_K) {
                TextComponentString msg = new TextComponentString(I18n.func_135052_a((String)"message.missing_mastery", (Object[])new Object[]{String.valueOf(this.getRequiredMastery()), String.valueOf((Object)this.getRequiredElement())}));
                player.func_145747_a((ITextComponent)msg);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (this.canUseJutsu(player)) {
            this.performJutsu(world, player);
            if (!world.field_72995_K) {
                this.onJutsuUsed(player);
            }
        } else if (!world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.not_enough_chakra", (Object[])new Object[0])));
        }
        player.func_184609_a(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    protected boolean canUseJutsu(EntityPlayer player) {
        IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
        if (chakra != null) {
            return chakra.getChakra() >= this.getChakraCost();
        }
        return false;
    }

    protected void onJutsuUsed(EntityPlayer player) {
        IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
        if (chakra != null) {
            chakra.consumeChakra(this.getChakraCost());
        }
        if (chakra != null) {
            chakra.consumeChakra(this.getChakraCost());
        }
        if (!player.field_70170_p.field_72995_K) {
            this.increaseElementMastery(player);
            TextComponentString msg = new TextComponentString(this.getJutsuName());
            msg.func_150256_b().func_150238_a(this.getChatColor());
            player.func_145747_a((ITextComponent)msg);
            player.func_184811_cZ().func_185145_a((Item)this, this.getCooldown());
        }
    }

    public String getJutsuName() {
        return I18n.func_135052_a((String)(this.func_77658_a() + ".name"), (Object[])new Object[0]);
    }

    protected TextFormatting getChatColor() {
        return TextFormatting.WHITE;
    }

    protected int getChakraCost() {
        return 0;
    }

    protected int getCooldown() {
        return 0;
    }

    @Nullable
    protected Element getRequiredElement() {
        return null;
    }

    protected boolean hasRequiredElement(EntityPlayer player) {
        Element element = this.getRequiredElement();
        if (element == null) {
            return true;
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        return stats != null && stats.hasElement(element);
    }

    protected int getRequiredMastery() {
        return 0;
    }

    protected int getMasteryIncrease() {
        return 1;
    }

    protected boolean hasRequiredMastery(EntityPlayer player) {
        Element element = this.getRequiredElement();
        if (element == null) {
            return true;
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        return stats != null && stats.getElementMastery(element) >= this.getRequiredMastery();
    }

    protected void increaseElementMastery(EntityPlayer player) {
        int newVal;
        int maxForJutsu;
        int current;
        Element element = this.getRequiredElement();
        if (element == null) {
            return;
        }
        IPlayerStats stats = (IPlayerStats)player.getCapability(PlayerStatsProvider.STATS_CAP, null);
        if (stats != null && (current = stats.getElementMastery(element)) < (maxForJutsu = Math.min(100, this.getRequiredMastery() + 20)) && (newVal = Math.min(maxForJutsu, current + this.getMasteryIncrease())) != current) {
            stats.setElementMastery(element, newVal);
            if (player instanceof EntityPlayerMP) {
                ModNetwork.sendTo(new MessageSyncStats(stats), (EntityPlayerMP)player);
            }
        }
    }

    protected abstract void performJutsu(World var1, EntityPlayer var2);

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K && entityIn instanceof EntityPlayer) {
            this.ensureOwner(stack, (EntityPlayer)entityIn);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String owner = this.getOwnerName(stack);
        tooltip.add(I18n.func_135052_a((String)"tooltip.owner", (Object[])new Object[]{owner}));
    }

    protected boolean isOwner(ItemStack stack, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_186855_b(NBT_OWNER_UUID)) {
            return false;
        }
        UUID uuid = tag.func_186857_a(NBT_OWNER_UUID);
        return uuid.equals(player.func_110124_au());
    }

    protected void ensureOwner(ItemStack stack, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_186854_a(NBT_OWNER_UUID, player.func_110124_au());
            tag.func_74778_a(NBT_OWNER_NAME, player.func_70005_c_());
            stack.func_77982_d(tag);
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_186855_b(NBT_OWNER_UUID)) {
            tag.func_186854_a(NBT_OWNER_UUID, player.func_110124_au());
            tag.func_74778_a(NBT_OWNER_NAME, player.func_70005_c_());
        }
    }

    protected String getOwnerName(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_OWNER_NAME)) {
            return stack.func_77978_p().func_74779_i(NBT_OWNER_NAME);
        }
        return "-";
    }
}

