/*
 * Decompiled with CFR 0.152.
 */
package com.f1njo.sre.items.jutsu;

import com.f1njo.sre.chakra.api.IChakra;
import com.f1njo.sre.chakra.impl.ChakraProvider;
import com.f1njo.sre.entities.jutsu.EntityShadowClone;
import com.f1njo.sre.items.jutsu.ItemJutsu;
import com.f1njo.sre.main.ShinobiTab;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemShadowCloneJutsu
extends ItemJutsu {
    private static final int BASE_CHAKRA_COST = 25;
    private static final int MAX_CLONES = 9;
    private static final int TICKS_PER_CLONE = 5;

    public ItemShadowCloneJutsu() {
        this.func_77637_a(ShinobiTab.INSTANCE);
        this.func_77625_d(1);
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        this.ensureOwner(stack, player);
        if (!this.isOwner(stack, player)) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"tooltip.owner", (Object[])new Object[]{this.getOwnerName(stack)})));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!this.hasRequiredElement(player)) {
            if (!world.field_72995_K) {
                TextComponentString missMsg = new TextComponentString(I18n.func_135052_a((String)"message.missing_element", (Object[])new Object[]{String.valueOf((Object)this.getRequiredElement())}));
                missMsg.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)missMsg);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (this.getAvailableClones(player, 1) >= 1) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (!world.field_72995_K) {
            TextComponentString chakraMsg = new TextComponentString(I18n.func_135052_a((String)"message.not_enough_chakra", (Object[])new Object[0]));
            chakraMsg.func_150256_b().func_150238_a(TextFormatting.RED);
            player.func_145747_a((ITextComponent)chakraMsg);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        this.func_77615_a(stack, world, entityLiving, 0);
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entityLiving, int count) {
        super.onUsingTick(stack, entityLiving, count);
        if (!(entityLiving instanceof EntityPlayer)) {
            entityLiving.func_184597_cx();
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        int elapsed = this.func_77626_a(stack) - count;
        int desiredClones = Math.min(9, 1 + elapsed / 5);
        int affordable = this.getAvailableClones(player, desiredClones);
        if (affordable < desiredClones) {
            if (!player.field_70170_p.field_72995_K) {
                TextComponentString msg = new TextComponentString(I18n.func_135052_a((String)"message.not_enough_chakra", (Object[])new Object[0]));
                msg.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_145747_a((ITextComponent)msg);
            }
            player.func_184597_cx();
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        super.func_77615_a(stack, world, entityLiving, timeLeft);
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (world.field_72995_K) {
            return;
        }
        int elapsed = this.func_77626_a(stack) - timeLeft;
        int requestedClones = Math.min(9, 1 + elapsed / 5);
        int cloneCount = this.getAvailableClones(player, requestedClones);
        if (cloneCount < 1) {
            TextComponentString chakraMsg = new TextComponentString(I18n.func_135052_a((String)"message.not_enough_chakra", (Object[])new Object[0]));
            chakraMsg.func_150256_b().func_150238_a(TextFormatting.RED);
            player.func_145747_a((ITextComponent)chakraMsg);
            return;
        }
        this.spawnClones(world, player, cloneCount);
        this.consumeChakraAndNotify(player, cloneCount);
    }

    @Override
    protected void performJutsu(World world, EntityPlayer player) {
        this.spawnClones(world, player, 1);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"item.shadow_clone_jutsu.desc1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"tooltip.chakra_cost", (Object[])new Object[]{String.valueOf(this.getChakraCost())}));
    }

    @Override
    protected int getChakraCost() {
        return 25;
    }

    private void spawnClones(World world, EntityPlayer player, int cloneCount) {
        if (world.field_72995_K) {
            return;
        }
        double radius = 1.5;
        float baseAngle = (float)Math.toRadians(player.field_70177_z);
        double angleStep = Math.PI * 2 / (double)cloneCount;
        for (int i = 0; i < cloneCount; ++i) {
            double angle = (double)baseAngle + angleStep * (double)i;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            EntityShadowClone clone = new EntityShadowClone(world, player);
            clone.func_70107_b(player.field_70165_t + offsetX, player.field_70163_u, player.field_70161_v + offsetZ);
            world.func_72838_d((Entity)clone);
        }
    }

    private int getAvailableClones(EntityPlayer player, int requestedClones) {
        IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
        if (chakra == null) {
            return 0;
        }
        int maxByChakra = chakra.getChakra() / 25;
        return Math.min(requestedClones, Math.min(9, maxByChakra));
    }

    private void consumeChakraAndNotify(EntityPlayer player, int cloneCount) {
        IChakra chakra = (IChakra)player.getCapability(ChakraProvider.CHAKRA_CAP, null);
        if (chakra != null) {
            chakra.consumeChakra(cloneCount * 25);
        }
        this.increaseElementMastery(player);
        TextComponentString msg = new TextComponentString(this.getJutsuName());
        msg.func_150256_b().func_150238_a(this.getChatColor());
        player.func_145747_a((ITextComponent)msg);
        player.func_184811_cZ().func_185145_a((Item)this, this.getCooldown());
    }

    @Override
    public String getJutsuName() {
        return super.getJutsuName();
    }

    @Override
    protected int getCooldown() {
        return 100;
    }
}

